/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.domain;

import java.util.Objects;
import java.util.function.IntFunction;
import org.springframework.data.domain.ScrollPosition;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public final class OffsetScrollPosition
implements ScrollPosition {
    private static final OffsetScrollPosition INITIAL = new OffsetScrollPosition(0L);
    private final long offset;

    private OffsetScrollPosition(long offset) {
        Assert.isTrue((offset >= 0L ? 1 : 0) != 0, (String)"Offset must not be negative");
        this.offset = offset;
    }

    static OffsetScrollPosition initial() {
        return INITIAL;
    }

    static OffsetScrollPosition of(long offset) {
        return offset == 0L ? OffsetScrollPosition.initial() : new OffsetScrollPosition(offset);
    }

    public static IntFunction<OffsetScrollPosition> positionFunction(long startOffset) {
        Assert.isTrue((startOffset >= 0L ? 1 : 0) != 0, (String)"Start offset must not be negative");
        return startOffset == 0L ? OffsetPositionFunction.ZERO : new OffsetPositionFunction(startOffset);
    }

    public long getOffset() {
        return this.offset;
    }

    public OffsetScrollPosition advanceBy(long delta) {
        long value = this.offset + delta;
        return new OffsetScrollPosition(value < 0L ? 0L : value);
    }

    @Override
    public boolean isInitial() {
        return this.offset == 0L;
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof OffsetScrollPosition)) {
            return false;
        }
        OffsetScrollPosition that = (OffsetScrollPosition)o;
        return this.offset == that.offset;
    }

    public int hashCode() {
        return Objects.hash(this.offset);
    }

    public String toString() {
        return String.format("OffsetScrollPosition [%s]", this.offset);
    }

    private record OffsetPositionFunction(long startOffset) implements IntFunction<OffsetScrollPosition>
    {
        static final OffsetPositionFunction ZERO = new OffsetPositionFunction(0L);

        @Override
        public OffsetScrollPosition apply(int offset) {
            if (offset < 0) {
                throw new IndexOutOfBoundsException(offset);
            }
            return OffsetScrollPosition.of(this.startOffset + (long)offset + 1L);
        }
    }
}

