/*
 * Decompiled with CFR 0.152.
 */
package de.werum.sis.crypt;

import de.werum.sis.crypt.CipherExtractor;
import de.werum.sis.crypt.CipherPacker;
import de.werum.sis.crypt.CryptProperties;
import de.werum.sis.trace.ConsoleLogger;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import javax.crypto.Cipher;

public class RSACipherExtractor
implements CipherExtractor {
    private ConsoleLogger lg = ConsoleLogger.getInstance();
    private CryptProperties properties;

    public RSACipherExtractor(CryptProperties properties) {
        this.properties = properties;
    }

    public Cipher extractCipher(InputStream inputStream, boolean encrypt) throws GeneralSecurityException, IOException {
        Cipher rsa = Cipher.getInstance(this.properties.getAsymetricAlgorithm(CipherPacker.DEFAULT_CIPHER_PACKER_USER_ID_OBJ) + "/" + this.properties.getAsymetricOpMode(CipherPacker.DEFAULT_CIPHER_PACKER_USER_ID_OBJ) + "/" + this.properties.getAsymetricPadding(CipherPacker.DEFAULT_CIPHER_PACKER_USER_ID_OBJ), this.properties.getProviderName(CipherPacker.DEFAULT_CIPHER_PACKER_USER_ID_OBJ));
        rsa.init(encrypt ? 1 : 2, this.extractKey(inputStream));
        return rsa;
    }

    public Key extractKey(InputStream inputStream) throws GeneralSecurityException, IOException {
        Key key = null;
        ObjectInputStream o_is = new ObjectInputStream(inputStream);
        int keyKenn = o_is.readInt();
        Integer userId = new Integer(keyKenn);
        if (!this.properties.containsUserId(userId) || keyKenn != 402) {
            throw new GeneralSecurityException("RSACipherExtractor: Keine g\u00fcltige Crypt-UserId: " + userId + ".");
        }
        int keyDescriptor = o_is.readInt();
        int keyLength = o_is.readInt();
        byte[] keyBytes = new byte[keyLength];
        o_is.readFully(keyBytes, 0, keyLength);
        KeyFactory keyFactory = KeyFactory.getInstance(this.properties.getAsymetricAlgorithm(userId), this.properties.getProviderName(userId));
        if (keyDescriptor == 2) {
            key = keyFactory.generatePublic(new X509EncodedKeySpec(keyBytes));
        } else if (keyDescriptor == 3) {
            key = keyFactory.generatePrivate(new PKCS8EncodedKeySpec(keyBytes));
        } else {
            throw new GeneralSecurityException("RSACipherExtractor: Kein RSA-Schluessel (Deskriptor soll: 2,3 ist : " + keyDescriptor + ")");
        }
        return key;
    }
}

