/*
 * Decompiled with CFR 0.152.
 */
package de.statspez.sdf.generator.util;

import de.statspez.pleditor.generator.masken.KommaZahlMaske;
import de.statspez.pleditor.generator.masken.KommaZahlMaskenParser;
import de.statspez.pleditor.generator.masken.MaskeException;
import de.statspez.sdf.generator.meta.MetaCustomSDFFeldReferenz;
import de.statspez.sdf.generator.meta.MetaCustomSDFMerkmal;
import de.statspez.sdf.generator.meta.generated.MetaPLAuspraegung;
import de.statspez.sdf.generator.meta.generated.MetaSDFMerkmal;
import de.statspez.sdf.generator.util.DateTime;
import java.util.Iterator;

public class SDFUtil {
    public static final int UNDEFINED = -1;
    public static final int UNBOUNDED = -1;
    public static final char DEFAULT_DECIMAL_SEPARATOR = ',';
    public static final char DEFAULT_THOUSAND_GROUP_SEPARATOR = '.';
    public static final String UNITID_VARIABLE_NAME = new String("BerichtseinheitID");

    public static int getMinOccurs(String occurs) {
        int minOccurs;
        if (occurs == null || occurs.length() == 0) {
            minOccurs = -1;
        } else {
            try {
                minOccurs = Integer.parseInt(occurs);
                if (minOccurs < 0) {
                    minOccurs = -1;
                }
            }
            catch (Exception e) {
                minOccurs = -1;
            }
        }
        return minOccurs;
    }

    public static int getMaxOccurs(String occurs) {
        int maxOccurs;
        if (occurs == null || occurs.length() == 0 || occurs.equalsIgnoreCase("unbounded")) {
            maxOccurs = -1;
        } else {
            try {
                maxOccurs = Integer.parseInt(occurs);
                if (maxOccurs < 1) {
                    maxOccurs = -1;
                }
            }
            catch (Exception e) {
                maxOccurs = -1;
            }
        }
        return maxOccurs;
    }

    public static String getMaxOccursAsText(String occurs) {
        int maxOccurs = SDFUtil.getMaxOccurs(occurs);
        String maxOccursAsText = maxOccurs == -1 ? "unbegrenzt" : String.valueOf(maxOccurs);
        return maxOccursAsText;
    }

    public static String getReferenceField(Iterator referenceHirarchy) {
        StringBuffer buffer = new StringBuffer();
        while (referenceHirarchy != null && referenceHirarchy.hasNext()) {
            MetaCustomSDFFeldReferenz field = (MetaCustomSDFFeldReferenz)referenceHirarchy.next();
            buffer.append(field.getReferenceName());
            if (!referenceHirarchy.hasNext()) continue;
            buffer.append(".");
        }
        return buffer.toString();
    }

    public static String getDateTimeEncoded(DateTime dateTime) {
        StringBuffer buffer = new StringBuffer();
        if (dateTime.getYear() < 1000) {
            buffer.append(dateTime.getYear() + 2000);
        } else {
            buffer.append(dateTime.getYear());
        }
        if (dateTime.getHalfOfYear() > 0) {
            buffer.append("H");
            buffer.append(dateTime.getHalfOfYear());
        } else if (dateTime.getSemester() > 0) {
            buffer.append("S");
            buffer.append(dateTime.getSemester());
        } else if (dateTime.getQuarterOfYear() > 0) {
            buffer.append("Q");
            buffer.append(dateTime.getQuarterOfYear());
        } else if (dateTime.getMonth() > 0) {
            if (dateTime.getMonth() < 10) {
                buffer.append("0");
            }
            buffer.append(dateTime.getMonth());
            if (dateTime.getDay() > 0) {
                if (dateTime.getDay() < 10) {
                    buffer.append("0");
                }
                buffer.append(dateTime.getDay());
            }
        } else if (dateTime.getWeekOfYear() > 0) {
            buffer.append("W");
            if (dateTime.getWeekOfYear() < 10) {
                buffer.append("0");
            }
            buffer.append(dateTime.getWeekOfYear());
        }
        return buffer.toString();
    }

    public static DateTime getDateTime(String dateTimeEncoded) {
        DateTime dateTime;
        block16: {
            if (dateTimeEncoded != null && dateTimeEncoded.length() > 3) {
                dateTime = new DateTime();
                try {
                    dateTime.setYear(Integer.parseInt(dateTimeEncoded.substring(0, 4)));
                    if (dateTimeEncoded.length() <= 4) break block16;
                    switch (dateTimeEncoded.charAt(4)) {
                        case 'H': {
                            if (dateTimeEncoded.length() > 5) {
                                dateTime.setHalfOfYear(Integer.parseInt(dateTimeEncoded.substring(5, 6)));
                            }
                            break;
                        }
                        case 'S': {
                            if (dateTimeEncoded.length() > 5) {
                                dateTime.setSemester(Integer.parseInt(dateTimeEncoded.substring(5, 6)));
                            }
                            break;
                        }
                        case 'Q': {
                            if (dateTimeEncoded.length() > 5) {
                                dateTime.setQuarterOfYear(Integer.parseInt(dateTimeEncoded.substring(5, 6)));
                            }
                            break;
                        }
                        case 'W': {
                            if (dateTimeEncoded.length() > 6) {
                                dateTime.setWeekOfYear(Integer.parseInt(dateTimeEncoded.substring(5, 7)));
                            }
                            break;
                        }
                        default: {
                            if (dateTimeEncoded.length() > 5) {
                                dateTime.setMonth(Integer.parseInt(dateTimeEncoded.substring(4, 6)));
                            }
                            if (dateTimeEncoded.length() > 7) {
                                dateTime.setDay(Integer.parseInt(dateTimeEncoded.substring(6, 8)));
                            }
                            break;
                        }
                    }
                }
                catch (NumberFormatException e) {
                    dateTime = null;
                }
            } else {
                dateTime = null;
            }
        }
        return dateTime;
    }

    public static String getDateTimeAsText(DateTime dateTime) {
        StringBuffer buffer = new StringBuffer();
        if (dateTime.getHalfOfYear() > 0) {
            buffer.append(dateTime.getHalfOfYear());
            buffer.append(". Halbjahr ");
        } else if (dateTime.getSemester() > 0) {
            if (dateTime.getSemester() == 1) {
                buffer.append("Sommersemester ");
            } else {
                buffer.append("Wintersemester ");
            }
        } else if (dateTime.getQuarterOfYear() > 0) {
            buffer.append(dateTime.getQuarterOfYear());
            buffer.append(". Quartal ");
        } else if (dateTime.getMonth() > 0) {
            if (dateTime.getDay() > 0) {
                buffer.append(dateTime.getDay());
                buffer.append(". ");
            }
            switch (dateTime.getMonth()) {
                case 1: {
                    buffer.append("Januar");
                    break;
                }
                case 2: {
                    buffer.append("Februar");
                    break;
                }
                case 3: {
                    buffer.append("M\u00e4rz");
                    break;
                }
                case 4: {
                    buffer.append("April");
                    break;
                }
                case 5: {
                    buffer.append("Mai");
                    break;
                }
                case 6: {
                    buffer.append("Juni");
                    break;
                }
                case 7: {
                    buffer.append("Juli");
                    break;
                }
                case 8: {
                    buffer.append("August");
                    break;
                }
                case 9: {
                    buffer.append("September");
                    break;
                }
                case 10: {
                    buffer.append("Oktober");
                    break;
                }
                case 11: {
                    buffer.append("November");
                    break;
                }
                case 12: {
                    buffer.append("Dezember");
                }
            }
            buffer.append(" ");
        } else if (dateTime.getWeekOfYear() > 0) {
            buffer.append(dateTime.getWeekOfYear());
            buffer.append(". Kalenderwoche ");
        }
        if (dateTime.getYear() < 1000) {
            buffer.append(dateTime.getYear() + 2000);
        } else {
            buffer.append(dateTime.getYear());
        }
        return buffer.toString();
    }

    public static String getDateTimeAsText(String dateTimeEncoded) {
        DateTime dateTime = SDFUtil.getDateTime(dateTimeEncoded);
        String dateTimeReadable = dateTime != null ? SDFUtil.getDateTimeAsText(dateTime) : null;
        return dateTimeReadable;
    }

    public static String getReferencePeriodAsText(int referencePeriodType, String referencePeriodStart, String referencePeriodEnd) {
        String text;
        switch (referencePeriodType) {
            case 1: {
                text = SDFUtil.getDateTimeAsText(referencePeriodStart);
                break;
            }
            case 2: {
                text = "ab " + SDFUtil.getDateTimeAsText(referencePeriodStart);
                break;
            }
            case 3: {
                text = "ab " + SDFUtil.getDateTimeAsText(referencePeriodStart) + " bis " + SDFUtil.getDateTimeAsText(referencePeriodEnd);
                break;
            }
            default: {
                text = "unbekannt";
            }
        }
        return text;
    }

    public static String getPeriodicityTypeAsText(int periodicityType, String periodicity) {
        String text;
        switch (periodicityType) {
            case 1: {
                if (periodicity == null || periodicity.length() == 0 || periodicity.equals("1")) {
                    text = "j\u00e4hrlich";
                    break;
                }
                text = "alle " + periodicity + " Jahre";
                break;
            }
            case 2: {
                if (periodicity == null || periodicity.length() == 0 || periodicity.equals("1")) {
                    text = "monatlich";
                    break;
                }
                if (periodicity.equals("3")) {
                    text = "viertelj\u00e4hrlich";
                    break;
                }
                if (periodicity.equals("6")) {
                    text = "halbj\u00e4hrlich";
                    break;
                }
                text = "alle " + periodicity + " Monate";
                break;
            }
            case 3: {
                if (periodicity == null || periodicity.length() == 0 || periodicity.equals("1")) {
                    text = "w\u00f6chentlich";
                    break;
                }
                text = "alle " + periodicity + " Wochen";
                break;
            }
            case 4: {
                if (periodicity == null || periodicity.length() == 0 || periodicity.equals("1")) {
                    text = "t\u00e4glich";
                    break;
                }
                text = "alle " + periodicity + " Tage";
                break;
            }
            default: {
                text = "unbekannt";
            }
        }
        return text;
    }

    public static String getConditionTypeAsText(short type) {
        String result;
        switch (type) {
            case 3: {
                result = "Vorbedingung";
                break;
            }
            case 2: {
                result = "Strikte Bedingung";
                break;
            }
            case 1: {
                result = "Weiche Bedingung";
                break;
            }
            default: {
                result = "Unbekannter Typ";
            }
        }
        return result;
    }

    public static String getTypeAsText(short type) {
        String result;
        switch (type) {
            case 5: {
                result = "Ganzzahl";
                break;
            }
            case 4: {
                result = "Kommazahl";
                break;
            }
            case 6: {
                result = "Nicht negative Ganzzahl";
                break;
            }
            case 7: {
                result = "Positive Ganzzahl";
                break;
            }
            case 8: {
                result = "Datum";
                break;
            }
            case 1: {
                result = "Zeichenkette";
                break;
            }
            case 2: {
                result = "Normierte Zeichenkette";
                break;
            }
            case 3: {
                result = "Terminalsymbol";
                break;
            }
            default: {
                result = "Unbekannter Typ";
            }
        }
        return result;
    }

    public static String getFormatAsText(MetaSDFMerkmal merkmal) {
        StringBuffer buffer = new StringBuffer();
        if (merkmal.getTyp() == 4 || merkmal.getTyp() == 5 || merkmal.getTyp() == 7 || merkmal.getTyp() == 6) {
            if (merkmal.getMaske() != null && merkmal.getMaske().length() > 0) {
                try {
                    KommaZahlMaskenParser parser = new KommaZahlMaskenParser();
                    KommaZahlMaske makse = (KommaZahlMaske)parser.parse(merkmal.getMaske());
                    int i = 0;
                    while (i < makse.getVorkommastellen()) {
                        buffer.append("#");
                        ++i;
                    }
                    if (makse.getNachkommastellen() > 0) {
                        buffer.append(".");
                        i = 0;
                        while (i < makse.getNachkommastellen()) {
                            buffer.append("#");
                            ++i;
                        }
                    }
                }
                catch (MaskeException e) {
                    buffer.append(merkmal.getMaske());
                }
            }
        } else if (merkmal.getMaske() != null && merkmal.getMaske().length() > 0) {
            buffer.append(merkmal.getMaske());
        }
        String format = buffer.length() > 0 ? buffer.toString() : null;
        return format;
    }

    public static String getValueSpaceAsText(MetaSDFMerkmal merkmal) {
        StringBuffer buffer = new StringBuffer();
        if (merkmal.getKlasseWertebereich() != null) {
            int num = merkmal.getKlasseWertebereich().getAuspraegungsComps().sizeOfAuspraegungen();
            if (num > 0) {
                Iterator iter = merkmal.getKlasseWertebereich().getAuspraegungsComps().getAuspraegungen();
                while (iter.hasNext()) {
                    MetaPLAuspraegung auspraegung = (MetaPLAuspraegung)iter.next();
                    buffer.append(auspraegung.getFachschluessel());
                    if (num <= 3) {
                        buffer.append(" - ");
                        buffer.append(auspraegung.getName());
                    } else if (buffer.length() > 40) {
                        buffer.append(" ...");
                        break;
                    }
                    if (!iter.hasNext()) continue;
                    buffer.append(", ");
                }
            }
        } else if (merkmal.getWertebereich() != null && merkmal.getWertebereich().length() > 0) {
            if (merkmal.getWertTyp() == 1) {
                String wertebereich = "";
                int i = 0;
                while (i < merkmal.getWertebereich().length()) {
                    if (merkmal.getWertebereich().startsWith("--", i)) {
                        if (!wertebereich.endsWith(" ")) {
                            wertebereich = String.valueOf(wertebereich) + " ";
                        }
                        wertebereich = String.valueOf(wertebereich) + "< x < ";
                        ++i;
                    } else if (merkmal.getWertebereich().startsWith("++", i)) {
                        if (!wertebereich.endsWith(" ")) {
                            wertebereich = String.valueOf(wertebereich) + " ";
                        }
                        wertebereich = String.valueOf(wertebereich) + "<= x <= ";
                        ++i;
                    } else if (merkmal.getWertebereich().startsWith("+-", i)) {
                        if (!wertebereich.endsWith(" ")) {
                            wertebereich = String.valueOf(wertebereich) + " ";
                        }
                        wertebereich = String.valueOf(wertebereich) + "<= x < ";
                        ++i;
                    } else if (merkmal.getWertebereich().startsWith("-+", i)) {
                        if (!wertebereich.endsWith(" ")) {
                            wertebereich = String.valueOf(wertebereich) + " ";
                        }
                        wertebereich = String.valueOf(wertebereich) + "< x <= ";
                        ++i;
                    } else {
                        char charAtI = merkmal.getWertebereich().charAt(i);
                        if (charAtI == ' ') {
                            if (!wertebereich.endsWith(" ")) {
                                wertebereich = String.valueOf(wertebereich) + " ";
                            }
                        } else {
                            wertebereich = String.valueOf(wertebereich) + charAtI;
                        }
                    }
                    ++i;
                }
                if (wertebereich.length() > 40) {
                    String[] bereiche = wertebereich.split(",");
                    int i2 = 0;
                    while (i2 < bereiche.length) {
                        if (i2 > 0) {
                            buffer.append(", ");
                        }
                        if (buffer.length() >= 40) {
                            buffer.append("...");
                            break;
                        }
                        buffer.append(bereiche[i2].trim());
                        ++i2;
                    }
                } else {
                    buffer.append(wertebereich);
                }
            } else {
                buffer.append(merkmal.getWertebereich());
            }
        }
        String valueSpace = buffer.length() > 0 ? buffer.toString() : null;
        return valueSpace;
    }

    public static String getNormalizedValue(String value, MetaCustomSDFMerkmal feature, char decimalSeparator, char thousandGroupSeparator) {
        String normalizedValue = value;
        if (normalizedValue != null && normalizedValue.length() > 0) {
            boolean number;
            boolean specialString = feature.getTyp() == 2 || feature.getTyp() == 3;
            boolean bl = number = feature.getTyp() == 4 || feature.getTyp() == 5 || feature.getTyp() == 7 || feature.getTyp() == 6;
            if (specialString || number) {
                StringBuffer buffer = new StringBuffer(normalizedValue.length());
                char[] chars = normalizedValue.toCharArray();
                boolean whitespace = false;
                char[] cArray = chars;
                int n = chars.length;
                int n2 = 0;
                while (n2 < n) {
                    char c = cArray[n2];
                    switch (c) {
                        case '\t': 
                        case '\n': 
                        case '\r': 
                        case ' ': {
                            if (feature.getTyp() == 2) {
                                buffer.append(' ');
                                break;
                            }
                            if (number && (decimalSeparator == c || thousandGroupSeparator == c)) {
                                if (c == decimalSeparator) {
                                    buffer.append(',');
                                    break;
                                }
                                if (c != thousandGroupSeparator) break;
                                buffer.append('.');
                                break;
                            }
                            if (buffer.length() <= 0) break;
                            whitespace = true;
                            break;
                        }
                        default: {
                            if (whitespace) {
                                buffer.append(' ');
                                whitespace = false;
                            }
                            if (number && (decimalSeparator != ',' || thousandGroupSeparator != '.')) {
                                if (c == decimalSeparator) {
                                    buffer.append(',');
                                    break;
                                }
                                if (c == thousandGroupSeparator) {
                                    buffer.append('.');
                                    break;
                                }
                                buffer.append(c);
                                break;
                            }
                            buffer.append(c);
                        }
                    }
                    ++n2;
                }
                normalizedValue = buffer.toString();
            }
        }
        return normalizedValue;
    }

    public static boolean isNumeric(String string) {
        boolean numeric;
        if (string != null && string.length() > 0) {
            char[] chars;
            numeric = true;
            char[] cArray = chars = string.toCharArray();
            int n = chars.length;
            int n2 = 0;
            while (n2 < n) {
                char c = cArray[n2];
                if (!Character.isDigit(c)) {
                    numeric = false;
                    break;
                }
                ++n2;
            }
        } else {
            numeric = false;
        }
        return numeric;
    }
}

