/*
 * Decompiled with CFR 0.152.
 */
package de.statspez.sdf.generator.parser;

import de.statspez.sdf.generator.meta.MetaCustomSDFDokumenterzeuger;
import de.statspez.sdf.generator.meta.MetaCustomSDFTemplateArgument;
import de.statspez.sdf.generator.meta.MetaCustomSDFTemplateAufruf;
import de.statspez.sdf.generator.meta.MetaCustomSDFTemplateAusfuehrung;
import de.statspez.sdf.generator.meta.SDFElement;
import de.statspez.sdf.generator.meta.SDFMetaElementsTraverser;
import de.statspez.sdf.generator.meta.generated.MetaSDFDokumenterzeuger;
import de.statspez.sdf.generator.meta.generated.MetaSDFMetaFeldReferenz;
import de.statspez.sdf.generator.meta.generated.MetaSDFMetaMerkmal;
import de.statspez.sdf.generator.meta.generated.MetaSDFMetaMerkmalsgruppe;
import de.statspez.sdf.generator.meta.generated.MetaSDFTemplate;
import de.statspez.sdf.generator.meta.generated.MetaSDFTemplateParameter;
import de.statspez.sdf.generator.meta.generated.MetaSDFTemplateProgramm;
import de.statspez.sdf.generator.parser.LocalReference;
import de.werum.sis.meta.ElementVisitorInterface;
import de.werum.sis.meta.MetaElementInterface;
import de.werum.sis.meta.parser.Reference;
import de.werum.sis.meta.parser.ResolveException;
import de.werum.sis.meta.parser.ResolverInterface;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;

public class SDFMetaResolver
extends SDFMetaElementsTraverser
implements ResolverInterface {
    public static final String REF_TYPE_METADATA_ITEM = "METADATA_ITEM";
    public static final String REF_TYPE_METADATA_GROUP = "METADATA_GROUP";
    public static final String REF_TYPE_EXECUTABLE = "EXECUTABLE";
    public static final String REF_TYPE_TEMPLATE_BY_ID = "TEMPLATE_BY_ID";
    public static final String REF_TYPE_TEMPLATE_BY_STRUCTURE = "TEMPLATE_BY_STRUCTURE";
    public static final String REF_TYPE_PARAM = "PARAM";
    private Hashtable referenceTable = new Hashtable();
    private MetaSDFDokumenterzeuger dokumenterzeuger = null;
    private MetaSDFTemplateProgramm programm = null;

    private void solveReference(String refType, String refName, Object refElement) {
        Hashtable names = (Hashtable)this.referenceTable.get(refType);
        if (names == null) {
            return;
        }
        Vector references = (Vector)names.get(refName);
        if (references == null) {
            return;
        }
        Iterator iter = references.iterator();
        while (iter != null && iter.hasNext()) {
            MetaCustomSDFTemplateAufruf aufruf;
            MetaSDFMetaFeldReferenz feldReferenz;
            Reference reference = (Reference)iter.next();
            if (reference.isSolved()) continue;
            if (REF_TYPE_METADATA_ITEM.equals(refType)) {
                if (!(reference.getReferringElement() instanceof MetaSDFMetaFeldReferenz)) continue;
                feldReferenz = (MetaSDFMetaFeldReferenz)reference.getReferringElement();
                feldReferenz.setKlasse((SDFElement)refElement);
                reference.solved();
                continue;
            }
            if (REF_TYPE_METADATA_GROUP.equals(refType)) {
                if (!(reference.getReferringElement() instanceof MetaSDFMetaFeldReferenz)) continue;
                feldReferenz = (MetaSDFMetaFeldReferenz)reference.getReferringElement();
                feldReferenz.setKlasse((SDFElement)refElement);
                reference.solved();
                continue;
            }
            if (REF_TYPE_EXECUTABLE.equals(refType)) {
                if (!(reference.getReferringElement() instanceof MetaCustomSDFTemplateAusfuehrung)) continue;
                MetaCustomSDFTemplateAusfuehrung ausfuehrung = (MetaCustomSDFTemplateAusfuehrung)reference.getReferringElement();
                ausfuehrung.setProgramm((MetaSDFTemplateProgramm)refElement);
                reference.solved();
                continue;
            }
            if (REF_TYPE_TEMPLATE_BY_ID.equals(refType)) {
                if (reference.getReferringElement() instanceof MetaCustomSDFDokumenterzeuger) {
                    MetaCustomSDFDokumenterzeuger dokumenterzeuger = (MetaCustomSDFDokumenterzeuger)reference.getReferringElement();
                    dokumenterzeuger.setStartTemplate((MetaSDFTemplate)refElement);
                    reference.solved();
                    continue;
                }
                if (!(reference.getReferringElement() instanceof MetaCustomSDFTemplateAufruf)) continue;
                aufruf = (MetaCustomSDFTemplateAufruf)reference.getReferringElement();
                aufruf.setTemplate((MetaSDFTemplate)refElement);
                reference.solved();
                continue;
            }
            if (REF_TYPE_TEMPLATE_BY_STRUCTURE.equals(refType)) {
                if (!(reference.getReferringElement() instanceof MetaCustomSDFTemplateAufruf)) continue;
                aufruf = (MetaCustomSDFTemplateAufruf)reference.getReferringElement();
                aufruf.setTemplateFor(reference.getRefName(), (MetaSDFTemplate)refElement);
                reference.solved();
                continue;
            }
            if (!REF_TYPE_PARAM.equals(refType) || !(reference.getReferringElement() instanceof MetaCustomSDFTemplateArgument)) continue;
            MetaCustomSDFTemplateArgument argument = (MetaCustomSDFTemplateArgument)reference.getReferringElement();
            argument.setParameter((MetaSDFTemplateParameter)refElement);
            reference.solved();
        }
    }

    private void checkSolved() throws ResolveException {
        StringBuffer message = new StringBuffer("");
        for (String refType : this.referenceTable.keySet()) {
            Hashtable nameTable = (Hashtable)this.referenceTable.get(refType);
            if (nameTable == null) continue;
            for (String name : nameTable.keySet()) {
                Vector referencesVector = (Vector)nameTable.get(name);
                if (referencesVector == null) continue;
                for (Reference reference : referencesVector) {
                    if (reference.isSolved()) continue;
                    if (message.length() > 0) {
                        message.append(System.getProperty("line.separator"));
                    }
                    message.append("Die Referenz auf ");
                    if (REF_TYPE_METADATA_ITEM.equals(refType)) {
                        message.append("das Meta-Merkmal");
                    } else if (REF_TYPE_METADATA_GROUP.equals(refType)) {
                        message.append("die Meta-Merkmalsgruppe");
                    } else if (REF_TYPE_EXECUTABLE.equals(refType)) {
                        message.append("das Template-Programm");
                    } else if (REF_TYPE_TEMPLATE_BY_ID.equals(refType)) {
                        message.append("das Template");
                    } else if (REF_TYPE_TEMPLATE_BY_STRUCTURE.equals(refType)) {
                        message.append("das Template f\u00fcr");
                    } else if (REF_TYPE_PARAM.equals(refType)) {
                        message.append("den Parameter");
                    }
                    message.append(" ");
                    message.append(reference.getRefName());
                    message.append(" konnte nicht aufgeloest werden.");
                }
            }
        }
        if (message.length() > 0) {
            throw new ResolveException(message.toString());
        }
    }

    private String getLocalRefName(Object container, String refName) {
        return String.valueOf(refName) + '@' + container.getClass().getName() + '#' + container.hashCode();
    }

    @Override
    public void visitSDFMetaMerkmalsgruppe(MetaSDFMetaMerkmalsgruppe merkmalsgruppe) {
        this.solveReference(REF_TYPE_METADATA_GROUP, merkmalsgruppe.getName(), merkmalsgruppe);
    }

    @Override
    public void visitSDFMetaMerkmal(MetaSDFMetaMerkmal merkmal) {
        this.solveReference(REF_TYPE_METADATA_ITEM, merkmal.getName(), merkmal);
    }

    @Override
    public void visitSDFDokumenterzeuger(MetaSDFDokumenterzeuger dokumenterzeuger) {
        this.dokumenterzeuger = dokumenterzeuger;
        super.visitSDFDokumenterzeuger(dokumenterzeuger);
    }

    @Override
    public void visitSDFTemplateProgramm(MetaSDFTemplateProgramm programm) {
        this.programm = programm;
        this.solveReference(REF_TYPE_EXECUTABLE, this.getLocalRefName(this.dokumenterzeuger, programm.getId()), programm);
        super.visitSDFTemplateProgramm(programm);
    }

    @Override
    public void visitSDFTemplate(MetaSDFTemplate template) {
        if (template.getId() != null) {
            this.solveReference(REF_TYPE_TEMPLATE_BY_ID, this.getLocalRefName(this.dokumenterzeuger, template.getId()), template);
        }
        if (template.getStruktur() != null) {
            this.solveReference(REF_TYPE_TEMPLATE_BY_STRUCTURE, this.getLocalRefName(this.dokumenterzeuger, template.getStruktur()), template);
        }
    }

    @Override
    public void visitSDFTemplateParameter(MetaSDFTemplateParameter parameter) {
        this.solveReference(REF_TYPE_PARAM, this.getLocalRefName(this.dokumenterzeuger, String.valueOf(this.programm.getId()) + '.' + parameter.getName()), parameter);
    }

    public void doResolve(MetaElementInterface rootElement) throws ResolveException {
        rootElement.accept((ElementVisitorInterface)this);
        this.checkSolved();
    }

    public void registerForResolve(Reference reference) {
        Vector<Reference> references;
        Hashtable<String, Vector<Reference>> names = (Hashtable<String, Vector<Reference>>)this.referenceTable.get(reference.getRefType());
        if (names == null) {
            names = new Hashtable<String, Vector<Reference>>();
            this.referenceTable.put(reference.getRefType(), names);
        }
        String refName = reference.getRefName();
        if (reference instanceof LocalReference) {
            refName = this.getLocalRefName(((LocalReference)reference).getContainer(), reference.getRefName());
        }
        if ((references = (Vector<Reference>)names.get(refName)) == null) {
            references = new Vector<Reference>();
            names.put(refName, references);
        }
        references.add(reference);
    }
}

