/*
 * Decompiled with CFR 0.152.
 */
package de.statspez.sdf.generator.parser;

import de.statspez.sdf.generator.meta.generated.MetaStatspezObjekt;
import de.statspez.sdf.generator.parser.ApplicationParser;
import de.statspez.sdf.generator.parser.AuthorParser;
import de.statspez.sdf.generator.parser.ContactParser;
import de.statspez.sdf.generator.parser.CreationDateParser;
import de.statspez.sdf.generator.parser.CreationTimeParser;
import de.statspez.sdf.generator.parser.ParserUtil;
import de.statspez.sdf.generator.parser.SDFParserContext;
import de.werum.sis.common.AbstractMessage;
import de.werum.sis.meta.MetaElementInterface;
import de.werum.sis.meta.parser.MetaParseException;
import de.werum.sis.meta.parser.ParserChain;
import de.werum.sis.meta.parser.ResolverInterface;
import de.werum.sis.meta.parser.SubParser;
import de.werum.sis.meta.parser.SuperParser;
import java.util.Date;
import java.util.GregorianCalendar;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class PropertiesParser
extends SubParser
implements SuperParser {
    private ParserChain parserChain = new ParserChain();
    private AuthorParser authorParser;
    private ContactParser contactParser;
    private CreationDateParser creationDateParser;
    private CreationTimeParser creationTimeParser;
    private ApplicationParser applicationParser;
    private MetaStatspezObjekt statspezObjekt;
    private GregorianCalendar creationDate;

    public PropertiesParser(SuperParser superParser, ResolverInterface resolver) {
        super(superParser, resolver);
        this.authorParser = new AuthorParser(this, resolver);
        this.parserChain.addParser((SubParser)this.authorParser);
        this.contactParser = new ContactParser(this, resolver);
        this.parserChain.addParser((SubParser)this.contactParser);
        this.creationDateParser = new CreationDateParser(this, resolver);
        this.parserChain.addParser((SubParser)this.creationDateParser);
        this.creationTimeParser = new CreationTimeParser(this, resolver);
        this.parserChain.addParser((SubParser)this.creationTimeParser);
        this.applicationParser = new ApplicationParser(this, resolver);
        this.parserChain.addParser((SubParser)this.applicationParser);
        this.statspezObjekt = null;
        this.creationDate = new GregorianCalendar();
    }

    public void setStatspezObjekt(MetaStatspezObjekt statspezObjekt) {
        this.statspezObjekt = statspezObjekt;
        this.authorParser.setStatspezObjekt(statspezObjekt);
        this.contactParser.setStatspezObjekt(statspezObjekt);
        this.applicationParser.setStatspezObjekt(statspezObjekt);
    }

    public Date getCreationDate() {
        return this.creationDate.getTime();
    }

    private void handleAttributes(String namespaceURI, String localName, String qName, Attributes atts) {
        if ("properties".equalsIgnoreCase(localName)) {
            String string = atts.getValue("id");
        } else if ("annotation".equalsIgnoreCase(localName)) {
            String string = atts.getValue("id");
        } else if ("copyright".equalsIgnoreCase(localName)) {
            String string = atts.getValue("id");
        }
    }

    private boolean handleTag(String namespaceURI, String localName, String qName) {
        boolean handled = true;
        String chars = this.superParser().charData().toString().trim();
        if (!"abstract".equalsIgnoreCase(localName)) {
            if ("description".equalsIgnoreCase(localName)) {
                if (this.statspezObjekt != null) {
                    this.statspezObjekt.setBeschreibung(ParserUtil.removeWhitespaces(chars));
                }
            } else if (!"copyright".equalsIgnoreCase(localName)) {
                if ("annotation".equalsIgnoreCase(localName)) {
                    if (this.statspezObjekt != null) {
                        this.statspezObjekt.setKommentar(ParserUtil.removeWhitespaces(chars));
                    }
                } else if (!"testIndicator".equalsIgnoreCase(localName)) {
                    handled = false;
                }
            }
        }
        return handled;
    }

    public boolean canHandleOpenTag(String namespaceURI, String tag) {
        if ("properties".equalsIgnoreCase(tag)) {
            return true;
        }
        return this.isEnabled();
    }

    public boolean canHandleClosedTag(String namespaceURI, String tag) {
        return this.isEnabled();
    }

    public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
        if ("properties".equalsIgnoreCase(localName)) {
            ((SDFParserContext)this.getParserKontext()).checkNamespaceSSP(namespaceURI);
            this.creationDate.clear();
            this.enable();
        } else if ("abstract".equalsIgnoreCase(localName)) {
            ((SDFParserContext)this.getParserKontext()).checkNamespaceSSP(namespaceURI);
        } else if ("description".equalsIgnoreCase(localName)) {
            ((SDFParserContext)this.getParserKontext()).checkNamespaceSSP(namespaceURI);
        } else if ("copyright".equalsIgnoreCase(localName)) {
            ((SDFParserContext)this.getParserKontext()).checkNamespaceSSP(namespaceURI);
        } else if ("annotation".equalsIgnoreCase(localName)) {
            ((SDFParserContext)this.getParserKontext()).checkNamespaceSSP(namespaceURI);
        } else if ("testIndicator".equalsIgnoreCase(localName)) {
            ((SDFParserContext)this.getParserKontext()).checkNamespaceSSP(namespaceURI);
        } else if (!this.parserChain.startElement(namespaceURI, localName, qName, atts)) {
            throw MetaParseException.unknownTagException((String)localName);
        }
        this.handleAttributes(namespaceURI, localName, qName, atts);
    }

    public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
        if ("properties".equalsIgnoreCase(localName)) {
            this.disableAndNotify();
        } else if (!this.handleTag(namespaceURI, localName, qName) && !this.parserChain.endElement(namespaceURI, localName, qName)) {
            throw MetaParseException.unknownClosingTagException((String)localName);
        }
    }

    public MetaElementInterface object() {
        return this.statspezObjekt;
    }

    public StringBuffer charData() {
        return this.superParser().charData();
    }

    public void notifyObjectAvailable(SubParser aParser) {
        if (aParser == this.creationDateParser) {
            this.creationDate.set(1, this.creationDateParser.getYear());
            if (this.creationDateParser.getMonth() > 0) {
                this.creationDate.set(2, this.creationDateParser.getMonth() - 1);
            }
            if (this.creationDateParser.getDay() > 0) {
                this.creationDate.set(5, this.creationDateParser.getDay());
            }
        } else if (aParser == this.creationTimeParser) {
            this.creationDate.set(11, this.creationTimeParser.getHours());
            this.creationDate.set(12, this.creationTimeParser.getMinutes());
            this.creationDate.set(13, this.creationTimeParser.getSeconds());
            this.creationDate.set(14, this.creationTimeParser.getFractionSeconds());
        }
    }

    public String parentElement() {
        return this.superParser().parentElement();
    }

    public void error(AbstractMessage errorMessage) {
        this.superParser().error(errorMessage);
    }
}

