/*
 * Decompiled with CFR 0.152.
 */
package org.saiku.web.rest.resources;

import com.his.jackson.annotation.JsonAutoDetect;
import com.his.jackson.databind.JavaType;
import com.his.jackson.databind.ObjectMapper;
import com.his.jackson.databind.type.CollectionType;
import jakarta.servlet.ServletException;
import java.io.InputStream;
import java.io.StringReader;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.saiku.olap.dto.SaikuCube;
import org.saiku.olap.dto.SaikuDimensionSelection;
import org.saiku.olap.dto.SaikuQuery;
import org.saiku.olap.dto.SaikuTag;
import org.saiku.olap.dto.SimpleCubeElement;
import org.saiku.olap.dto.filter.SaikuFilter;
import org.saiku.olap.dto.resultset.CellDataSet;
import org.saiku.olap.query.IQuery;
import org.saiku.olap.util.ObjectUtil;
import org.saiku.olap.util.SaikuProperties;
import org.saiku.olap.util.formatter.CellSetFormatter;
import org.saiku.olap.util.formatter.FlattenedCellSetFormatter;
import org.saiku.olap.util.formatter.HierarchicalCellSetFormatter;
import org.saiku.olap.util.formatter.ICellSetFormatter;
import org.saiku.service.olap.OlapDiscoverService;
import org.saiku.service.olap.OlapQueryService;
import org.saiku.service.util.exception.SaikuServiceException;
import org.saiku.web.export.JSConverter;
import org.saiku.web.rest.objects.MdxQueryObject;
import org.saiku.web.rest.objects.SavedQuery;
import org.saiku.web.rest.objects.SelectionRestObject;
import org.saiku.web.rest.objects.resultset.QueryResult;
import org.saiku.web.rest.resources.ISaikuRepository;
import org.saiku.web.rest.util.RestUtil;
import org.saiku.web.rest.util.ServletUtil;
import org.saiku.web.svg.PdfReport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
@Path(value="/saiku/{username}/query")
@XmlAccessorType(value=XmlAccessType.NONE)
@Deprecated
public class QueryResource {
    private static final Logger log = LoggerFactory.getLogger(QueryResource.class);
    private OlapQueryService olapQueryService;
    private ISaikuRepository repository;

    public void setOlapQueryService(OlapQueryService olapqs) {
        this.olapQueryService = olapqs;
    }

    public void setRepository(ISaikuRepository repository) {
        this.repository = repository;
    }

    public void setOlapDiscoverService(OlapDiscoverService olapds) {
        OlapDiscoverService olapDiscoverService = olapds;
    }

    @GET
    @Produces(value={"application/json"})
    public List<String> getQueries() {
        return this.olapQueryService.getQueries();
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/{queryname}")
    public SaikuQuery getQuery(@PathParam(value="queryname") String queryName) {
        if (log.isDebugEnabled()) {
            log.debug("TRACK\t\t/query/" + queryName + "\tGET");
        }
        return this.olapQueryService.getQuery(queryName);
    }

    @DELETE
    @Path(value="/{queryname}")
    public Response.Status deleteQuery(@PathParam(value="queryname") String queryName) {
        if (log.isDebugEnabled()) {
            log.debug("TRACK\t\t/query/" + queryName + "\tDELETE");
        }
        try {
            this.olapQueryService.deleteQuery(queryName);
            return Response.Status.GONE;
        }
        catch (Exception e) {
            log.error("Cannot delete query (" + queryName + ")", (Throwable)e);
            throw new WebApplicationException(Response.serverError().entity((Object)e).build());
        }
    }

    @POST
    @Produces(value={"application/json"})
    @Path(value="/{queryname}")
    public SaikuQuery createQuery(@FormParam(value="connection") String connectionName, @FormParam(value="cube") String cubeName, @FormParam(value="catalog") String catalogName, @FormParam(value="schema") String schemaName, @FormParam(value="xml") String xmlOld, @PathParam(value="queryname") String queryName, MultivaluedMap<String, String> formParams) throws ServletException {
        try {
            String file = null;
            String xml = null;
            if (formParams != null) {
                xml = formParams.containsKey((Object)"xml") ? (String)formParams.getFirst((Object)"xml") : xmlOld;
                String string = file = formParams.containsKey((Object)"file") ? (String)formParams.getFirst((Object)"file") : null;
                if (StringUtils.isNotBlank((String)file)) {
                    Response f = this.repository.getResource(file);
                    xml = new String((byte[])f.getEntity());
                }
            } else {
                xml = xmlOld;
            }
            if (log.isDebugEnabled()) {
                log.debug("TRACK\t\t/query/" + queryName + "\tPOST\t xml:" + (xml == null) + " file:" + file);
            }
            SaikuCube cube = new SaikuCube(connectionName, cubeName, cubeName, cubeName, catalogName, schemaName);
            if (StringUtils.isNotBlank((String)xml)) {
                String query = ServletUtil.replaceParameters(formParams, xml);
                return this.olapQueryService.createNewOlapQuery(queryName, query);
            }
            return this.olapQueryService.createNewOlapQuery(queryName, cube);
        }
        catch (Exception e) {
            throw new WebApplicationException((Throwable)e);
        }
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/{queryname}/properties")
    public Properties getProperties(@PathParam(value="queryname") String queryName) {
        if (log.isDebugEnabled()) {
            log.debug("TRACK\t\t/query/" + queryName + "/properties\tGET");
        }
        return this.olapQueryService.getProperties(queryName);
    }

    @POST
    @Produces(value={"application/json"})
    @Path(value="/{queryname}/properties")
    public Properties setProperties(@PathParam(value="queryname") String queryName, @FormParam(value="properties") String properties) {
        if (log.isDebugEnabled()) {
            log.debug("TRACK\t\t/query/" + queryName + "/properties\tPOST");
        }
        try {
            Properties props = new Properties();
            StringReader sr = new StringReader(properties);
            props.load(sr);
            return this.olapQueryService.setProperties(queryName, props);
        }
        catch (Exception e) {
            log.error("Cannot set properties for query (" + queryName + ")", (Throwable)e);
            return null;
        }
    }

    @POST
    @Produces(value={"application/json"})
    @Path(value="/{queryname}/properties/{propertyKey}")
    public Properties setProperties(@PathParam(value="queryname") String queryName, @PathParam(value="propertyKey") String propertyKey, @FormParam(value="propertyValue") String propertyValue) {
        if (log.isDebugEnabled()) {
            log.debug("TRACK\t\t/query/" + queryName + "/properties/" + propertyKey + "\tPOST");
        }
        try {
            Properties props = new Properties();
            props.put(propertyKey, propertyValue);
            return this.olapQueryService.setProperties(queryName, props);
        }
        catch (Exception e) {
            log.error("Cannot set property (" + propertyKey + " ) for query (" + queryName + ")", (Throwable)e);
            return null;
        }
    }

    @GET
    @Path(value="/{queryname}/mdx")
    public MdxQueryObject getMDXQuery(@PathParam(value="queryname") String queryName) {
        if (log.isDebugEnabled()) {
            log.debug("TRACK\t\t/query/" + queryName + "/mdx/\tGET");
        }
        try {
            String mdx = this.olapQueryService.getMDXQuery(queryName);
            return new MdxQueryObject(mdx);
        }
        catch (Exception e) {
            log.error("Cannot get mdx for query (" + queryName + ")", (Throwable)e);
            return null;
        }
    }

    @POST
    @Consumes(value={"application/x-www-form-urlencoded"})
    @Path(value="/{queryname}/mdx")
    public void setMDXQuery(@PathParam(value="queryname") String queryName, @FormParam(value="mdx") String mdx) {
        if (log.isDebugEnabled()) {
            log.debug("TRACK\t\t/query/" + queryName + "/mdx/\tPOST");
        }
        try {
            this.olapQueryService.setMdx(queryName, mdx);
        }
        catch (Exception e) {
            log.error("Cannot set mdx for query (" + queryName + ")", (Throwable)e);
        }
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/{queryname}/xml")
    public SavedQuery getQueryXml(@PathParam(value="queryname") String queryName) {
        if (log.isDebugEnabled()) {
            log.debug("TRACK\t\t/query/" + queryName + "/xml/\tGET");
        }
        try {
            String xml = this.olapQueryService.getQueryXml(queryName);
            return new SavedQuery(queryName, null, xml);
        }
        catch (Exception e) {
            log.error("Cannot get xml for query (" + queryName + ")", (Throwable)e);
            return null;
        }
    }

    @GET
    @Produces(value={"application/vnd.ms-excel"})
    @Path(value="/{queryname}/export/xls")
    public Response getQueryExcelExport(@PathParam(value="queryname") String queryName) {
        if (log.isDebugEnabled()) {
            log.debug("TRACK\t\t/query/" + queryName + "/export/xls/\tGET");
        }
        return this.getQueryExcelExport(queryName, "flattened");
    }

    @GET
    @Produces(value={"application/vnd.ms-excel"})
    @Path(value="/{queryname}/export/xls/{format}")
    public Response getQueryExcelExport(@PathParam(value="queryname") String queryName, @PathParam(value="format") @DefaultValue(value="flattened") String format) {
        if (log.isDebugEnabled()) {
            log.debug("TRACK\t\t/query/" + queryName + "/export/xls/" + format + "\tGET");
        }
        try {
            byte[] doc = this.olapQueryService.getExport(queryName, "xls", format);
            String name = SaikuProperties.webExportExcelName + "." + SaikuProperties.webExportExcelFormat;
            return Response.ok((Object)doc, (String)"application/octet-stream").header("content-disposition", (Object)("attachment; filename = " + name)).header("content-length", (Object)doc.length).build();
        }
        catch (Exception e) {
            log.error("Cannot get excel for query (" + queryName + ")", (Throwable)e);
            return Response.serverError().build();
        }
    }

    @GET
    @Produces(value={"text/csv"})
    @Path(value="/{queryname}/export/csv")
    public Response getQueryCsvExport(@PathParam(value="queryname") String queryName) {
        if (log.isDebugEnabled()) {
            log.debug("TRACK\t\t/query/" + queryName + "/export/csv\tGET");
        }
        return this.getQueryCsvExport(queryName, "flattened");
    }

    @GET
    @Produces(value={"text/csv"})
    @Path(value="/{queryname}/export/csv/{format}")
    public Response getQueryCsvExport(@PathParam(value="queryname") String queryName, @PathParam(value="format") String format) {
        if (log.isDebugEnabled()) {
            log.debug("TRACK\t\t/query/" + queryName + "/export/csv/" + format + "\tGET");
        }
        try {
            byte[] doc = this.olapQueryService.getExport(queryName, "csv", format);
            String name = SaikuProperties.webExportCsvName;
            return Response.ok((Object)doc, (String)"application/octet-stream").header("content-disposition", (Object)("attachment; filename = " + name + ".csv")).header("content-length", (Object)doc.length).build();
        }
        catch (Exception e) {
            log.error("Cannot get csv for query (" + queryName + ")", (Throwable)e);
            return Response.serverError().build();
        }
    }

    @POST
    @Produces(value={"application/pdf"})
    @Path(value="/{queryname}/export/pdf")
    public Response exportPdfWithChart(@PathParam(value="queryname") String queryName, @PathParam(value="svg") @DefaultValue(value="") String svg) {
        return this.exportPdfWithChartAndFormat(queryName, null, svg);
    }

    @GET
    @Produces(value={"application/pdf"})
    @Path(value="/{queryname}/export/pdf")
    public Response exportPdf(@PathParam(value="queryname") String queryName) {
        return this.exportPdfWithChartAndFormat(queryName, null, null);
    }

    @GET
    @Produces(value={"application/pdf"})
    @Path(value="/{queryname}/export/pdf/{format}")
    public Response exportPdfWithFormat(@PathParam(value="queryname") String queryName, @PathParam(value="format") String format) {
        return this.exportPdfWithChartAndFormat(queryName, format, null);
    }

    @POST
    @Produces(value={"application/pdf"})
    @Path(value="/{queryname}/export/pdf/{format}")
    public Response exportPdfWithChartAndFormat(@PathParam(value="queryname") String queryName, @PathParam(value="format") String format, @FormParam(value="svg") @DefaultValue(value="") String svg) {
        try {
            PdfReport pdf = new PdfReport();
            CellDataSet cs = null;
            cs = StringUtils.isNotBlank((String)format) ? this.olapQueryService.execute(queryName, format) : this.olapQueryService.execute(queryName);
            byte[] doc = pdf.pdf(cs, svg);
            return Response.ok((Object)doc).type("application/pdf").header("content-disposition", (Object)"attachment; filename = export.pdf").header("content-length", (Object)doc.length).build();
        }
        catch (Exception e) {
            log.error("Error exporting query to  PDF", (Throwable)e);
            return Response.serverError().entity((Object)e.getMessage()).status(Response.Status.INTERNAL_SERVER_ERROR).build();
        }
    }

    @GET
    @Produces(value={"text/html"})
    @Path(value="/{queryname}/export/html/{format}")
    public Response exportHtml(@PathParam(value="queryname") String queryName, @PathParam(value="format") String format, @QueryParam(value="css") @DefaultValue(value="false") Boolean css, @QueryParam(value="tableonly") @DefaultValue(value="false") Boolean tableonly, @QueryParam(value="wrapcontent") @DefaultValue(value="true") Boolean wrapcontent) {
        try {
            CellDataSet cs = null;
            cs = StringUtils.isNotBlank((String)format) ? this.olapQueryService.execute(queryName, format) : this.olapQueryService.execute(queryName);
            QueryResult qr = RestUtil.convert(cs);
            String content = JSConverter.convertToHtml(qr, wrapcontent);
            String html = "";
            if (!tableonly.booleanValue()) {
                html = html + "<!DOCTYPE html><html><head><meta http-equiv=\"Content-Type\" content=\"text/html; charset=utf-8\">\n";
                if (css.booleanValue()) {
                    html = html + "<style>\n";
                    InputStream is = JSConverter.class.getResourceAsStream("saiku.table.full.css");
                    String cssContent = IOUtils.toString((InputStream)is);
                    html = html + cssContent;
                    html = html + "</style>\n";
                }
                html = html + "</head>\n<body><div class='workspace_results'>\n";
            }
            html = html + content;
            if (!tableonly.booleanValue()) {
                html = html + "\n</div></body></html>";
            }
            return Response.ok((Object)html).build();
        }
        catch (Exception e) {
            log.error("Error exporting query to HTML", (Throwable)e);
            return Response.serverError().entity((Object)e.getMessage()).status(Response.Status.INTERNAL_SERVER_ERROR).build();
        }
    }

    @DELETE
    @Path(value="/{queryname}/result")
    public Response.Status cancel(@PathParam(value="queryname") String queryName) {
        if (log.isDebugEnabled()) {
            log.debug("TRACK\t\t/query/" + queryName + "/result\tDELETE");
        }
        try {
            this.olapQueryService.cancel(queryName);
            return Response.Status.OK;
        }
        catch (Exception e) {
            log.error("Cannot execute query (" + queryName + ")", (Throwable)e);
            return Response.Status.INTERNAL_SERVER_ERROR;
        }
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/{queryname}/result")
    public QueryResult execute(@PathParam(value="queryname") String queryName, @QueryParam(value="limit") @DefaultValue(value="0") int limit) {
        if (log.isDebugEnabled()) {
            log.debug("TRACK\t\t/query/" + queryName + "/result\tGET");
        }
        try {
            CellDataSet cs = this.olapQueryService.execute(queryName);
            return RestUtil.convert(cs, limit);
        }
        catch (Exception e) {
            log.error("Cannot execute query (" + queryName + ")", (Throwable)e);
            String error = ExceptionUtils.getRootCauseMessage((Throwable)e);
            return new QueryResult(error);
        }
    }

    @POST
    @Produces(value={"application/json"})
    @Path(value="/{queryname}/result/{format}")
    public QueryResult executeMdx(@PathParam(value="queryname") String queryName, @PathParam(value="format") String formatter, @FormParam(value="mdx") String mdx, @FormParam(value="limit") @DefaultValue(value="0") int limit) {
        if (log.isDebugEnabled()) {
            log.debug("TRACK\t\t/query/" + queryName + "/result" + formatter + "\tPOST");
        }
        try {
            CellSetFormatter icf;
            switch (formatter = formatter == null ? "" : formatter.toLowerCase()) {
                case "flat": {
                    icf = new CellSetFormatter();
                    break;
                }
                case "hierarchical": {
                    icf = new HierarchicalCellSetFormatter();
                    break;
                }
                case "flattened": {
                    icf = new FlattenedCellSetFormatter();
                    break;
                }
                default: {
                    icf = new FlattenedCellSetFormatter();
                }
            }
            this.olapQueryService.qm2mdx(queryName);
            if (this.olapQueryService.isMdxDrillthrough(queryName, mdx)) {
                Long start = new Date().getTime();
                ResultSet rs = this.olapQueryService.drillthrough(queryName, mdx);
                QueryResult rsc = RestUtil.convert(rs);
                Long runtime = new Date().getTime() - start;
                rsc.setRuntime(runtime.intValue());
                return rsc;
            }
            CellDataSet cs = this.olapQueryService.executeMdx(queryName, mdx, (ICellSetFormatter)icf);
            return RestUtil.convert(cs, limit);
        }
        catch (Exception e) {
            log.error("Cannot execute query (" + queryName + ") using mdx:\n" + mdx, (Throwable)e);
            String error = ExceptionUtils.getRootCauseMessage((Throwable)e);
            return new QueryResult(error);
        }
    }

    @POST
    @Produces(value={"application/json"})
    @Path(value="/{queryname}/result")
    public QueryResult executeMdx(@PathParam(value="queryname") String queryName, @FormParam(value="mdx") String mdx, @FormParam(value="limit") @DefaultValue(value="0") int limit) {
        if (log.isDebugEnabled()) {
            log.debug("TRACK\t\t/query/" + queryName + "/result\tPOST\t" + mdx);
        }
        try {
            return this.executeMdx(queryName, null, mdx, limit);
        }
        catch (Exception e) {
            log.error("Cannot execute query (" + queryName + ") using mdx:\n" + mdx, (Throwable)e);
            String error = ExceptionUtils.getRootCauseMessage((Throwable)e);
            return new QueryResult(error);
        }
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/{queryname}/result/metadata/dimensions/{dimension}/hierarchies/{hierarchy}/levels/{level}")
    public List<SimpleCubeElement> getLevelMembers(@PathParam(value="queryname") String queryName, @PathParam(value="dimension") String dimensionName, @PathParam(value="hierarchy") String hierarchyName, @PathParam(value="level") String levelName, @QueryParam(value="result") @DefaultValue(value="true") boolean result, @QueryParam(value="search") String searchString, @QueryParam(value="searchlimit") @DefaultValue(value="-1") int searchLimit) {
        if (log.isDebugEnabled()) {
            log.debug("TRACK\t\t/query/" + queryName + "/result/metadata/dimensions/" + dimensionName + "/hierarchies/" + hierarchyName + "/levels/" + levelName + "\tGET");
        }
        try {
            return this.olapQueryService.getResultMetadataMembers(queryName, result, dimensionName, hierarchyName, levelName, searchString, searchLimit);
        }
        catch (Exception e) {
            log.error("Cannot execute query (" + queryName + ")", (Throwable)e);
            String error = ExceptionUtils.getRootCauseMessage((Throwable)e);
            throw new WebApplicationException(Response.serverError().entity((Object)error).build());
        }
    }

    @POST
    @Produces(value={"application/json"})
    @Path(value="/{queryname}/qm2mdx")
    public SaikuQuery transformQm2Mdx(@PathParam(value="queryname") String queryName) {
        if (log.isDebugEnabled()) {
            log.debug("TRACK\t\t/query/" + queryName + "/qm2mdx\tPOST\t");
        }
        try {
            this.olapQueryService.qm2mdx(queryName);
            return this.olapQueryService.getQuery(queryName);
        }
        catch (Exception e) {
            log.error("Cannot transform Qm2Mdx query (" + queryName + ")", (Throwable)e);
            return null;
        }
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/{queryname}/explain")
    public QueryResult getExplainPlan(@PathParam(value="queryname") String queryName) {
        QueryResult rsc;
        if (log.isDebugEnabled()) {
            log.debug("TRACK\t\t/query/" + queryName + "/explain\tGET");
        }
        ResultSet rs = null;
        try {
            Long start = new Date().getTime();
            rs = this.olapQueryService.explain(queryName);
            rsc = RestUtil.convert(rs);
            Long runtime = new Date().getTime() - start;
            rsc.setRuntime(runtime.intValue());
        }
        catch (Exception e) {
            log.error("Cannot get explain plan for query (" + queryName + ")", (Throwable)e);
            String error = ExceptionUtils.getRootCauseMessage((Throwable)e);
            rsc = new QueryResult(error);
        }
        return rsc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @GET
    @Produces(value={"application/json"})
    @Path(value="/{queryname}/drillthrough")
    public QueryResult drillthrough(@PathParam(value="queryname") String queryName, @QueryParam(value="maxrows") @DefaultValue(value="100") Integer maxrows, @QueryParam(value="position") String position, @QueryParam(value="returns") String returns) {
        QueryResult rsc;
        if (log.isDebugEnabled()) {
            log.debug("TRACK\t\t/query/" + queryName + "/drillthrough\tGET");
        }
        ResultSet rs = null;
        try {
            Long start = new Date().getTime();
            if (position == null) {
                rs = this.olapQueryService.drillthrough(queryName, maxrows.intValue(), returns);
            } else {
                String[] positions = position.split(":");
                ArrayList<Integer> cellPosition = new ArrayList<Integer>();
                for (String p : positions) {
                    Integer pInt = Integer.parseInt(p);
                    cellPosition.add(pInt);
                }
                rs = this.olapQueryService.drillthrough(queryName, cellPosition, maxrows, returns);
            }
            rsc = RestUtil.convert(rs);
            Long runtime = new Date().getTime() - start;
            rsc.setRuntime(runtime.intValue());
            return rsc;
        }
        catch (Exception e) {
            log.error("Cannot execute query (" + queryName + ")", (Throwable)e);
            String error = ExceptionUtils.getRootCauseMessage((Throwable)e);
            rsc = new QueryResult(error);
            return rsc;
        }
        finally {
            if (rs != null) {
                Statement statement = null;
                Connection con = null;
                try {
                    statement = rs.getStatement();
                    con = rs.getStatement().getConnection();
                }
                catch (Exception e) {
                    throw new SaikuServiceException((Throwable)e);
                }
                finally {
                    try {
                        rs.close();
                        if (statement != null) {
                            statement.close();
                        }
                    }
                    catch (Exception exception) {}
                    rs = null;
                }
            }
        }
    }

    @POST
    @Produces(value={"application/json"})
    @Path(value="/{queryname}/drillacross")
    public SaikuQuery drillacross(@PathParam(value="queryname") String queryName, @FormParam(value="position") String position, @FormParam(value="drill") String returns) {
        if (log.isDebugEnabled()) {
            log.debug("TRACK\t\t/query/" + queryName + "/drillacross\tPOST");
        }
        try {
            String[] positions = position.split(":");
            ArrayList<Integer> cellPosition = new ArrayList<Integer>();
            for (String p : positions) {
                Integer pInt = Integer.parseInt(p);
                cellPosition.add(pInt);
            }
            ObjectMapper mapper = new ObjectMapper();
            CollectionType ct = mapper.getTypeFactory().constructCollectionType(ArrayList.class, String.class);
            JavaType st = mapper.getTypeFactory().uncheckedSimpleType(String.class);
            Map levels = (Map)mapper.readValue(returns, (JavaType)mapper.getTypeFactory().constructMapType(Map.class, st, (JavaType)ct));
            return this.olapQueryService.drillacross(queryName, cellPosition, levels);
        }
        catch (Exception e) {
            log.error("Cannot execute query (" + queryName + ")", (Throwable)e);
            String error = ExceptionUtils.getRootCauseMessage((Throwable)e);
            throw new WebApplicationException(Response.serverError().entity((Object)error).build());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @GET
    @Produces(value={"text/csv"})
    @Path(value="/{queryname}/drillthrough/export/csv")
    public Response getDrillthroughExport(@PathParam(value="queryname") String queryName, @QueryParam(value="maxrows") @DefaultValue(value="100") Integer maxrows, @QueryParam(value="position") String position, @QueryParam(value="returns") String returns) {
        if (log.isDebugEnabled()) {
            log.debug("TRACK\t\t/query/" + queryName + "/drillthrough/export/csv (maxrows:" + maxrows + " position" + position + ")\tGET");
        }
        ResultSet rs = null;
        try {
            if (position == null) {
                rs = this.olapQueryService.drillthrough(queryName, maxrows.intValue(), returns);
            } else {
                Response positions = position.split(":");
                ArrayList<Integer> cellPosition = new ArrayList<Integer>();
                for (String p : positions) {
                    Integer pInt = Integer.parseInt(p);
                    cellPosition.add(pInt);
                }
                rs = this.olapQueryService.drillthrough(queryName, cellPosition, maxrows, returns);
            }
            byte[] doc = this.olapQueryService.exportResultSetCsv(rs);
            String name = SaikuProperties.webExportCsvName;
            Response response = Response.ok((Object)doc, (String)"application/octet-stream").header("content-disposition", (Object)("attachment; filename = " + name + "-drillthrough.csv")).header("content-length", (Object)doc.length).build();
            return response;
        }
        catch (Exception e) {
            log.error("Cannot export drillthrough query (" + queryName + ")", (Throwable)e);
            Response response = Response.serverError().build();
            return response;
        }
        finally {
            if (rs != null) {
                try {
                    try {
                        Statement statement = rs.getStatement();
                        statement.close();
                        rs.close();
                        rs = null;
                    }
                    catch (SQLException e) {
                        throw new SaikuServiceException((Throwable)e);
                    }
                }
                catch (Throwable throwable) {
                    rs = null;
                    throw throwable;
                }
            }
        }
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/{queryname}/result/{format}")
    public QueryResult execute(@PathParam(value="queryname") String queryName, @PathParam(value="format") String formatter, @QueryParam(value="limit") @DefaultValue(value="0") int limit) {
        if (log.isDebugEnabled()) {
            log.debug("TRACK\t\t/query/" + queryName + "/result" + formatter + "\tGET");
        }
        try {
            CellDataSet cs = this.olapQueryService.execute(queryName, formatter);
            return RestUtil.convert(cs, limit);
        }
        catch (Exception e) {
            log.error("Cannot execute query (" + queryName + ")", (Throwable)e);
            String error = ExceptionUtils.getRootCauseMessage((Throwable)e);
            return new QueryResult(error);
        }
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/{queryname}/axis/{axis}")
    public List<SaikuDimensionSelection> getAxisInfo(@PathParam(value="queryname") String queryName, @PathParam(value="axis") String axisName) {
        if (log.isDebugEnabled()) {
            log.debug("TRACK\t\t/query/" + queryName + "/axis/" + axisName + "\tGET");
        }
        return this.olapQueryService.getAxisSelection(queryName, axisName);
    }

    @DELETE
    @Produces(value={"application/json"})
    @Path(value="/{queryname}/axis/{axis}")
    public Response clearAxis(@PathParam(value="queryname") String queryName, @PathParam(value="axis") String axisName) {
        try {
            if (log.isDebugEnabled()) {
                log.debug("TRACK\t\t/query/" + queryName + "/axis/" + axisName + "\tDELETE");
            }
            String string = axisName = StringUtils.isNotBlank((String)axisName) ? axisName.toUpperCase() : null;
            if (axisName != null) {
                IQuery query = this.olapQueryService.clearAxis(queryName, axisName);
                return Response.ok().entity((Object)ObjectUtil.convert((IQuery)query)).build();
            }
            throw new Exception("Clear Axis: Axis name cannot be null");
        }
        catch (Exception e) {
            log.error("Cannot clear axis for query (" + queryName + ")", (Throwable)e);
            return Response.serverError().entity((Object)e.getMessage()).status(Response.Status.INTERNAL_SERVER_ERROR).build();
        }
    }

    @DELETE
    @Produces(value={"application/json"})
    @Path(value="/{queryname}/axis/")
    public void clearAllAxisSelections(@PathParam(value="queryname") String queryName) {
        if (log.isDebugEnabled()) {
            log.debug("TRACK\t\t/query/" + queryName + "/axis\tDELETE");
        }
        this.olapQueryService.resetQuery(queryName);
    }

    @PUT
    @Produces(value={"application/json"})
    @Path(value="/{queryname}/swapaxes")
    public SaikuQuery swapAxes(@PathParam(value="queryname") String queryName) {
        if (log.isDebugEnabled()) {
            log.debug("TRACK\t\t/query/" + queryName + "/swapaxes\tPUT");
        }
        IQuery query = this.olapQueryService.swapAxes(queryName);
        return ObjectUtil.convert((IQuery)query);
    }

    @POST
    @Produces(value={"application/json"})
    @Path(value="/{queryname}/cell/{position}/{value}")
    public Response.Status setCell(@PathParam(value="queryname") String queryName, @PathParam(value="position") String position, @PathParam(value="value") String value) {
        if (log.isDebugEnabled()) {
            log.debug("TRACK\t\t/query/" + queryName + "/cell/" + position + "/" + value + "\tGET");
        }
        String[] positions = position.split(":");
        ArrayList<Integer> cellPosition = new ArrayList<Integer>();
        for (String p : positions) {
            Integer pInt = Integer.parseInt(p);
            cellPosition.add(pInt);
        }
        this.olapQueryService.setCellValue(queryName, cellPosition, value);
        return Response.Status.OK;
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/{queryname}/axis/{axis}/dimension/{dimension}")
    public SaikuDimensionSelection getAxisDimensionInfo(@PathParam(value="queryname") String queryName, @PathParam(value="axis") String axis, @PathParam(value="dimension") String dimension) {
        try {
            if (log.isDebugEnabled()) {
                log.debug("TRACK\t\t/query/" + queryName + "/axis/" + axis + "/dimension/" + dimension + "\tGET");
            }
            return this.olapQueryService.getAxisDimensionSelections(queryName, axis, dimension);
        }
        catch (Exception e) {
            log.error("Cannot decode dimension " + dimension + " for query (" + queryName + ")", (Throwable)e);
            return this.olapQueryService.getAxisDimensionSelections(queryName, axis, dimension);
        }
    }

    @POST
    @Path(value="/{queryname}/axis/{axis}/dimension/{dimension}")
    public Response moveDimension(@PathParam(value="queryname") String queryName, @PathParam(value="axis") String axisName, @PathParam(value="dimension") String dimensionName, @FormParam(value="position") @DefaultValue(value="-1") int position) {
        try {
            if (log.isDebugEnabled()) {
                log.debug("TRACK\t\t/query/" + queryName + "/axis/" + axisName + "/dimension/" + dimensionName + "\tPOST");
            }
            this.olapQueryService.moveDimension(queryName, axisName, dimensionName, position);
            return Response.ok().build();
        }
        catch (Exception e) {
            log.error("Cannot move dimension " + dimensionName + " for query (" + queryName + ")", (Throwable)e);
            return Response.serverError().entity((Object)e.getMessage()).status(Response.Status.INTERNAL_SERVER_ERROR).build();
        }
    }

    @DELETE
    @Path(value="/{queryname}/axis/{axis}/dimension/{dimension}")
    public Response deleteDimension(@PathParam(value="queryname") String queryName, @PathParam(value="axis") String axisName, @PathParam(value="dimension") String dimensionName) {
        try {
            if (log.isDebugEnabled()) {
                log.debug("TRACK\t\t/query/" + queryName + "/axis/" + axisName + "/dimension/" + dimensionName + "\tDELETE");
            }
            this.olapQueryService.removeDimension(queryName, axisName, dimensionName);
            return Response.ok().build();
        }
        catch (Exception e) {
            log.error("Cannot remove dimension " + dimensionName + " for query (" + queryName + ")", (Throwable)e);
            return Response.serverError().entity((Object)e.getMessage()).status(Response.Status.INTERNAL_SERVER_ERROR).build();
        }
    }

    @PUT
    @Consumes(value={"application/x-www-form-urlencoded"})
    @Path(value="/{queryname}/zoomin")
    public SaikuQuery zoomIn(@PathParam(value="queryname") String queryName, @FormParam(value="selections") String positionListString) {
        try {
            ObjectMapper mapper;
            String[] positions;
            if (log.isDebugEnabled()) {
                log.debug("TRACK\t\t/query/" + queryName + "/zoomIn\tPUT");
            }
            ArrayList realPositions = new ArrayList();
            if (StringUtils.isNotBlank((String)positionListString) && (positions = (String[])(mapper = new ObjectMapper()).readValue(positionListString, (JavaType)mapper.getTypeFactory().constructArrayType(String.class))) != null && positions.length > 0) {
                for (String position : positions) {
                    String[] rPos = position.split(":");
                    ArrayList<Integer> cellPosition = new ArrayList<Integer>();
                    for (String p : rPos) {
                        Integer pInt = Integer.parseInt(p);
                        cellPosition.add(pInt);
                    }
                    realPositions.add(cellPosition);
                }
            }
            IQuery query = this.olapQueryService.zoomIn(queryName, realPositions);
            return ObjectUtil.convert((IQuery)query);
        }
        catch (Exception e) {
            log.error("Cannot updates selections for query (" + queryName + ")", (Throwable)e);
            throw new WebApplicationException((Throwable)e);
        }
    }

    @PUT
    @Consumes(value={"application/x-www-form-urlencoded"})
    @Path(value="/{queryname}/axis/{axis}/dimension/{dimension}/")
    public Response updateSelections(@PathParam(value="queryname") String queryName, @PathParam(value="axis") String axisName, @PathParam(value="dimension") String dimensionName, @FormParam(value="selections") String selectionJSON) {
        try {
            if (log.isDebugEnabled()) {
                log.debug("TRACK\t\t/query/" + queryName + "/axis/" + axisName + "/dimension/" + dimensionName + "\tPUT\t");
            }
            if (selectionJSON != null) {
                ObjectMapper mapper = new ObjectMapper();
                List selections = (List)mapper.readValue(selectionJSON, (JavaType)mapper.getTypeFactory().constructCollectionType(ArrayList.class, SelectionRestObject.class));
                for (SelectionRestObject selection : selections) {
                    if (selection.getType() != null && "member".equals(selection.getType().toLowerCase()) && selection.getAction() != null && "delete".equals(selection.getAction().toLowerCase())) {
                        this.olapQueryService.removeMember(queryName, dimensionName, selection.getUniquename(), "MEMBER");
                    }
                    if (selection.getType() == null || !"level".equals(selection.getType().toLowerCase()) || selection.getAction() == null || !"delete".equals(selection.getAction().toLowerCase())) continue;
                    this.olapQueryService.removeLevel(queryName, dimensionName, selection.getHierarchy(), selection.getUniquename());
                }
                for (SelectionRestObject selection : selections) {
                    if (selection.getType() != null && "member".equals(selection.getType().toLowerCase()) && selection.getAction() != null && "add".equals(selection.getAction().toLowerCase())) {
                        this.olapQueryService.includeMember(queryName, dimensionName, selection.getUniquename(), "MEMBER", selection.getTotalsFunction(), -1);
                    }
                    if (selection.getType() == null || !"level".equals(selection.getType().toLowerCase()) || selection.getAction() == null || !"add".equals(selection.getAction().toLowerCase())) continue;
                    this.olapQueryService.includeLevel(queryName, dimensionName, selection.getHierarchy(), selection.getUniquename(), selection.getTotalsFunction());
                }
                SaikuDimensionSelection dimsels = this.getAxisDimensionInfo(queryName, axisName, dimensionName);
                if (dimsels != null && dimsels.getSelections().size() == 0) {
                    this.moveDimension(queryName, "UNUSED", dimensionName, -1);
                }
                return Response.ok().build();
            }
            throw new Exception("Form did not contain 'selections' parameter");
        }
        catch (Exception e) {
            log.error("Cannot updates selections for query (" + queryName + ")", (Throwable)e);
            return Response.serverError().entity((Object)e.getMessage()).status(Response.Status.INTERNAL_SERVER_ERROR).build();
        }
    }

    @DELETE
    @Consumes(value={"application/x-www-form-urlencoded"})
    @Path(value="/{queryname}/axis/{axis}/dimension/{dimension}/member/")
    public Response removeMembers(@PathParam(value="queryname") String queryName, @PathParam(value="axis") String axisName, @PathParam(value="dimension") String dimensionName, MultivaluedMap<String, String> formParams) {
        try {
            if (log.isDebugEnabled()) {
                log.debug("TRACK\t\t/query/" + queryName + "/axis/" + axisName + "/dimension/" + dimensionName + "\tPUT");
            }
            if (formParams.containsKey((Object)"selections")) {
                LinkedList sels = (LinkedList)formParams.get((Object)"selections");
                String selectionJSON = (String)sels.getFirst();
                ObjectMapper mapper = new ObjectMapper();
                List selections = (List)mapper.readValue(selectionJSON, (JavaType)mapper.getTypeFactory().constructCollectionType(ArrayList.class, SelectionRestObject.class));
                for (SelectionRestObject member : selections) {
                    this.removeMember("MEMBER", queryName, axisName, dimensionName, member.getUniquename());
                }
                return Response.ok().build();
            }
            throw new Exception("Form did not contain 'selections' parameter");
        }
        catch (Exception e) {
            log.error("Cannot updates selections for query (" + queryName + ")", (Throwable)e);
            return Response.serverError().entity((Object)e.getMessage()).status(Response.Status.INTERNAL_SERVER_ERROR).build();
        }
    }

    @POST
    @Path(value="/{queryname}/axis/{axis}/dimension/{dimension}/member/{member}")
    public Response includeMember(@FormParam(value="selection") @DefaultValue(value="MEMBER") String selectionType, @PathParam(value="queryname") String queryName, @PathParam(value="axis") String axisName, @PathParam(value="dimension") String dimensionName, @PathParam(value="member") String uniqueMemberName, @FormParam(value="position") @DefaultValue(value="-1") int position, @FormParam(value="memberposition") @DefaultValue(value="-1") int memberposition) {
        try {
            if (log.isDebugEnabled()) {
                log.debug("TRACK\t\t/query/" + queryName + "/axis/" + axisName + "/dimension/" + dimensionName + "/member/" + uniqueMemberName + "\tPOST");
            }
            this.olapQueryService.moveDimension(queryName, axisName, dimensionName, position);
            boolean ret = this.olapQueryService.includeMember(queryName, dimensionName, uniqueMemberName, selectionType, memberposition);
            if (ret) {
                return Response.ok().status(Response.Status.CREATED).build();
            }
            throw new Exception("Couldn't include member " + dimensionName);
        }
        catch (Exception e) {
            log.error("Cannot include member " + dimensionName + " for query (" + queryName + ")", (Throwable)e);
            return Response.serverError().entity((Object)e.getMessage()).status(Response.Status.INTERNAL_SERVER_ERROR).build();
        }
    }

    @DELETE
    @Path(value="/{queryname}/axis/{axis}/dimension/{dimension}/member/{member}")
    public Response removeMember(@FormParam(value="selection") @DefaultValue(value="MEMBER") String selectionType, @PathParam(value="queryname") String queryName, @PathParam(value="axis") String axisName, @PathParam(value="dimension") String dimensionName, @PathParam(value="member") String uniqueMemberName) {
        try {
            boolean ret;
            if (log.isDebugEnabled()) {
                log.debug("TRACK\t\t/query/" + queryName + "/axis/" + axisName + "/dimension/" + dimensionName + "/member/" + uniqueMemberName + "\tDELETE");
            }
            if (ret = this.olapQueryService.removeMember(queryName, dimensionName, uniqueMemberName, selectionType)) {
                SaikuDimensionSelection dimsels = this.olapQueryService.getAxisDimensionSelections(queryName, axisName, dimensionName);
                if (dimsels != null && dimsels.getSelections().size() == 0) {
                    this.olapQueryService.moveDimension(queryName, "UNUSED", dimensionName, -1);
                }
                return Response.ok().build();
            }
            throw new Exception("Cannot remove member " + dimensionName + " for query (" + queryName + ")");
        }
        catch (Exception e) {
            log.error("Cannot remove member " + dimensionName + " for query (" + queryName + ")", (Throwable)e);
            return Response.serverError().entity((Object)e.getMessage()).status(Response.Status.INTERNAL_SERVER_ERROR).build();
        }
    }

    @PUT
    @Path(value="/{queryname}/axis/{axis}/dimension/{dimension}/children")
    public Response includeChildren(@PathParam(value="queryname") String queryName, @PathParam(value="axis") String axisName, @PathParam(value="dimension") String dimensionName, @FormParam(value="member") String uniqueMemberName) {
        try {
            boolean ret;
            if (log.isDebugEnabled()) {
                log.debug("TRACK\t\t/query/" + queryName + "/axis/" + axisName + "/dimension/" + dimensionName + "/children/" + uniqueMemberName + "\tPOST");
            }
            if (ret = this.olapQueryService.includeChildren(queryName, dimensionName, uniqueMemberName)) {
                return Response.ok().status(Response.Status.CREATED).build();
            }
            throw new Exception("Couldn't include children for " + uniqueMemberName);
        }
        catch (Exception e) {
            log.error("Cannot include children for " + dimensionName + " for query (" + queryName + ")", (Throwable)e);
            return Response.serverError().entity((Object)e.getMessage()).status(Response.Status.INTERNAL_SERVER_ERROR).build();
        }
    }

    @DELETE
    @Path(value="/{queryname}/axis/{axis}/dimension/{dimension}/children")
    public Response removeChildren(@PathParam(value="queryname") String queryName, @PathParam(value="axis") String axisName, @PathParam(value="dimension") String dimensionName, @FormParam(value="member") String uniqueMemberName) {
        if (log.isDebugEnabled()) {
            log.debug("TRACK\t\t/query/" + queryName + "/axis/" + axisName + "/dimension/" + dimensionName + "/children/" + uniqueMemberName + "\tDELETE");
        }
        try {
            boolean ret = this.olapQueryService.removeChildren(queryName, dimensionName, uniqueMemberName);
            if (ret) {
                return Response.ok().status(Response.Status.GONE).build();
            }
            throw new Exception("Couldn't remove children for " + uniqueMemberName);
        }
        catch (Exception e) {
            log.error("Cannot remove children for " + dimensionName + " for query (" + queryName + ")", (Throwable)e);
            return Response.serverError().entity((Object)e.getMessage()).status(Response.Status.INTERNAL_SERVER_ERROR).build();
        }
    }

    @POST
    @Path(value="/{queryname}/axis/{axis}/dimension/{dimension}/hierarchy/{hierarchy}/{level}")
    public Response includeLevel(@PathParam(value="queryname") String queryName, @PathParam(value="axis") String axisName, @PathParam(value="dimension") String dimensionName, @PathParam(value="hierarchy") String uniqueHierarchyName, @PathParam(value="level") String uniqueLevelName, @FormParam(value="position") @DefaultValue(value="-1") int position) {
        try {
            if (log.isDebugEnabled()) {
                log.debug("TRACK\t\t/query/" + queryName + "/axis/" + axisName + "/dimension/" + dimensionName + "/hierarchy/" + uniqueHierarchyName + "/" + uniqueLevelName + "\tPOST");
            }
            this.olapQueryService.moveDimension(queryName, axisName, dimensionName, position);
            boolean ret = this.olapQueryService.includeLevel(queryName, dimensionName, uniqueHierarchyName, uniqueLevelName);
            if (ret) {
                return Response.ok().status(Response.Status.CREATED).build();
            }
            throw new Exception("Something went wrong including level: " + uniqueLevelName);
        }
        catch (Exception e) {
            log.error("Cannot include level of hierarchy " + uniqueHierarchyName + " for query (" + queryName + ")", (Throwable)e);
            return Response.serverError().entity((Object)e.getMessage()).status(Response.Status.INTERNAL_SERVER_ERROR).build();
        }
    }

    @DELETE
    @Path(value="/{queryname}/axis/{axis}/dimension/{dimension}/hierarchy/{hierarchy}/{level}")
    public Response removeLevel(@PathParam(value="queryname") String queryName, @PathParam(value="axis") String axisName, @PathParam(value="dimension") String dimensionName, @PathParam(value="hierarchy") String uniqueHierarchyName, @PathParam(value="level") String uniqueLevelName) {
        try {
            boolean ret;
            if (log.isDebugEnabled()) {
                log.debug("TRACK\t\t/query/" + queryName + "/axis/" + axisName + "/dimension/" + dimensionName + "/hierarchy/" + uniqueHierarchyName + "/" + uniqueLevelName + "\tDELETE");
            }
            if (ret = this.olapQueryService.removeLevel(queryName, dimensionName, uniqueHierarchyName, uniqueLevelName)) {
                SaikuDimensionSelection dimsels = this.olapQueryService.getAxisDimensionSelections(queryName, axisName, dimensionName);
                if (dimsels != null && dimsels.getSelections().size() == 0) {
                    this.olapQueryService.moveDimension(queryName, "UNUSED", dimensionName, -1);
                }
                return Response.ok().build();
            }
            log.error("Cannot remove level of hierarchy " + uniqueHierarchyName + " for query (" + queryName + ")");
            throw new Exception("Something went wrong removing level: " + uniqueLevelName + " from " + uniqueHierarchyName + " for query (" + queryName + ")");
        }
        catch (Exception e) {
            log.error("Cannot include level of hierarchy " + uniqueHierarchyName + " for query (" + queryName + ")", (Throwable)e);
            return Response.serverError().entity((Object)e.getMessage()).status(Response.Status.INTERNAL_SERVER_ERROR).build();
        }
    }

    @PUT
    @Produces(value={"application/json"})
    @Path(value="/{queryname}/tag")
    public Response.Status activateTag(@PathParam(value="queryname") String queryName, @FormParam(value="tag") String tagJSON) {
        if (log.isDebugEnabled()) {
            log.debug("TRACK\t\t/query/" + queryName + "/tags\tPUT");
        }
        try {
            ObjectMapper mapper = new ObjectMapper();
            mapper.setVisibilityChecker(mapper.getVisibilityChecker().withFieldVisibility(JsonAutoDetect.Visibility.ANY));
            SaikuTag tag = (SaikuTag)mapper.readValue(tagJSON, SaikuTag.class);
            this.olapQueryService.setTag(queryName, tag);
            return Response.Status.OK;
        }
        catch (Exception e) {
            log.error("Cannot add tag " + tagJSON + " for query (" + queryName + ")", (Throwable)e);
            return Response.Status.INTERNAL_SERVER_ERROR;
        }
    }

    @DELETE
    @Produces(value={"application/json"})
    @Path(value="/{queryname}/tag")
    public Response.Status deactivateTag(@PathParam(value="queryname") String queryName, @PathParam(value="tagname") String tagName) {
        if (log.isDebugEnabled()) {
            log.debug("TRACK\t\t/query/" + queryName + "/tags\tPUT");
        }
        try {
            this.olapQueryService.disableTag(queryName);
            return Response.Status.OK;
        }
        catch (Exception e) {
            log.error("Cannot remove tag " + tagName + " for query (" + queryName + ")", (Throwable)e);
            return Response.Status.INTERNAL_SERVER_ERROR;
        }
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/{queryname}/filter")
    public Response getFilter(@PathParam(value="queryname") String queryName, @QueryParam(value="dimension") String dimension, @QueryParam(value="hierarchy") String hierarchy, @QueryParam(value="level") String level) {
        if (log.isDebugEnabled()) {
            log.debug("TRACK\t\t/query/" + queryName + "/filter\tGET");
        }
        try {
            SaikuFilter t = this.olapQueryService.getFilter(queryName, "new", dimension, hierarchy, level);
            return Response.ok((Object)t).build();
        }
        catch (Exception e) {
            log.error("Cannot get filter for query (" + queryName + ")", (Throwable)e);
            String error = ExceptionUtils.getRootCauseMessage((Throwable)e);
            return Response.serverError().entity((Object)error).build();
        }
    }

    @PUT
    @Produces(value={"application/json"})
    @Path(value="/{queryname}/filter")
    public Response activateFilter(@PathParam(value="queryname") String queryName, @FormParam(value="filter") String filterJSON) {
        if (log.isDebugEnabled()) {
            log.debug("TRACK\t\t/query/" + queryName + "/tags\tPUT");
        }
        try {
            ObjectMapper mapper = new ObjectMapper();
            mapper.setVisibilityChecker(mapper.getVisibilityChecker().withFieldVisibility(JsonAutoDetect.Visibility.ANY));
            SaikuFilter filter = (SaikuFilter)mapper.readValue(filterJSON, SaikuFilter.class);
            SaikuQuery sq = this.olapQueryService.applyFilter(queryName, filter);
            return Response.ok((Object)sq).build();
        }
        catch (Exception e) {
            log.error("Cannot activate filter for query (" + queryName + "), json:" + filterJSON, (Throwable)e);
            String error = ExceptionUtils.getRootCauseMessage((Throwable)e);
            return Response.serverError().entity((Object)error).build();
        }
    }

    @DELETE
    @Produces(value={"application/json"})
    @Path(value="/{queryname}/filter")
    public Response deactivateFilter(@PathParam(value="queryname") String queryName) {
        if (log.isDebugEnabled()) {
            log.debug("TRACK\t\t/query/" + queryName + "/tags\tPUT");
        }
        try {
            SaikuQuery sq = this.olapQueryService.removeFilter(queryName);
            return Response.ok((Object)sq).build();
        }
        catch (Exception e) {
            log.error("Cannot remove filter for query (" + queryName + ")", (Throwable)e);
            String error = ExceptionUtils.getRootCauseMessage((Throwable)e);
            return Response.serverError().entity((Object)error).build();
        }
    }

    @POST
    @Produces(value={"application/json"})
    @Path(value="/{queryname}/axis/{axis}/sort/{sortorder}/{sortliteral}")
    public void sortAxis(@PathParam(value="queryname") String queryName, @PathParam(value="axis") String axisName, @PathParam(value="sortorder") String sortOrder, @PathParam(value="sortliteral") String sortLiteral) {
        if (log.isDebugEnabled()) {
            log.debug("TRACK\t\t/query/" + queryName + "/axis/" + axisName + "/sort/" + sortOrder + "/" + sortLiteral + "\tPOST");
        }
        this.olapQueryService.sortAxis(queryName, axisName, sortLiteral, sortOrder);
    }

    @PUT
    @Produces(value={"application/json"})
    @Path(value="/{queryname}/axis/{axis}/show_totals/{function}")
    public SaikuQuery showGrandTotals(@PathParam(value="queryname") String queryName, @PathParam(value="axis") String axisName, @PathParam(value="function") String functionName) {
        if (log.isDebugEnabled()) {
            log.debug("TRACK\t\t/query/" + queryName + "/axis/" + axisName + "/show_totals/" + functionName + "\tPUT");
        }
        IQuery query = this.olapQueryService.showGrandTotals(queryName, axisName, functionName);
        return ObjectUtil.convert((IQuery)query);
    }

    @DELETE
    @Produces(value={"application/json"})
    @Path(value="/{queryname}/axis/{axis}/sort")
    public void clearSortAxis(@PathParam(value="queryname") String queryName, @PathParam(value="axis") String axisName) {
        if (log.isDebugEnabled()) {
            log.debug("TRACK\t\t/query/" + queryName + "/axis/" + axisName + "/sort/\tDELETE");
        }
        this.olapQueryService.clearSort(queryName, axisName);
    }

    @POST
    @Produces(value={"application/json"})
    @Path(value="/{queryname}/axis/{axis}/limit/{limitfunction}")
    public void limitAxis(@PathParam(value="queryname") String queryName, @PathParam(value="axis") String axisName, @PathParam(value="limitfunction") String limitfunction, @FormParam(value="n") String n, @FormParam(value="sortliteral") String sortLiteral) {
        if (log.isDebugEnabled()) {
            log.debug("TRACK\t\t/query/" + queryName + "/axis/" + axisName + "/limit/" + limitfunction + "(" + n + ", sort:" + sortLiteral + "\tPOST");
        }
        this.olapQueryService.limitAxis(queryName, axisName, limitfunction, n, sortLiteral);
    }

    @DELETE
    @Produces(value={"application/json"})
    @Path(value="/{queryname}/axis/{axis}/limit")
    public void clearLimitAxis(@PathParam(value="queryname") String queryName, @PathParam(value="axis") String axisName) {
        if (log.isDebugEnabled()) {
            log.debug("TRACK\t\t/query/" + queryName + "/axis/" + axisName + "/limit/\tDELETE");
        }
        this.olapQueryService.clearLimit(queryName, axisName);
    }

    @POST
    @Produces(value={"application/json"})
    @Path(value="/{queryname}/axis/{axis}/filter")
    public void filterAxis(@PathParam(value="queryname") String queryName, @PathParam(value="axis") String axisName, @FormParam(value="filterCondition") String filterCondition) {
        if (log.isDebugEnabled()) {
            log.debug("TRACK\t\t/query/" + queryName + "/axis/" + axisName + "/filter/ (" + filterCondition + " )\tPOST");
        }
        this.olapQueryService.filterAxis(queryName, axisName, filterCondition);
    }

    @DELETE
    @Produces(value={"application/json"})
    @Path(value="/{queryname}/axis/{axis}/filter")
    public void clearFilter(@PathParam(value="queryname") String queryName, @PathParam(value="axis") String axisName) {
        if (log.isDebugEnabled()) {
            log.debug("TRACK\t\t/query/" + queryName + "/axis/" + axisName + "/filter/\tDELETE");
        }
        this.olapQueryService.clearFilter(queryName, axisName);
    }
}

