/*
 * Decompiled with CFR 0.152.
 */
package org.saiku.web.rest.resources;

import jakarta.servlet.http.HttpServletRequest;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.saiku.olap.query2.ThinQuery;
import org.saiku.web.rest.objects.resultset.QueryResult;
import org.saiku.web.rest.resources.ISaikuRepository;
import org.saiku.web.rest.resources.Query2Resource;
import org.saiku.web.rest.util.ServletUtil;
import org.saiku.web.svg.Converter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
@Path(value="/saiku/{username}/export")
@XmlAccessorType(value=XmlAccessType.NONE)
public class ExporterResource {
    private static final Logger log = LoggerFactory.getLogger(ExporterResource.class);
    private ISaikuRepository repository;
    private Query2Resource query2Resource;

    public void setQuery2Resource(Query2Resource qr) {
        this.query2Resource = qr;
    }

    public void setRepository(ISaikuRepository repository) {
        this.repository = repository;
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/saiku/xls")
    public Response exportExcel(@QueryParam(value="file") String file, @QueryParam(value="formatter") String formatter, @QueryParam(value="name") String name, @Context HttpServletRequest servletRequest) {
        try {
            Response f = this.repository.getResource(file);
            String fileContent = new String((byte[])f.getEntity());
            String queryName = UUID.randomUUID().toString();
            Map<String, String> parameters = ServletUtil.getParameters(servletRequest);
            ThinQuery tq = this.query2Resource.createQuery(queryName, fileContent, null, null);
            if (parameters != null) {
                tq.getParameters().putAll(parameters);
            }
            if (StringUtils.isNotBlank((String)formatter)) {
                HashMap<String, String> p = new HashMap<String, String>();
                p.put("saiku.olap.result.formatter", formatter);
                if (tq.getProperties() == null) {
                    tq.setProperties(p);
                } else {
                    tq.getProperties().putAll(p);
                }
            }
            this.query2Resource.execute(tq);
            return this.query2Resource.getQueryExcelExport(queryName, formatter, name);
        }
        catch (Exception e) {
            log.error("Error exporting XLS for file: " + file, (Throwable)e);
            return Response.serverError().entity((Object)e.getMessage()).status(Response.Status.INTERNAL_SERVER_ERROR).build();
        }
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/saiku/csv")
    public Response exportCsv(@QueryParam(value="file") String file, @QueryParam(value="formatter") String formatter, @Context HttpServletRequest servletRequest) {
        try {
            Response f = this.repository.getResource(file);
            String fileContent = new String((byte[])f.getEntity());
            String queryName = UUID.randomUUID().toString();
            Map<String, String> parameters = ServletUtil.getParameters(servletRequest);
            ThinQuery tq = this.query2Resource.createQuery(queryName, fileContent, null, null);
            if (parameters != null) {
                tq.getParameters().putAll(parameters);
            }
            if (StringUtils.isNotBlank((String)formatter)) {
                HashMap<String, String> p = new HashMap<String, String>();
                p.put("saiku.olap.result.formatter", formatter);
                if (tq.getProperties() == null) {
                    tq.setProperties(p);
                } else {
                    tq.getProperties().putAll(p);
                }
            }
            this.query2Resource.execute(tq);
            return this.query2Resource.getQueryCsvExport(queryName);
        }
        catch (Exception e) {
            log.error("Error exporting CSV for file: " + file, (Throwable)e);
            return Response.serverError().entity((Object)e.getMessage()).status(Response.Status.INTERNAL_SERVER_ERROR).build();
        }
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/saiku/json")
    public Response exportJson(@QueryParam(value="file") String file, @QueryParam(value="formatter") String formatter, @Context HttpServletRequest servletRequest) {
        try {
            Response f = this.repository.getResource(file);
            String fileContent = new String((byte[])f.getEntity());
            fileContent = ServletUtil.replaceParameters(servletRequest, fileContent);
            String queryName = UUID.randomUUID().toString();
            Map<String, String> parameters = ServletUtil.getParameters(servletRequest);
            ThinQuery tq = this.query2Resource.createQuery(queryName, fileContent, null, null);
            if (parameters != null) {
                tq.getParameters().putAll(parameters);
            }
            if (StringUtils.isNotBlank((String)formatter)) {
                HashMap<String, String> p = new HashMap<String, String>();
                p.put("saiku.olap.result.formatter", formatter);
                if (tq.getProperties() == null) {
                    tq.setProperties(p);
                } else {
                    tq.getProperties().putAll(p);
                }
            }
            QueryResult qr = this.query2Resource.execute(tq);
            return Response.ok().entity((Object)qr).build();
        }
        catch (Exception e) {
            log.error("Error exporting JSON for file: " + file, (Throwable)e);
            return Response.serverError().entity((Object)e.getMessage()).status(Response.Status.INTERNAL_SERVER_ERROR).build();
        }
    }

    @GET
    @Produces(value={"text/html"})
    @Path(value="/saiku/html")
    public Response exportHtml(@QueryParam(value="file") String file, @QueryParam(value="formatter") String formatter, @QueryParam(value="css") @DefaultValue(value="false") Boolean css, @QueryParam(value="tableonly") @DefaultValue(value="false") Boolean tableonly, @QueryParam(value="wrapcontent") @DefaultValue(value="true") Boolean wrapcontent, @Context HttpServletRequest servletRequest) {
        try {
            Response f = this.repository.getResource(file);
            String fileContent = new String((byte[])f.getEntity());
            fileContent = ServletUtil.replaceParameters(servletRequest, fileContent);
            String queryName = UUID.randomUUID().toString();
            this.query2Resource.createQuery(queryName, fileContent, null, null);
            return this.query2Resource.exportHtml(queryName, formatter, css, tableonly, wrapcontent);
        }
        catch (Exception e) {
            log.error("Error exporting JSON for file: " + file, (Throwable)e);
            return Response.serverError().entity((Object)e.getMessage()).status(Response.Status.INTERNAL_SERVER_ERROR).build();
        }
    }

    @POST
    @Produces(value={"image/*"})
    @Path(value="/saiku/chart")
    public Response exportChart(@FormParam(value="type") @DefaultValue(value="png") String type, @FormParam(value="svg") String svg, @FormParam(value="size") Integer size, @FormParam(value="name") String name) {
        try {
            if (StringUtils.isBlank((String)svg)) {
                throw new Exception("Missing 'svg' parameter");
            }
            if (ExporterResource.getVersion() != null && !ExporterResource.getVersion().contains("EE")) {
                String watermark = IOUtils.toString((URL)ExporterResource.class.getResource("/org/saiku/web/svg/watermark.svg"));
                svg = svg.replace("</svg>", watermark + "</svg>");
            }
            ByteArrayInputStream in = new ByteArrayInputStream(svg.getBytes("UTF-8"));
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            out.flush();
            Converter converter = Converter.byType(type.toUpperCase());
            if (converter == null) {
                throw new Exception("Missing converter.");
            }
            converter.convert(in, out, size);
            byte[] b = out.toByteArray();
            if (name == null || name.equals("")) {
                name = "chart-" + new SimpleDateFormat("yyyy-MM-dd-hhmmss").format(new Date());
            }
            return Response.ok((Object)b).type(converter.getContentType()).header("content-disposition", (Object)("attachment; filename = " + name + "." + converter.getExtension())).header("content-length", (Object)b.length).build();
        }
        catch (Exception e) {
            log.error("Error exporting Chart to  " + type, (Throwable)e);
            return Response.serverError().entity((Object)e.getMessage()).status(Response.Status.INTERNAL_SERVER_ERROR).build();
        }
    }

    private static String getVersion() {
        Properties prop = new Properties();
        Object input = null;
        String version = "";
        ClassLoader classloader = Thread.currentThread().getContextClassLoader();
        InputStream is = classloader.getResourceAsStream("org/saiku/web/rest/resources/version.properties");
        try {
            prop.load(is);
            version = prop.getProperty("VERSION");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return version;
    }
}

