/*
 * Decompiled with CFR 0.152.
 */
package org.saiku.web.rest.resources;

import com.qmino.miredot.annotations.ReturnType;
import com.sun.jersey.core.header.FormDataContentDisposition;
import com.sun.jersey.multipart.FormDataParam;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.apache.commons.vfs.FileObject;
import org.apache.commons.vfs.FileSystemManager;
import org.apache.commons.vfs.VFS;
import org.saiku.repository.AclEntry;
import org.saiku.repository.IRepositoryObject;
import org.saiku.service.ISessionService;
import org.saiku.service.datasource.DatasourceService;
import org.saiku.service.util.exception.SaikuServiceException;
import org.saiku.web.rest.resources.ISaikuRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
@Path(value="/saiku/api/repository")
public class BasicRepositoryResource2
implements ISaikuRepository {
    private static final Logger log = LoggerFactory.getLogger(BasicRepositoryResource2.class);
    private ISessionService sessionService;
    private DatasourceService datasourceService;
    private FileObject repo;

    public void setDatasourceService(DatasourceService ds) {
        this.datasourceService = ds;
    }

    public void setPath(String path) throws Exception {
        try {
            FileSystemManager fileSystemManager;
            FileObject fileObject;
            if (!path.endsWith("" + File.separatorChar)) {
                path = path + File.separatorChar;
            }
            if ((fileObject = (fileSystemManager = VFS.getManager()).resolveFile(path)) == null) {
                throw new IOException("File cannot be resolved: " + path);
            }
            if (!fileObject.exists()) {
                throw new IOException("File does not exist: " + path);
            }
            this.repo = fileObject;
        }
        catch (Exception e) {
            log.error("Error setting path for repository: " + path, (Throwable)e);
        }
    }

    public void setSessionService(ISessionService sessionService) {
        this.sessionService = sessionService;
    }

    @Override
    @GET
    @Produces(value={"application/json"})
    public List<IRepositoryObject> getRepository(@QueryParam(value="path") String path, @QueryParam(value="type") String type) {
        if (this.sessionService == null || this.sessionService.getAllSessionObjects() == null || this.sessionService.getAllSessionObjects().get("username") == null) {
            return new ArrayList<IRepositoryObject>();
        }
        String username = this.sessionService.getAllSessionObjects().get("username").toString();
        List roles = (List)this.sessionService.getAllSessionObjects().get("roles");
        String[] t = type.split(",");
        List l = path == null ? this.datasourceService.getFiles(Arrays.asList(t), username, roles) : this.datasourceService.getFiles(Arrays.asList(t), username, roles, path);
        return l;
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/resource/acl")
    @ReturnType(value="org.saiku.repository.AclEntry")
    public AclEntry getResourceAcl(@QueryParam(value="file") String file) {
        try {
            String username = this.sessionService.getAllSessionObjects().get("username").toString();
            List roles = (List)this.sessionService.getAllSessionObjects().get("roles");
            return this.datasourceService.getResourceACL(file, username, roles);
        }
        catch (Exception e) {
            log.error("Error retrieving ACL for file: " + file, (Throwable)e);
            throw new SaikuServiceException("You dont have permission to retrieve ACL for file: " + file);
        }
    }

    @POST
    @Produces(value={"application/json"})
    @Path(value="/resource/acl")
    public Response setResourceAcl(@FormParam(value="file") String file, @FormParam(value="acl") String aclEntry) {
        try {
            String username = this.sessionService.getAllSessionObjects().get("username").toString();
            List roles = (List)this.sessionService.getAllSessionObjects().get("roles");
            this.datasourceService.setResourceACL(file, aclEntry, username, roles);
            return Response.ok().build();
        }
        catch (Exception e) {
            log.error("An error occured while setting permissions to file: " + file, (Throwable)e);
            return Response.serverError().build();
        }
    }

    @Override
    @GET
    @Produces(value={"text/plain"})
    @Path(value="/resource")
    public Response getResource(@QueryParam(value="file") String file) {
        String username = this.sessionService.getAllSessionObjects().get("username").toString();
        List roles = (List)this.sessionService.getAllSessionObjects().get("roles");
        byte[] data = new byte[]{};
        try {
            data = this.datasourceService.getFileData(file, username, roles).getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            log.error("Error reading file encoding", (Throwable)e);
        }
        return Response.ok((Object)data, (String)"text/plain").header("content-length", (Object)data.length).build();
    }

    @Override
    @POST
    @Path(value="/resource")
    public Response saveResource(@FormParam(value="file") String file, @FormParam(value="content") String content) {
        List roles;
        String username = this.sessionService.getAllSessionObjects().get("username").toString();
        String resp = this.datasourceService.saveFile(content, file, username, roles = (List)this.sessionService.getAllSessionObjects().get("roles"));
        if (resp.equals("Save Okay")) {
            return Response.ok().build();
        }
        return Response.serverError().entity((Object)("Cannot save resource to ( file: " + file + ")")).type("text/plain").build();
    }

    @Override
    @DELETE
    @Path(value="/resource")
    public Response deleteResource(@QueryParam(value="file") String file) {
        List roles;
        String username = this.sessionService.getAllSessionObjects().get("username").toString();
        String resp = this.datasourceService.removeFile(file, username, roles = (List)this.sessionService.getAllSessionObjects().get("roles"));
        if (resp.equals("Remove Okay")) {
            return Response.ok().build();
        }
        return Response.serverError().entity((Object)("Cannot save resource to ( file: " + file + ")")).type("text/plain").build();
    }

    @POST
    @Path(value="/resource/move")
    public Response moveResource(@FormParam(value="source") String source, @FormParam(value="target") String target) {
        List roles;
        String username = this.sessionService.getAllSessionObjects().get("username").toString();
        String resp = this.datasourceService.moveFile(source, target, username, roles = (List)this.sessionService.getAllSessionObjects().get("roles"));
        if (resp.equals("Move Okay")) {
            return Response.ok().entity((Object)"{}").build();
        }
        return Response.serverError().entity((Object)("Cannot move resource to ( file: " + target + ")")).type("text/plain").build();
    }

    @POST
    @Path(value="/zipupload")
    @Consumes(value={"multipart/form-data"})
    public Response uploadArchiveZip(@QueryParam(value="test") String test, @FormDataParam(value="file") InputStream uploadedInputStream, @FormDataParam(value="file") FormDataContentDisposition fileDetail, @FormDataParam(value="directory") String directory) {
        String zipFile = fileDetail.getFileName();
        String output = "";
        try {
            if (StringUtils.isBlank((String)zipFile)) {
                throw new Exception("You must specify a zip file to upload");
            }
            output = "Uploding file: " + zipFile + " ...\r\n";
            ZipInputStream zis = new ZipInputStream(uploadedInputStream);
            ZipEntry ze = zis.getNextEntry();
            byte[] doc = null;
            boolean isFile = false;
            if (ze == null) {
                doc = IOUtils.toByteArray((InputStream)uploadedInputStream);
                isFile = true;
            }
            while (ze != null || doc != null) {
                String fileName = null;
                if (!isFile) {
                    fileName = ze.getName();
                    doc = IOUtils.toByteArray((InputStream)zis);
                } else {
                    fileName = zipFile;
                }
                output = output + "Saving " + fileName + "... ";
                String fullPath = StringUtils.isNotBlank((String)directory) ? directory + "/" + fileName : fileName;
                String content = new String(doc);
                Response r = this.saveResource(fullPath, content);
                doc = null;
                output = Response.Status.OK.getStatusCode() != r.getStatus() ? output + " ERROR: " + r.getEntity().toString() + "\r\n" : output + " OK\r\n";
                if (isFile) continue;
                ze = zis.getNextEntry();
            }
            if (!isFile) {
                zis.closeEntry();
                zis.close();
            }
            uploadedInputStream.close();
            output = output + " SUCCESSFUL!\r\n";
            return Response.ok((Object)output).build();
        }
        catch (Exception e) {
            log.error("Cannot unzip resources " + zipFile, (Throwable)e);
            String error = ExceptionUtils.getRootCauseMessage((Throwable)e);
            return Response.serverError().entity((Object)(output + "\r\n" + error)).build();
        }
    }
}

