/*
 * Decompiled with CFR 0.152.
 */
package org.saiku.service.util.export.excel;

import java.awt.Color;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import org.apache.commons.lang.StringUtils;
import org.apache.poi.hssf.usermodel.HSSFPalette;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.SpreadsheetVersion;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.DataFormat;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFColor;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.olap4j.metadata.Measure;
import org.saiku.olap.dto.resultset.AbstractBaseCell;
import org.saiku.olap.dto.resultset.CellDataSet;
import org.saiku.olap.dto.resultset.DataCell;
import org.saiku.olap.dto.resultset.MemberCell;
import org.saiku.olap.query2.ThinHierarchy;
import org.saiku.olap.query2.ThinLevel;
import org.saiku.olap.query2.ThinMember;
import org.saiku.olap.util.SaikuProperties;
import org.saiku.service.olap.totals.TotalNode;
import org.saiku.service.olap.totals.aggregators.BlankAggregator;
import org.saiku.service.olap.totals.aggregators.TotalAggregator;
import org.saiku.service.util.exception.SaikuServiceException;
import org.saiku.service.util.export.excel.ExcelBuilderOptions;
import org.saiku.service.util.export.excel.ExcelMergedRegionItemConfig;
import org.saiku.service.util.export.excel.FormatUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExcelWorksheetBuilder {
    private static final String BASIC_SHEET_FONT_FAMILY = "Arial";
    private static final short BASIC_SHEET_FONT_SIZE = 11;
    private static final String EMPTY_STRING = "";
    private static final String CSS_COLORS_CODE_PROPERTIES = "css-colors-codes.properties";
    private int maxRows = -1;
    private int maxColumns = -1;
    private AbstractBaseCell[][] rowsetHeader;
    private AbstractBaseCell[][] rowsetBody;
    private Map<Integer, TotalAggregator[][]> rowScanTotals;
    private Map<Integer, TotalAggregator[][]> colScanTotals;
    private CellDataSet table;
    private Workbook excelWorkbook;
    private Sheet workbookSheet;
    private String sheetName;
    private int topLeftCornerWidth;
    private int topLeftCornerHeight;
    private CellStyle basicCS;
    private CellStyle totalsCS;
    private CellStyle numberCS;
    private CellStyle lighterHeaderCellCS;
    private List<ThinHierarchy> queryFilters;
    private Map<String, Integer> colorCodesMap;
    private int nextAvailableColorCode = 41;
    private Properties cssColorCodesProperties;
    private HSSFPalette customColorsPalette;
    private ExcelBuilderOptions options;
    private static final Logger log = LoggerFactory.getLogger(ExcelWorksheetBuilder.class);

    public ExcelWorksheetBuilder(CellDataSet table, List<ThinHierarchy> filters, ExcelBuilderOptions options) {
        this.init(table, filters, options);
    }

    private void init(CellDataSet table, List<ThinHierarchy> filters, ExcelBuilderOptions options) {
        this.table = table;
        this.options = options;
        this.queryFilters = filters;
        this.maxRows = SpreadsheetVersion.EXCEL2007.getMaxRows();
        this.maxColumns = SpreadsheetVersion.EXCEL2007.getMaxColumns();
        if ("xls".equals(SaikuProperties.webExportExcelFormat)) {
            HSSFWorkbook wb = new HSSFWorkbook();
            this.customColorsPalette = wb.getCustomPalette();
            this.excelWorkbook = wb;
            this.maxRows = SpreadsheetVersion.EXCEL97.getMaxRows();
            this.maxColumns = SpreadsheetVersion.EXCEL97.getMaxColumns();
        } else {
            this.excelWorkbook = "xlsx".equals(SaikuProperties.webExportExcelFormat) ? new XSSFWorkbook() : new XSSFWorkbook();
        }
        this.colorCodesMap = new HashMap<String, Integer>();
        this.sheetName = options.sheetName;
        this.rowsetHeader = table.getCellSetHeaders();
        this.rowsetBody = table.getCellSetBody();
        this.topLeftCornerWidth = this.findTopLeftCornerWidth();
        this.topLeftCornerHeight = this.findTopLeftCornerHeight();
        this.initCellStyles();
        this.rowScanTotals = new HashMap<Integer, TotalAggregator[][]>();
        this.colScanTotals = new HashMap<Integer, TotalAggregator[][]>();
        this.scanRowAndColumnAggregations(table.getRowTotalsLists(), this.rowScanTotals, table.getColTotalsLists(), this.colScanTotals);
    }

    private void initCellStyles() {
        Font font = this.excelWorkbook.createFont();
        font.setFontHeightInPoints((short)11);
        font.setFontName(BASIC_SHEET_FONT_FAMILY);
        this.basicCS = this.excelWorkbook.createCellStyle();
        this.basicCS.setFont(font);
        this.basicCS.setAlignment(HorizontalAlignment.LEFT);
        this.basicCS.setVerticalAlignment(VerticalAlignment.TOP);
        this.setCellBordersColor(this.basicCS);
        Font totalsFont = this.excelWorkbook.createFont();
        totalsFont.setFontHeightInPoints((short)11);
        totalsFont.setBold(true);
        totalsFont.setFontName(BASIC_SHEET_FONT_FAMILY);
        this.totalsCS = this.excelWorkbook.createCellStyle();
        this.totalsCS.setFont(totalsFont);
        this.totalsCS.setAlignment(HorizontalAlignment.RIGHT);
        this.setCellBordersColor(this.totalsCS);
        this.numberCS = this.excelWorkbook.createCellStyle();
        this.numberCS.setFont(font);
        this.numberCS.setAlignment(HorizontalAlignment.RIGHT);
        DataFormat fmt = this.excelWorkbook.createDataFormat();
        short dataFormat = fmt.getFormat(SaikuProperties.webExportExcelDefaultNumberFormat);
        this.numberCS.setDataFormat(dataFormat);
        Font headerFont = this.excelWorkbook.createFont();
        headerFont.setFontHeightInPoints((short)11);
        headerFont.setFontName(BASIC_SHEET_FONT_FAMILY);
        headerFont.setBold(true);
        this.lighterHeaderCellCS = this.excelWorkbook.createCellStyle();
        this.lighterHeaderCellCS.setFont(headerFont);
        this.lighterHeaderCellCS.setAlignment(HorizontalAlignment.CENTER);
        this.lighterHeaderCellCS.setFillForegroundColor(IndexedColors.GREY_25_PERCENT.getIndex());
        this.lighterHeaderCellCS.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        this.setCellBordersColor(this.lighterHeaderCellCS);
        CellStyle darkerHeaderCellCS = this.excelWorkbook.createCellStyle();
        darkerHeaderCellCS.setFont(headerFont);
        darkerHeaderCellCS.setAlignment(HorizontalAlignment.CENTER);
        darkerHeaderCellCS.setFillForegroundColor(IndexedColors.GREY_40_PERCENT.getIndex());
        darkerHeaderCellCS.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        this.setCellBordersColor(darkerHeaderCellCS);
    }

    private void setCellBordersColor(CellStyle style) {
        style.setBorderBottom(BorderStyle.THIN);
        style.setBottomBorderColor(IndexedColors.GREY_80_PERCENT.getIndex());
        style.setBorderTop(BorderStyle.THIN);
        style.setTopBorderColor(IndexedColors.GREY_80_PERCENT.getIndex());
        style.setBorderLeft(BorderStyle.THIN);
        style.setLeftBorderColor(IndexedColors.GREY_80_PERCENT.getIndex());
        style.setBorderRight(BorderStyle.THIN);
        style.setRightBorderColor(IndexedColors.GREY_80_PERCENT.getIndex());
    }

    public byte[] build() throws SaikuServiceException {
        Long start = new Date().getTime();
        int startRow = this.initExcelSheet();
        Long init = new Date().getTime();
        int lastHeaderRow = this.buildExcelTableHeader(startRow);
        Long header = new Date().getTime();
        this.addExcelTableRows(lastHeaderRow);
        this.addTotalsSummary(lastHeaderRow);
        Long content = new Date().getTime();
        this.finalizeExcelSheet(startRow);
        Long finalizing = new Date().getTime();
        log.debug("Init: " + (init - start) + "ms header: " + (header - init) + "ms content: " + (content - header) + "ms finalizing: " + (finalizing - content) + "ms ");
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        try {
            this.excelWorkbook.write((OutputStream)bout);
        }
        catch (IOException e) {
            throw new SaikuServiceException("Error creating excel export for query", e);
        }
        return bout.toByteArray();
    }

    private void checkRowLimit(int rowIndex) {
        if (rowIndex + 1 > this.maxRows) {
            log.warn("Excel sheet is truncated, only outputting " + this.maxRows + " rows of " + (rowIndex + 1));
        }
    }

    private void addTotalsSummary(int startingRow) {
        TotalAggregator agg;
        int rowIndex = startingRow + this.rowsetBody.length + 2;
        this.checkRowLimit(rowIndex);
        if (this.colScanTotals.keySet().size() > 0) {
            Row row = this.workbookSheet.createRow(rowIndex);
            Object cell = row.createCell(0);
            cell.setCellStyle(this.lighterHeaderCellCS);
            cell.setCellValue("Columns");
            for (Integer colKey : this.colScanTotals.keySet()) {
                TotalAggregator[][] colAggregator = this.colScanTotals.get(colKey);
                if (colAggregator == null) continue;
                for (int x = 0; x < colAggregator.length; ++x) {
                    agg = colAggregator[x][0];
                    if (agg instanceof BlankAggregator) continue;
                    this.checkRowLimit(++rowIndex);
                    Measure measure = this.table.getSelectedMeasures()[x];
                    row = this.workbookSheet.createRow(rowIndex);
                    cell = row.createCell(0);
                    cell.setCellStyle(this.lighterHeaderCellCS);
                    cell.setCellValue(measure.getCaption() + ":");
                    cell = row.createCell(1);
                    cell.setCellStyle(this.basicCS);
                    cell.setCellValue(agg.getClass().getSimpleName().substring(0, 3));
                }
            }
        }
        if (this.rowScanTotals.keySet().size() > 0) {
            int qtdNonBlank = 0;
            for (Integer rowKey : this.rowScanTotals.keySet()) {
                TotalAggregator[][] rowAggregator = this.rowScanTotals.get(rowKey);
                for (int x = 0; x < rowAggregator.length; ++x) {
                    for (int y = 0; y < this.table.getSelectedMeasures().length; ++y) {
                        agg = rowAggregator[x][y];
                        if (agg instanceof BlankAggregator) continue;
                        ++qtdNonBlank;
                    }
                }
            }
            if (qtdNonBlank == 0) {
                return;
            }
            this.checkRowLimit(++rowIndex);
            Row row = this.workbookSheet.createRow(rowIndex);
            Cell cell = row.createCell(0);
            cell.setCellStyle(this.lighterHeaderCellCS);
            cell.setCellValue("Rows");
            for (Integer rowKey : this.rowScanTotals.keySet()) {
                TotalAggregator[][] rowAggregator = this.rowScanTotals.get(rowKey);
                if (rowAggregator == null) continue;
                for (int x = 0; x < rowAggregator.length; ++x) {
                    for (int y = 0; y < this.table.getSelectedMeasures().length; ++y) {
                        TotalAggregator agg2 = rowAggregator[x][y];
                        if (agg2 instanceof BlankAggregator) continue;
                        this.checkRowLimit(++rowIndex);
                        Measure measure = this.table.getSelectedMeasures()[y];
                        row = this.workbookSheet.createRow(rowIndex);
                        cell = row.createCell(0);
                        cell.setCellStyle(this.lighterHeaderCellCS);
                        cell.setCellValue(measure.getCaption() + ":");
                        cell = row.createCell(1);
                        cell.setCellStyle(this.basicCS);
                        cell.setCellValue(agg2.getClass().getSimpleName().substring(0, 3));
                    }
                }
            }
        }
    }

    private void finalizeExcelSheet(int startRow) {
        boolean autoSize;
        boolean bl = autoSize = this.rowsetBody != null && this.rowsetBody.length > 0 && this.rowsetBody.length < 10000 && this.rowsetHeader != null && this.rowsetHeader.length > 0 && this.rowsetHeader[0].length < 200;
        if (autoSize) {
            log.warn("Skipping auto-sizing columns, more than 10000 rows and/or 200 columns");
        }
        Long start = new Date().getTime();
        if (autoSize) {
            int maxColumnsSize = this.rowsetBody[0].length;
            if (!this.colScanTotals.isEmpty()) {
                maxColumnsSize = Collections.max(this.colScanTotals.keySet()) + 1;
            }
            for (int i = 0; i < this.maxColumns && i < maxColumnsSize; ++i) {
                this.workbookSheet.autoSizeColumn(i);
            }
        }
        Long end = new Date().getTime();
        log.debug("Autosizing: " + (end - start) + "ms");
        int headerWidth = this.rowsetHeader.length;
        this.workbookSheet.createFreezePane(0, startRow + headerWidth, 0, startRow + headerWidth);
    }

    private int initExcelSheet() {
        this.workbookSheet = StringUtils.isNotBlank((String)this.options.sheetName) ? this.excelWorkbook.createSheet(this.sheetName) : this.excelWorkbook.createSheet();
        this.initSummarySheet();
        return 0;
    }

    private void initSummarySheet() {
        int headerLength;
        Sheet summarySheet = this.excelWorkbook.createSheet("Summary page");
        int row = 1;
        Row sheetRow = summarySheet.createRow(row);
        Cell cell = sheetRow.createCell(0);
        String todayDate = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date());
        cell.setCellValue("Export date and time: " + todayDate);
        try {
            summarySheet.addMergedRegion(new CellRangeAddress(1, 1, 0, 2));
        }
        catch (Exception exception) {
            // empty catch block
        }
        sheetRow = summarySheet.createRow(row += 2);
        cell = sheetRow.createCell(0);
        cell.setCellValue("Dimension");
        cell = sheetRow.createCell(1);
        cell.setCellValue("Level");
        cell = sheetRow.createCell(2);
        cell.setCellValue("Filter Applied");
        ++row;
        if (this.queryFilters != null) {
            for (ThinHierarchy item : this.queryFilters) {
                for (ThinLevel s : item.getLevels().values()) {
                    for (ThinMember i : s.getSelection().getMembers()) {
                        sheetRow = summarySheet.createRow((int)((short)row));
                        cell = sheetRow.createCell(0);
                        cell.setCellValue(item.getCaption());
                        cell = sheetRow.createCell(1);
                        cell.setCellValue(s.getCaption());
                        cell = sheetRow.createCell(2);
                        cell.setCellValue(i.getCaption());
                        ++row;
                    }
                }
            }
        }
        row += 2;
        int rowLength = this.rowsetBody != null ? this.rowsetBody.length : 0;
        int columnCount = this.rowsetHeader != null && this.rowsetHeader.length > 0 ? this.rowsetHeader[0].length : 0;
        int n = headerLength = this.rowsetHeader != null ? this.rowsetHeader.length : 0;
        if (columnCount > this.maxColumns) {
            sheetRow = summarySheet.createRow(row);
            cell = sheetRow.createCell(0);
            cell.setCellValue("Excel sheet is truncated, only contains " + this.maxColumns + " columns of " + columnCount);
            try {
                summarySheet.addMergedRegion(new CellRangeAddress(row, row, 0, 10));
            }
            catch (Exception s) {
                // empty catch block
            }
            ++row;
        }
        if (headerLength + rowLength > this.maxRows) {
            sheetRow = summarySheet.createRow(row);
            cell = sheetRow.createCell(0);
            cell.setCellValue("Excel sheet is truncated, only contains " + this.maxRows + " rows of " + (headerLength + rowLength));
            try {
                summarySheet.addMergedRegion(new CellRangeAddress(row, row, 0, 10));
            }
            catch (Exception s) {
                // empty catch block
            }
            ++row;
        }
        sheetRow = summarySheet.createRow(++row);
        cell = sheetRow.createCell(0);
        cell.setCellValue(SaikuProperties.webExportExcelPoweredBy);
        try {
            summarySheet.addMergedRegion(new CellRangeAddress(row, row, 0, 10));
        }
        catch (Exception s) {
            // empty catch block
        }
        for (int i = 0; i < 5; ++i) {
            summarySheet.autoSizeColumn(i);
        }
    }

    private void addExcelTableRows(int startingRow) {
        Row sheetRow = null;
        Cell cell = null;
        HashMap<Integer, String> tmpCellUniqueValueByColumn = new HashMap<Integer, String>();
        HashMap<Integer, Map<Integer, Boolean>> mergeRowsByColumn = new HashMap<Integer, Map<Integer, Boolean>>();
        if (startingRow + this.rowsetBody.length > this.maxRows) {
            log.warn("Excel sheet is truncated, only outputting " + this.maxRows + " rows of " + (this.rowsetBody.length + startingRow));
        }
        if (this.rowsetBody.length > 0 && this.rowsetBody[0].length > this.maxColumns) {
            log.warn("Excel sheet is truncated, only outputting " + this.maxColumns + " columns of " + this.rowsetBody[0].length);
        }
        int rowCount = startingRow;
        for (int x = 0; x + startingRow < this.maxRows && x < this.rowsetBody.length; ++x) {
            int excelRowIndex = x + startingRow;
            sheetRow = this.workbookSheet.createRow(excelRowIndex);
            int column = 0;
            for (int y = 0; y < this.maxColumns && y < this.rowsetBody[x].length; ++y) {
                cell = sheetRow.createCell(column);
                AbstractBaseCell baseCell = this.rowsetBody[x][y];
                this.findMergeCells(baseCell, excelRowIndex, y, mergeRowsByColumn, tmpCellUniqueValueByColumn);
                String value = baseCell.getFormattedValue();
                if (value == null && this.options.repeatValues) {
                    value = this.workbookSheet.getRow(sheetRow.getRowNum() - 1).getCell(column).getStringCellValue();
                }
                cell.setCellStyle(this.basicCS);
                cell.setCellValue(value);
                if (this.rowsetBody[x][y] instanceof DataCell) {
                    DataCell dataCell = (DataCell)this.rowsetBody[x][y];
                    String formatString = dataCell.getFormatString();
                    if (dataCell.getRawNumber() != null && formatString != null && !formatString.trim().isEmpty()) {
                        Number numberValue = dataCell.getRawNumber();
                        cell.setCellValue(numberValue.doubleValue());
                        this.applyCellFormatting(cell, dataCell);
                    }
                }
                column = this.setColTotalAggregationCell(this.colScanTotals, sheetRow, x, column, true, false);
                if (y != this.rowsetBody[x].length - 1) continue;
                this.setColTotalAggregationCell(this.colScanTotals, sheetRow, x, column - 1, true, x == 0);
            }
            startingRow = this.setRowTotalAggregationCell(this.rowScanTotals, startingRow, x, false);
            rowCount = startingRow + x;
        }
        this.setRowTotalAggregationCell(this.rowScanTotals, rowCount, 0, true);
        this.addMergedRegions(mergeRowsByColumn);
    }

    private void scanRowAndColumnAggregations(List<TotalNode>[] rowTotalsLists, Map<Integer, TotalAggregator[][]> rowScanTotals, List<TotalNode>[] colTotalsLists, Map<Integer, TotalAggregator[][]> colScanTotals) {
        if (rowTotalsLists != null) {
            for (List<TotalNode> totalNodes : rowTotalsLists) {
                this.scanAggregations(true, totalNodes, rowScanTotals);
            }
        }
        if (colTotalsLists != null) {
            for (List<TotalNode> totalNodes : colTotalsLists) {
                this.scanAggregations(false, totalNodes, colScanTotals);
            }
        }
    }

    private void scanAggregations(boolean row, List<TotalNode> totalNodes, Map<Integer, TotalAggregator[][]> scanSums) {
        if (totalNodes != null && !totalNodes.isEmpty()) {
            int index = row ? this.rowsetHeader.length - 2 : this.detectColumnStartIndex();
            for (TotalNode n : totalNodes) {
                TotalAggregator[][] tg = n.getTotalGroups();
                if (tg.length <= 0) continue;
                index = n.getSpan() > n.getWidth() ? (index += n.getSpan()) : (index += n.getWidth());
                scanSums.put(++index, tg);
            }
        }
    }

    private int setRowTotalAggregationCell(Map<Integer, TotalAggregator[][]> scanTotals, int startIndex, int subIndex, boolean grandTotal) {
        int row;
        TotalAggregator[][] aggregatorsTable;
        if (!scanTotals.isEmpty() && (aggregatorsTable = scanTotals.get(row = subIndex + startIndex)) != null) {
            Row sheetRow = this.workbookSheet.createRow(row + 1);
            int startColumnIndex = this.detectColumnStartIndex();
            if (grandTotal) {
                this.setGrandTotalLabel(sheetRow, startColumnIndex, false);
            }
            for (TotalAggregator[] aggregators : aggregatorsTable) {
                int column = startColumnIndex;
                for (TotalAggregator aggregator : aggregators) {
                    column = this.setColTotalAggregationCell(this.colScanTotals, null, -1, column, false, false);
                    Cell cell = sheetRow.createCell(column);
                    String value = aggregator.getFormattedValue();
                    cell.setCellValue(value);
                    cell.setCellStyle(this.totalsCS);
                }
            }
            ++startIndex;
        }
        return startIndex;
    }

    private int detectColumnStartIndex() {
        int index = 0;
        if (this.rowsetBody.length > 0) {
            for (AbstractBaseCell cell : this.rowsetBody[0]) {
                if (!(cell instanceof MemberCell)) continue;
                ++index;
            }
            --index;
        }
        return index;
    }

    private int setColTotalAggregationCell(Map<Integer, TotalAggregator[][]> scanTotals, Row sheetRow, int x, int column, boolean setValue, boolean grandTotal) {
        TotalAggregator[][] aggregatorsTable;
        if (!scanTotals.isEmpty() && (aggregatorsTable = scanTotals.get(++column)) != null && setValue) {
            if (grandTotal) {
                this.setGrandTotalLabel(sheetRow.getRowNum() - 1, column, true);
            }
            for (TotalAggregator[] aggregators : aggregatorsTable) {
                Cell cell = sheetRow.createCell(column);
                String value = aggregators[x].getFormattedValue();
                cell.setCellValue(value);
                cell.setCellStyle(this.totalsCS);
                ++column;
            }
        }
        return column;
    }

    private void setGrandTotalLabel(int x, int y, boolean header) {
        Row sheetRow = this.workbookSheet.getRow(x);
        if (sheetRow != null) {
            this.setGrandTotalLabel(sheetRow, y, header);
        }
    }

    private void setGrandTotalLabel(Row sheetRow, int y, boolean header) {
        Cell cell = sheetRow.createCell(y);
        String value = "Grand Total";
        if (header) {
            this.fillHeaderCell(sheetRow, value, y);
        } else {
            cell.setCellValue(value);
            cell.setCellStyle(this.basicCS);
        }
    }

    private void applyCellFormatting(Cell cell, DataCell dataCell) {
        String formatString = dataCell.getFormatString();
        CellStyle numberCSClone = this.excelWorkbook.createCellStyle();
        numberCSClone.cloneStyleFrom(this.numberCS);
        try {
            formatString = FormatUtil.getFormatString(formatString);
            DataFormat fmt = this.excelWorkbook.createDataFormat();
            short dataFormat = fmt.getFormat(formatString);
            numberCSClone.setDataFormat(dataFormat);
        }
        catch (Exception fmt) {
            // empty catch block
        }
        Map<String, String> properties = dataCell.getProperties();
        if (dataCell.getRawNumber() != null && properties.containsKey("style")) {
            String colorCode = properties.get("style");
            short colorCodeIndex = this.getColorFromCustomPalette(colorCode);
            if (colorCodeIndex != -1) {
                numberCSClone.setFillForegroundColor(colorCodeIndex);
                numberCSClone.setFillPattern(FillPatternType.SOLID_FOREGROUND);
            } else if (this.customColorsPalette == null) {
                try {
                    if (this.cssColorCodesProperties != null && this.cssColorCodesProperties.containsKey(colorCode)) {
                        colorCode = this.cssColorCodesProperties.getProperty(colorCode);
                    }
                    int redCode = Integer.parseInt(colorCode.substring(1, 3), 16);
                    int greenCode = Integer.parseInt(colorCode.substring(3, 5), 16);
                    int blueCode = Integer.parseInt(colorCode.substring(5, 7), 16);
                    numberCSClone.setFillPattern(FillPatternType.SOLID_FOREGROUND);
                    ((XSSFCellStyle)numberCSClone).setFillForegroundColor(new XSSFColor(new Color(redCode, greenCode, blueCode)));
                    ((XSSFCellStyle)numberCSClone).setFillBackgroundColor(new XSSFColor(new Color(redCode, greenCode, blueCode)));
                }
                catch (Exception exception) {}
            }
        } else {
            numberCSClone.setFillForegroundColor(this.numberCS.getFillForegroundColor());
            numberCSClone.setFillBackgroundColor(this.numberCS.getFillBackgroundColor());
        }
        cell.setCellStyle(numberCSClone);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private short getColorFromCustomPalette(String style) {
        short returnedColorIndex;
        block25: {
            returnedColorIndex = -1;
            InputStream is = null;
            if (this.colorCodesMap.containsKey(style)) {
                returnedColorIndex = this.colorCodesMap.get(style).shortValue();
            } else {
                try {
                    String colorCode;
                    if (this.cssColorCodesProperties == null && (is = this.getClass().getResourceAsStream(CSS_COLORS_CODE_PROPERTIES)) != null) {
                        this.cssColorCodesProperties = new Properties();
                        this.cssColorCodesProperties.load(is);
                    }
                    if ((colorCode = this.cssColorCodesProperties.getProperty(style)) == null) break block25;
                    try {
                        int redCode = Integer.parseInt(colorCode.substring(1, 3), 16);
                        int greenCode = Integer.parseInt(colorCode.substring(3, 5), 16);
                        int blueCode = Integer.parseInt(colorCode.substring(5, 7), 16);
                        if (this.customColorsPalette == null) {
                            short s = -1;
                            return s;
                        }
                        this.customColorsPalette.setColorAtIndex((short)((byte)this.nextAvailableColorCode), (byte)redCode, (byte)greenCode, (byte)blueCode);
                        returnedColorIndex = this.customColorsPalette.getColor(this.nextAvailableColorCode).getIndex();
                        this.colorCodesMap.put(style, Integer.valueOf(returnedColorIndex));
                    }
                    catch (Exception e) {
                        short s = -1;
                        try {
                            if (is != null) {
                                is.close();
                            }
                        }
                        catch (IOException e2) {
                            log.error("IO Exception", (Throwable)e2);
                        }
                        return s;
                    }
                    ++this.nextAvailableColorCode;
                }
                catch (IOException e) {
                    log.error("IO Exception", (Throwable)e);
                }
                finally {
                    try {
                        if (is != null) {
                            is.close();
                        }
                    }
                    catch (IOException e) {
                        log.error("IO Exception", (Throwable)e);
                    }
                }
            }
        }
        return returnedColorIndex;
    }

    private int buildExcelTableHeader(int startRow) {
        Row sheetRow = null;
        int x = 0;
        int y = 0;
        int startSameFromPos = 0;
        int mergedCellsWidth = 0;
        boolean isLastHeaderRow = false;
        boolean isLastColumn = false;
        String nextHeader = EMPTY_STRING;
        String currentHeader = EMPTY_STRING;
        ArrayList<ExcelMergedRegionItemConfig> mergedItemsConfig = new ArrayList<ExcelMergedRegionItemConfig>();
        for (x = 0; x < this.rowsetHeader.length; ++x) {
            sheetRow = this.workbookSheet.createRow(x + startRow);
            nextHeader = EMPTY_STRING;
            isLastColumn = false;
            startSameFromPos = 0;
            mergedCellsWidth = 0;
            if (x + 1 == this.rowsetHeader.length) {
                isLastHeaderRow = true;
            }
            int column = 0;
            for (y = 0; y < this.maxColumns && y < this.rowsetHeader[x].length; ++y) {
                int nextColumn;
                currentHeader = this.rowsetHeader[x][y].getFormattedValue();
                if (currentHeader != null) {
                    if (this.rowsetHeader[x].length == y + 1) {
                        isLastColumn = true;
                    } else {
                        nextHeader = this.rowsetHeader[x][y + 1].getFormattedValue();
                    }
                    this.manageColumnHeaderDisplay(sheetRow, x, column, currentHeader);
                    if (!isLastHeaderRow) {
                        if (nextHeader != null && !nextHeader.equals(currentHeader) || isLastColumn) {
                            this.manageCellsMerge(column, x + startRow, mergedCellsWidth + 1, startSameFromPos, mergedItemsConfig);
                            startSameFromPos = column + 1;
                            mergedCellsWidth = 0;
                        } else if (nextHeader != null && nextHeader.equals(currentHeader)) {
                            ++mergedCellsWidth;
                        }
                    }
                } else {
                    ++startSameFromPos;
                }
                if (column != (nextColumn = this.setColTotalAggregationCell(this.colScanTotals, sheetRow, x, column, false, false)) - 1) {
                    ++startSameFromPos;
                }
                column = nextColumn;
            }
            if (isLastHeaderRow) continue;
            this.manageCellsMerge(y - 1, x, mergedCellsWidth + 1, startSameFromPos, mergedItemsConfig);
        }
        if (this.topLeftCornerHeight > 0 && this.topLeftCornerWidth > 0 && (this.topLeftCornerHeight > 1 || this.topLeftCornerWidth > 1)) {
            try {
                this.workbookSheet.addMergedRegion(new CellRangeAddress(startRow, startRow + this.topLeftCornerHeight - 1, 0, this.topLeftCornerWidth - 1));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (mergedItemsConfig.size() > 0) {
            for (ExcelMergedRegionItemConfig item : mergedItemsConfig) {
                int lastCol = item.getStartX() + item.getWidth() - 1;
                lastCol = lastCol >= this.maxColumns ? this.maxColumns - 1 : lastCol;
                try {
                    this.workbookSheet.addMergedRegion(new CellRangeAddress(item.getStartY(), item.getStartY() + item.getHeight(), item.getStartX(), lastCol));
                }
                catch (Exception exception) {}
            }
        }
        return x + startRow;
    }

    private void manageColumnHeaderDisplay(Row sheetRow, int x, int y, String currentHeader) {
        if (this.topLeftCornerHeight > 0 && x >= this.topLeftCornerHeight) {
            this.fillHeaderCell(sheetRow, currentHeader, y);
        } else if (this.topLeftCornerHeight > 0 && x < this.topLeftCornerHeight && this.topLeftCornerWidth > 0 && y >= this.topLeftCornerWidth) {
            this.fillHeaderCell(sheetRow, currentHeader, y);
        } else if (this.topLeftCornerHeight == 0 && this.topLeftCornerWidth == 0) {
            this.fillHeaderCell(sheetRow, currentHeader, y);
        }
    }

    private void manageCellsMerge(int rowPos, int colPos, int width, int startSameFromPos, ArrayList<ExcelMergedRegionItemConfig> mergedItemsConfig) {
        ExcelMergedRegionItemConfig foundItem = null;
        boolean itemGetFromList = false;
        if (width == 1) {
            return;
        }
        for (ExcelMergedRegionItemConfig item : mergedItemsConfig) {
            if (item.getStartY() != colPos || item.getStartX() != rowPos) continue;
            foundItem = item;
            itemGetFromList = true;
        }
        if (foundItem == null) {
            foundItem = new ExcelMergedRegionItemConfig();
        }
        foundItem.setHeight(0);
        foundItem.setWidth(width);
        foundItem.setStartX(startSameFromPos);
        foundItem.setStartY(colPos);
        if (mergedItemsConfig.isEmpty() || !itemGetFromList) {
            mergedItemsConfig.add(foundItem);
        }
    }

    private void fillHeaderCell(Row sheetRow, String formattedValue, int y) {
        Cell cell = sheetRow.createCell(y);
        cell.setCellValue(formattedValue);
        cell.setCellStyle(this.lighterHeaderCellCS);
    }

    private int findTopLeftCornerWidth() {
        int width = 0;
        int x = 0;
        boolean exit = this.rowsetHeader.length < 1 || this.rowsetHeader[0][0].getRawValue() != null;
        String cellValue = null;
        for (x = 0; !exit && this.rowsetHeader[0].length > x; ++x) {
            cellValue = this.rowsetHeader[0][x].getRawValue();
            if (cellValue == null) {
                width = x + 1;
                continue;
            }
            exit = true;
        }
        return width;
    }

    private int findTopLeftCornerHeight() {
        return this.rowsetHeader.length > 0 ? this.rowsetHeader.length - 1 : 0;
    }

    private void addMergedRegions(Map<Integer, Map<Integer, Boolean>> mergeRowsByColumn) {
        if (mergeRowsByColumn != null) {
            for (Map.Entry<Integer, Map<Integer, Boolean>> e : mergeRowsByColumn.entrySet()) {
                int col = e.getKey();
                Map<Integer, Boolean> rows = e.getValue();
                if (rows == null) continue;
                int mergeCount = 1;
                for (Map.Entry<Integer, Boolean> rowEntry : rows.entrySet()) {
                    int row = rowEntry.getKey();
                    boolean current = rowEntry.getValue();
                    Boolean next = rows.get(rowEntry.getKey() + 1);
                    if (current) {
                        try {
                            if (next == null || !next.booleanValue()) {
                                this.workbookSheet.addMergedRegion(new CellRangeAddress(row - mergeCount, row, col, col));
                            }
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        ++mergeCount;
                        continue;
                    }
                    mergeCount = 1;
                }
            }
        }
    }

    private void findMergeCells(AbstractBaseCell baseCell, int excelRowIndex, int y, Map<Integer, Map<Integer, Boolean>> mergeRowsByColumn, Map<Integer, String> tmpCellUniqueValueByColumn) {
        if (baseCell instanceof MemberCell) {
            Boolean previewColumnCellmergeValue;
            boolean merge;
            MemberCell memberCell = (MemberCell)baseCell;
            Map<Integer, Boolean> rowMerge = mergeRowsByColumn.get(y);
            if (rowMerge == null) {
                rowMerge = new TreeMap<Integer, Boolean>();
                mergeRowsByColumn.put(y, rowMerge);
            }
            String previousValue = tmpCellUniqueValueByColumn.get(y);
            Map<Integer, Boolean> previousColumn = mergeRowsByColumn.get(y - 1);
            boolean bl = merge = previousValue != null && previousValue.equals(memberCell.getUniqueName());
            if (previousColumn != null && (previewColumnCellmergeValue = previousColumn.get(excelRowIndex)) != null && !previewColumnCellmergeValue.booleanValue() && merge) {
                merge = false;
            }
            rowMerge.put(excelRowIndex, merge);
            tmpCellUniqueValueByColumn.put(y, memberCell.getUniqueName());
        }
    }
}

