/*
 * Decompiled with CFR 0.152.
 */
package org.saiku.repository;

import com.his.jackson.databind.ObjectMapper;
import jakarta.servlet.http.HttpSession;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Scanner;
import javax.jcr.RepositoryException;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.saiku.database.dto.MondrianSchema;
import org.saiku.datasources.connection.RepositoryFile;
import org.saiku.repository.Acl2;
import org.saiku.repository.AclEntry;
import org.saiku.repository.AclMethod;
import org.saiku.repository.AclType;
import org.saiku.repository.DataSource;
import org.saiku.repository.IRepositoryManager;
import org.saiku.repository.IRepositoryObject;
import org.saiku.repository.RepositoryFileObject;
import org.saiku.repository.RepositoryFolderObject;
import org.saiku.repository.ScopedRepo;
import org.saiku.service.user.UserService;
import org.saiku.service.util.exception.SaikuServiceException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClassPathRepositoryManager
implements IRepositoryManager {
    private static final String ORBIS_WORKSPACE_DIR = "workspace";
    private static final Logger log = LoggerFactory.getLogger(ClassPathRepositoryManager.class);
    private static ClassPathRepositoryManager ref;
    private final String defaultRole;
    private final boolean workspaces;
    private UserService userService;
    private String append;
    private String session = null;
    private String sep = "/";
    private ScopedRepo sessionRegistry;

    private ClassPathRepositoryManager(String data, String defaultRole, ScopedRepo sessionRegistry, boolean workspaces) {
        log.info("Path is " + data);
        this.append = this.cleanse(data);
        log.info("Path is now" + data);
        this.defaultRole = defaultRole;
        this.sessionRegistry = sessionRegistry;
        this.workspaces = workspaces;
    }

    public static synchronized ClassPathRepositoryManager getClassPathRepositoryManager(String data, String defaultRole, ScopedRepo sessionRegistry, boolean workspaces) {
        if (ref == null) {
            ref = new ClassPathRepositoryManager(data, defaultRole, sessionRegistry, workspaces);
        }
        return ref;
    }

    public Object clone() throws CloneNotSupportedException {
        throw new CloneNotSupportedException();
    }

    @Override
    public void init() {
    }

    @Override
    public boolean start(UserService userService) throws RepositoryException {
        this.userService = userService;
        if (this.session == null) {
            File f = new File(this.append, "unknown");
            File f2 = new File(this.append, "etc");
            if (!f.exists()) {
                f.mkdir();
            }
            if (!f2.exists()) {
                f2.mkdir();
            }
            File n = this.createFolder(this.sep + "homes");
            HashMap<String, List<AclMethod>> m = new HashMap<String, List<AclMethod>>();
            ArrayList<AclMethod> l = new ArrayList<AclMethod>();
            l.add(AclMethod.READ);
            m.put(this.defaultRole, l);
            AclEntry e = new AclEntry("admin", AclType.SECURED, m, null);
            Acl2 acl2 = new Acl2(n);
            acl2.addEntry(n.getPath(), e);
            acl2.serialize(n);
            this.createFolder(this.sep + "datasources");
            m = new HashMap();
            l = new ArrayList();
            l.add(AclMethod.WRITE);
            l.add(AclMethod.READ);
            l.add(AclMethod.GRANT);
            m.put("ROLE_ADMIN", l);
            e = new AclEntry("admin", AclType.PUBLIC, m, null);
            acl2 = new Acl2(n);
            acl2.addEntry(n.getPath(), e);
            acl2.serialize(n);
            this.createFolder(this.sep + "etc");
            if (new File(this.append, "etc/license.lic").exists()) {
                try {
                    FileUtils.copyFile((File)new File(this.append, "etc/license.lic"), (File)this.createNode("/etc/license.lic"));
                }
                catch (IOException e1) {
                    log.debug("Failed to find license 1");
                    try {
                        FileUtils.copyFile((File)new File(this.append, "unknown/etc/license.lic"), (File)this.createNode("/etc/license.lic"));
                    }
                    catch (IOException e2) {
                        log.debug("failed to find any licenses. Giving up");
                    }
                }
            }
            this.createFolder(this.sep + "legacyreports");
            acl2 = new Acl2(n);
            acl2.addEntry(n.getPath(), e);
            acl2.serialize(n);
            this.createFolder(this.sep + "etc" + this.sep + "theme");
            acl2 = new Acl2(n);
            acl2.addEntry(n.getPath(), e);
            acl2.serialize(n);
            log.info("node added");
            this.session = "init";
        } else {
            File n = this.createFolder(this.sep + "homes");
            HashMap<String, List<AclMethod>> m = new HashMap<String, List<AclMethod>>();
            ArrayList<AclMethod> l = new ArrayList<AclMethod>();
            l.add(AclMethod.READ);
            m.put(this.defaultRole, l);
            AclEntry e = new AclEntry("admin", AclType.SECURED, m, null);
            Acl2 acl2 = new Acl2(n);
            acl2.addEntry(n.getPath(), e);
            acl2.serialize(n);
            this.createFolder(this.sep + "datasources");
            m = new HashMap();
            l = new ArrayList();
            l.add(AclMethod.WRITE);
            l.add(AclMethod.READ);
            l.add(AclMethod.GRANT);
            m.put("ROLE_ADMIN", l);
            e = new AclEntry("admin", AclType.PUBLIC, m, null);
            acl2 = new Acl2(n);
            acl2.addEntry(n.getPath(), e);
            acl2.serialize(n);
            this.createFolder(this.sep + "etc");
            this.createFolder(this.sep + "etc" + this.sep + "theme");
            acl2 = new Acl2(n);
            acl2.addEntry(n.getPath(), e);
            acl2.serialize(n);
        }
        return true;
    }

    @Override
    public void createUser(String u) throws RepositoryException {
        File node = this.createFolder(this.sep + "homes" + this.sep + u);
        AclEntry e = new AclEntry(u, AclType.PRIVATE, null, null);
        Acl2 acl2 = new Acl2(node);
        acl2.addEntry(node.getPath(), e);
        acl2.serialize(node);
    }

    @Override
    public Object getHomeFolders() throws RepositoryException {
        return this.getAllFoldersInCurrentDirectory(this.sep + "homes");
    }

    @Override
    public Object getHomeFolder(String path) throws RepositoryException {
        return this.getAllFoldersInCurrentDirectory("home:" + path);
    }

    @Override
    public Object getFolder(String user, String directory) throws RepositoryException {
        return this.getAllFoldersInCurrentDirectory(this.sep + "homes" + this.sep + "home:" + user + this.sep + directory);
    }

    private Object getFolderNode(String directory) throws RepositoryException {
        if (directory.startsWith(this.sep)) {
            directory = directory.substring(1, directory.length());
        }
        return this.getAllFoldersInCurrentDirectory(directory);
    }

    @Override
    public void shutdown() {
    }

    @Override
    public boolean createFolder(String username, String folder) throws RepositoryException {
        this.createFolder(folder);
        return true;
    }

    @Override
    public boolean deleteFolder(String folder) throws RepositoryException {
        if (folder.startsWith(this.sep)) {
            folder = folder.substring(1, folder.length());
        }
        this.delete(folder);
        return true;
    }

    @Override
    public void deleteRepository() throws RepositoryException {
    }

    @Override
    public boolean moveFolder(String user, String folder, String source, String target) throws RepositoryException {
        return false;
    }

    @Override
    public Object saveFile(Object file, String path, String user, String type, List<String> roles) throws RepositoryException {
        if (file == null) {
            String parent = path.contains(this.sep) ? path.substring(0, path.lastIndexOf(this.sep)) : this.sep;
            File node = this.getFolder(parent);
            Acl2 acl2 = new Acl2(node);
            acl2.setAdminRoles(this.userService.getAdminRoles());
            if (acl2.canWrite(node, user, roles)) {
                throw new SaikuServiceException("Can't write to file or folder");
            }
            int pos = path.lastIndexOf(this.sep);
            String filename = "." + this.sep + path.substring(pos + 1, path.length());
            this.createFolder(filename);
            return null;
        }
        int pos = path.lastIndexOf(this.sep);
        String filename = "." + this.sep + path.substring(pos + 1, path.length());
        File n = this.getFolder(path.substring(0, pos));
        Acl2 acl2 = new Acl2(n);
        acl2.setAdminRoles(this.userService.getAdminRoles());
        File check = this.getNode(filename);
        if (check.exists()) {
            check.delete();
        }
        File resNode = this.createNode(path);
        try {
            if (resNode.getParentFile() != null && !resNode.getParentFile().exists()) {
                resNode.getParentFile().mkdirs();
            }
            FileWriter fileWriter = new FileWriter(resNode);
            fileWriter.write((String)file);
            fileWriter.flush();
            fileWriter.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return resNode;
    }

    @Override
    public void removeFile(String path, String user, List<String> roles) throws RepositoryException {
        File node = this.getFolder(path);
        Acl2 acl2 = new Acl2(node);
        acl2.setAdminRoles(this.userService.getAdminRoles());
        if (!acl2.canRead(node, user, roles)) {
            throw new RepositoryException();
        }
        this.getNode(path).delete();
    }

    @Override
    public void moveFile(String source, String target, String user, List<String> roles) throws RepositoryException {
    }

    @Override
    public Object saveInternalFile(Object file, String path, String type) throws RepositoryException {
        File check;
        File f = null;
        if (file == null) {
            int pos = path.lastIndexOf(this.sep);
            String filename = "." + this.sep + path.substring(pos + 1, path.length());
            this.createFolder(filename);
            return null;
        }
        String filename = path;
        if (filename.equals("/etc/license.lic")) {
            check = new File(this.append + filename);
            if (check.exists()) {
                check.delete();
            }
            f = new File(this.append + filename);
        } else {
            check = this.getNode(filename);
            if (check.exists()) {
                check.delete();
            }
            f = this.createNode(filename);
        }
        try {
            FileWriter fileWriter = new FileWriter(f);
            fileWriter.write((String)file);
            fileWriter.flush();
            fileWriter.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return f;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Object saveBinaryInternalFile(InputStream file, String path, String type) throws RepositoryException {
        if (file == null) {
            String parent = path.substring(0, path.lastIndexOf(this.sep));
            int pos = path.lastIndexOf(this.sep);
            String filename = "." + this.sep + path.substring(pos + 1, path.length());
            return this.createNode(filename);
        }
        int pos = path.lastIndexOf(this.sep);
        String filename = "." + this.sep + path.substring(pos + 1, path.length());
        log.debug("Saving:" + filename);
        File check = this.getNode(filename);
        if (check.exists()) {
            check.delete();
        }
        File resNode = this.createNode(filename);
        FileOutputStream outputStream = null;
        try {
            outputStream = new FileOutputStream(new File(filename));
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        byte[] bytes = new byte[1024];
        try {
            int read;
            while ((read = file.read(bytes)) != -1) {
                try {
                    if (outputStream == null) continue;
                    outputStream.write(bytes, 0, read);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            return resNode;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return resNode;
    }

    @Override
    public String getFile(String s, String username, List<String> roles) throws RepositoryException {
        File node = this.getFolder(s);
        Acl2 acl2 = new Acl2(node);
        acl2.setAdminRoles(this.userService.getAdminRoles());
        if (!acl2.canRead(node, username, roles)) {
            throw new RepositoryException();
        }
        byte[] encoded = new byte[]{};
        try {
            encoded = Paths.get(s, new String[0]).isAbsolute() && s.startsWith(this.getDatadir()) ? Files.readAllBytes(Paths.get(s, new String[0])) : Files.readAllBytes(Paths.get(this.getDatadir() + this.sep + s, new String[0]));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        try {
            return new String(encoded, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public String getInternalFile(String s) throws RepositoryException {
        byte[] encoded;
        block9: {
            encoded = new byte[]{};
            if (!s.equals("/etc/license.lic")) {
                try {
                    if (Paths.get(s, new String[0]).isAbsolute() && s.startsWith(this.getDatadir())) {
                        encoded = Files.readAllBytes(Paths.get(s, new String[0]));
                        break block9;
                    }
                    encoded = Files.readAllBytes(Paths.get(this.getDatadir() + s, new String[0]));
                }
                catch (IOException e) {
                    log.debug("Missing file", (Throwable)e);
                }
            } else {
                try {
                    encoded = Files.readAllBytes(Paths.get(this.append + s, new String[0]));
                }
                catch (IOException e) {
                    log.debug("Missing file", (Throwable)e);
                }
            }
        }
        try {
            return new String(encoded, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            log.debug("Couldn't conert file", (Throwable)e);
            return null;
        }
    }

    @Override
    public InputStream getBinaryInternalFile(String s) throws RepositoryException {
        Path path = null;
        path = Paths.get(s, new String[0]).isAbsolute() && s.startsWith(this.getDatadir()) ? Paths.get(s, new String[0]) : Paths.get(this.getDatadir() + s, new String[0]);
        try {
            byte[] f = Files.readAllBytes(path);
            return new ByteArrayInputStream(f);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public void removeInternalFile(String s) throws RepositoryException {
        this.getNode(s).delete();
    }

    @Override
    public List<MondrianSchema> getAllSchema() throws RepositoryException {
        String[] extensions = new String[]{"xml"};
        String datadir = this.getDatadir();
        File testFile = new File(datadir);
        if (!testFile.exists()) {
            testFile.mkdirs();
        }
        Collection files = FileUtils.listFiles((File)new File(datadir + "datasources"), (String[])extensions, (boolean)true);
        ArrayList<MondrianSchema> schema = new ArrayList<MondrianSchema>();
        for (File file : files) {
            try {
                Scanner scanner = new Scanner(file);
                while (scanner.hasNextLine()) {
                    String line = scanner.nextLine();
                    if (!line.contains("<Schema")) continue;
                    MondrianSchema ms = new MondrianSchema();
                    ms.setName(file.getName());
                    ms.setPath(file.getPath().substring(this.getDatadir().length() - 2, file.getPath().length()));
                    schema.add(ms);
                }
            }
            catch (FileNotFoundException fileNotFoundException) {}
        }
        return schema;
    }

    @Override
    public List<IRepositoryObject> getAllFiles(List<String> type, String username, List<String> roles) {
        try {
            return this.getRepoObjects(this.getFolder("/"), type, username, roles, false);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public List<IRepositoryObject> getAllFiles(List<String> type, String username, List<String> roles, String path) throws RepositoryException {
        File file = this.getNode(path);
        if (file.exists()) {
            try {
                return this.getRepoObjects(this.getFolder(path), type, username, roles, true);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    @Override
    public void deleteFile(String datasourcePath) {
        try {
            File n = this.getFolder(this.fixPath(datasourcePath));
            n.delete();
        }
        catch (RepositoryException e) {
            log.error("Could not remove file " + datasourcePath, (Throwable)e);
        }
    }

    private AclEntry getAclObj(String path) {
        File node = null;
        try {
            node = (File)this.getFolderNode(path);
        }
        catch (RepositoryException e) {
            log.error("Could not get file", (Throwable)e);
        }
        Acl2 acl2 = new Acl2(node);
        acl2.setAdminRoles(this.userService.getAdminRoles());
        AclEntry entry = acl2.getEntry(path);
        if (entry == null) {
            entry = new AclEntry();
        }
        return entry;
    }

    @Override
    public AclEntry getACL(String object, String username, List<String> roles) {
        File node = null;
        try {
            node = (File)this.getFolderNode(object);
        }
        catch (RepositoryException e) {
            log.error("Could not get file/folder", (Throwable)e);
        }
        Acl2 acl2 = new Acl2(node);
        acl2.setAdminRoles(this.userService.getAdminRoles());
        if (acl2.canGrant(node, username, roles)) {
            return this.getAclObj(object);
        }
        return null;
    }

    @Override
    public void setACL(String object, String acl, String username, List<String> roles) throws RepositoryException {
        ObjectMapper mapper = new ObjectMapper();
        log.debug("Set ACL to " + object + " : " + acl);
        AclEntry ae = null;
        try {
            ae = (AclEntry)mapper.readValue(acl, AclEntry.class);
        }
        catch (IOException e) {
            log.error("Could not read ACL blob", (Throwable)e);
        }
        File node = null;
        try {
            node = (File)this.getFolderNode(object);
        }
        catch (RepositoryException e) {
            log.error("Could not get file/folder " + object, (Throwable)e);
        }
        Acl2 acl2 = new Acl2(node);
        acl2.setAdminRoles(this.userService.getAdminRoles());
        if (acl2.canGrant(node, username, roles) && node != null) {
            acl2.addEntry(object, ae);
            acl2.serialize(node);
        }
    }

    @Override
    public List<MondrianSchema> getInternalFilesOfFileType(String type) throws RepositoryException {
        ArrayList<MondrianSchema> ds = new ArrayList<MondrianSchema>();
        String[] extensions = new String[]{"xml"};
        Collection files = FileUtils.listFiles((File)new File(this.getDatadir()), (String[])extensions, (boolean)true);
        for (File file : files) {
            String p = file.getPath();
            MondrianSchema m = new MondrianSchema();
            m.setName(file.getName());
            m.setPath(p);
            m.setType(type);
            ds.add(m);
        }
        return ds;
    }

    @Override
    public void createFileMixin(String type) throws RepositoryException {
    }

    @Override
    public List<DataSource> getAllDataSources() throws RepositoryException {
        ArrayList<DataSource> ds = new ArrayList<DataSource>();
        String[] extensions = new String[]{"sds"};
        Collection files = FileUtils.listFiles((File)new File(this.append), (String[])extensions, (boolean)true);
        for (File file : files) {
            JAXBContext jaxbContext = null;
            Unmarshaller jaxbMarshaller = null;
            try {
                jaxbContext = JAXBContext.newInstance((Class[])new Class[]{DataSource.class});
            }
            catch (JAXBException e) {
                log.error("Could not read XML", (Throwable)e);
            }
            try {
                jaxbMarshaller = jaxbContext != null ? jaxbContext.createUnmarshaller() : null;
            }
            catch (JAXBException e) {
                log.error("Could not read XML", (Throwable)e);
            }
            FileInputStream stream = null;
            try {
                stream = FileUtils.openInputStream((File)file);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            DataSource d = null;
            try {
                d = (DataSource)(jaxbMarshaller != null ? jaxbMarshaller.unmarshal((InputStream)stream) : null);
            }
            catch (JAXBException e) {
                log.error("Could not read XML", (Throwable)e);
            }
            if (d == null) continue;
            d.setPath(file.getPath());
            if (file.getParentFile().isDirectory()) {
                String p = file.getParent();
                p = p.replace("\\", "/");
                String[] s = p.split("/");
                log.debug("p split: " + p);
                String[] t = this.append.split("/");
                if (!this.workspaces && !s[s.length - 2].equals(t[t.length - 1])) {
                    d.setName(s[s.length - 2] + "_" + (d != null ? d.getName() : ""));
                }
            }
            ds.add(d);
        }
        return ds;
    }

    @Override
    public void saveDataSource(DataSource ds, String path, String user) throws RepositoryException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{DataSource.class});
            Marshaller jaxbMarshaller = jaxbContext.createMarshaller();
            jaxbMarshaller.setProperty("jaxb.formatted.output", (Object)true);
            jaxbMarshaller.marshal((Object)ds, (OutputStream)baos);
        }
        catch (JAXBException e) {
            log.error("Could not read XML", (Throwable)e);
        }
        int pos = path.lastIndexOf(this.sep);
        File f = this.createNode(path);
        try {
            FileWriter fileWriter = new FileWriter(f);
            fileWriter.write(baos.toString());
            fileWriter.flush();
            fileWriter.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public byte[] exportRepository() throws RepositoryException, IOException {
        return null;
    }

    @Override
    public void restoreRepository(byte[] xml) throws RepositoryException, IOException {
    }

    @Override
    public RepositoryFile getFile(String fileUrl) {
        fileUrl = this.fixPath(fileUrl);
        File n = null;
        try {
            n = this.getFolder(fileUrl);
        }
        catch (RepositoryException e) {
            e.printStackTrace();
        }
        return new RepositoryFile(n != null ? n.getName() : null, null, null, fileUrl);
    }

    public Object getRepository() {
        return null;
    }

    public void setRepository(Object repository) {
    }

    @Override
    public Object getRepositoryObject() {
        return null;
    }

    private List<IRepositoryObject> getRepoObjects(File root, List<String> fileType, String username, List<String> roles, boolean includeparent) throws Exception {
        ArrayList<IRepositoryObject> repoObjects = new ArrayList<IRepositoryObject>();
        ArrayList<File> objects = new ArrayList<File>();
        if (root.isDirectory()) {
            this.listf(root.getAbsolutePath(), objects);
        } else {
            objects = new ArrayList();
            objects.add(root);
        }
        Acl2 acl = new Acl2(root);
        acl.setAdminRoles(this.userService.getAdminRoles());
        for (File file : objects) {
            try {
                String datadir;
                if (file.isHidden()) continue;
                String filename = file.getName();
                String relativePath = file.getPath();
                if (relativePath.startsWith(datadir = this.getDatadir()) && datadir.length() >= 0) {
                    relativePath = relativePath.substring(datadir.length(), relativePath.length());
                }
                if (!acl.canRead(relativePath = relativePath.replace("\\", "/"), username, roles)) continue;
                List<AclMethod> acls = acl.getMethods(new File(relativePath), username, roles);
                if (file.isFile() && !fileType.isEmpty()) {
                    for (String ft : fileType) {
                        if (!filename.endsWith(ft)) continue;
                        String extension = FilenameUtils.getExtension((String)file.getPath());
                        repoObjects.add(new RepositoryFileObject(filename, "#" + relativePath, extension, relativePath, acls));
                    }
                }
                if (!file.isDirectory()) continue;
                repoObjects.add(new RepositoryFolderObject(filename, "#" + relativePath, relativePath, acls, this.getRepoObjects(file, fileType, username, roles, false)));
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        Collections.sort(repoObjects, new Comparator<IRepositoryObject>(){

            @Override
            public int compare(IRepositoryObject o1, IRepositoryObject o2) {
                if (o1.getType().equals((Object)IRepositoryObject.Type.FOLDER) && o2.getType().equals((Object)IRepositoryObject.Type.FILE)) {
                    return -1;
                }
                if (o1.getType().equals((Object)IRepositoryObject.Type.FILE) && o2.getType().equals((Object)IRepositoryObject.Type.FOLDER)) {
                    return 1;
                }
                return o1.getName().toLowerCase().compareTo(o2.getName().toLowerCase());
            }
        });
        return repoObjects;
    }

    private void listf(String directoryName, ArrayList<File> files) {
        if (directoryName == null || files == null) {
            return;
        }
        File directory = new File(this.fixPath(directoryName));
        File[] fList = directory.listFiles();
        if (fList != null && fList.length > 0) {
            Collections.addAll(files, fList);
        }
    }

    private File createFolder(String path) {
        String appended = this.fixPath(this.getDatadir() + path);
        boolean success = new File(appended).mkdirs();
        if (!success) {
            // empty if block
        }
        return new File(this.fixPath(path));
    }

    private void bootstrap(String ap) {
        log.debug("creating: " + ap + "/etc");
        new File(ap + "/etc").mkdirs();
        boolean found = false;
        if (new File(this.append + "/etc/license.lic").exists()) {
            try {
                FileUtils.copyFile((File)new File(this.append + "/etc/license.lic"), (File)this.createNode("/etc/license.lic"));
                found = true;
            }
            catch (IOException e1) {
                log.debug("Failed to find license 1");
            }
        }
        if (!found) {
            try {
                FileUtils.copyFile((File)new File(this.append + "/unknown/etc/license.lic"), (File)this.createNode("/etc/license.lic"));
            }
            catch (IOException e2) {
                log.debug("failed to find any licenses. Giving up");
            }
        }
    }

    private File[] getAllFoldersInCurrentDirectory(String path) {
        return null;
    }

    private void delete(String folder) {
        folder = this.fixPath(folder);
        File file = null;
        file = Paths.get(folder, new String[0]).isAbsolute() && folder.startsWith(this.getDatadir()) ? new File(folder) : new File(this.getDatadir() + folder);
        file.delete();
    }

    private File getFolder(String path) throws RepositoryException {
        return this.getNode(path);
    }

    private File getNode(String path) {
        File f = new File(path = this.fixPath(path));
        if (f.isAbsolute() && path.startsWith(this.getDatadir())) {
            return f;
        }
        return new File(this.getDatadir() + path);
    }

    private File createNode(String filename) {
        File nodeFile = new File(filename = this.fixPath(filename));
        if (nodeFile.isAbsolute() && filename.startsWith(this.getDatadir())) {
            log.debug("Creating file:" + filename);
        } else {
            log.debug("Creating file:" + this.getDatadir() + filename);
            nodeFile = new File(this.getDatadir(), filename);
        }
        return nodeFile;
    }

    private HttpSession getSession() {
        try {
            return this.sessionRegistry.getSession();
        }
        catch (Exception e) {
            log.debug("Error while fetching the HTTPSession", (Throwable)e);
            return null;
        }
    }

    private String getDatadir() {
        String basePath;
        HttpSession session = this.getSession();
        if (session != null) {
            try {
                if (this.workspaces && session.getAttribute(ORBIS_WORKSPACE_DIR) != null) {
                    String workspace = (String)session.getAttribute(ORBIS_WORKSPACE_DIR);
                    workspace = this.cleanse(workspace);
                    log.debug("Check " + this.append + "/" + workspace + "/ exists");
                    if (!new File(this.append + "/" + workspace + "/").exists()) {
                        this.bootstrap(this.append + "/" + workspace);
                        this.start(this.userService);
                    }
                    log.debug("Workspace directory set to:" + workspace);
                    return this.fixPath(this.append + "/" + workspace + "/");
                }
                log.debug("Workspace directory set to: unknown/");
                if (!new File(this.append + "/unknown/etc").exists()) {
                    this.bootstrap(this.append + "/unknown");
                    this.start(this.userService);
                }
                return this.fixPath(this.append + "/unknown/");
            }
            catch (Exception workspace) {
                // empty catch block
            }
        }
        if (!new File(this.fixPath((basePath = this.fixPath(this.append + "/unknown")) + "/etc")).exists()) {
            this.bootstrap(basePath);
            try {
                this.start(this.userService);
            }
            catch (RepositoryException e) {
                log.error("Error while starting the repository manager", (Throwable)e);
            }
        }
        return this.fixPath(this.append + "unknown/");
    }

    private String cleanse(String workspace) {
        if (!(workspace = workspace.replace("\\", "/")).endsWith("/")) {
            return workspace + "/";
        }
        return workspace + "/";
    }

    private String fixPath(String path) {
        if (path != null) {
            while (path.contains("//")) {
                path = path.replace("//", "/");
            }
        }
        return path;
    }
}

