/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hslf.examples;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.poi.hslf.usermodel.HSLFObjectData;
import org.apache.poi.hslf.usermodel.HSLFObjectShape;
import org.apache.poi.hslf.usermodel.HSLFPictureShape;
import org.apache.poi.hslf.usermodel.HSLFShape;
import org.apache.poi.hslf.usermodel.HSLFSlide;
import org.apache.poi.hslf.usermodel.HSLFSlideShow;
import org.apache.poi.hslf.usermodel.HSLFSoundData;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.hwpf.HWPFDocument;
import org.apache.poi.hwpf.usermodel.Range;

public final class DataExtraction {
    public static void main(String[] args) throws Exception {
        if (args.length == 0) {
            DataExtraction.usage();
            return;
        }
        try (FileInputStream is = new FileInputStream(args[0]);
             HSLFSlideShow ppt = new HSLFSlideShow((InputStream)is);){
            HSLFSoundData[] sound;
            for (HSLFSoundData aSound : sound = ppt.getSoundData()) {
                String type = aSound.getSoundType();
                String name = aSound.getSoundName();
                byte[] data = aSound.getData();
                try (FileOutputStream out = new FileOutputStream(name + type);){
                    out.write(data);
                }
            }
            int oleIdx = -1;
            int picIdx = -1;
            for (HSLFSlide slide : ppt.getSlides()) {
                for (HSLFShape shape : slide.getShapes()) {
                    FileOutputStream out;
                    Throwable throwable;
                    HSLFObjectData data;
                    if (shape instanceof HSLFObjectShape) {
                        ++oleIdx;
                        HSLFObjectShape ole = (HSLFObjectShape)shape;
                        data = ole.getObjectData();
                        String name = ole.getInstanceName();
                        if ("Worksheet".equals(name)) {
                            HSSFWorkbook hSSFWorkbook = new HSSFWorkbook(data.getInputStream());
                            continue;
                        }
                        if ("Document".equals(name)) {
                            HWPFDocument doc = new HWPFDocument(data.getInputStream());
                            throwable = null;
                            try {
                                Object p;
                                Range r = doc.getRange();
                                for (int k = 0; k < r.numParagraphs(); ++k) {
                                    p = r.getParagraph(k);
                                    System.out.println(p.text());
                                }
                                FileOutputStream out2 = new FileOutputStream(name + "-(" + oleIdx + ").doc");
                                p = null;
                                try {
                                    doc.write((OutputStream)out2);
                                    continue;
                                }
                                catch (Throwable throwable2) {
                                    p = throwable2;
                                    throw throwable2;
                                }
                                finally {
                                    if (out2 == null) continue;
                                    if (p != null) {
                                        try {
                                            out2.close();
                                        }
                                        catch (Throwable throwable3) {
                                            ((Throwable)p).addSuppressed(throwable3);
                                        }
                                        continue;
                                    }
                                    out2.close();
                                    continue;
                                }
                            }
                            catch (Throwable r) {
                                throwable = r;
                                throw r;
                            }
                            finally {
                                if (doc == null) continue;
                                if (throwable != null) {
                                    try {
                                        doc.close();
                                    }
                                    catch (Throwable r) {
                                        throwable.addSuppressed(r);
                                    }
                                    continue;
                                }
                                doc.close();
                                continue;
                            }
                        }
                        out = new FileOutputStream(ole.getProgId() + "-" + (oleIdx + 1) + ".dat");
                        throwable = null;
                        try {
                            InputStream dis = data.getInputStream();
                            Throwable throwable4 = null;
                            try {
                                int count;
                                byte[] chunk = new byte[2048];
                                while ((count = dis.read(chunk)) >= 0) {
                                    out.write(chunk, 0, count);
                                }
                                continue;
                            }
                            catch (Throwable throwable5) {
                                throwable4 = throwable5;
                                throw throwable5;
                            }
                            finally {
                                if (dis == null) continue;
                                if (throwable4 != null) {
                                    try {
                                        dis.close();
                                    }
                                    catch (Throwable throwable6) {
                                        throwable4.addSuppressed(throwable6);
                                    }
                                    continue;
                                }
                                dis.close();
                                continue;
                            }
                        }
                        catch (Throwable throwable7) {
                            throwable = throwable7;
                            throw throwable7;
                        }
                        finally {
                            if (out == null) continue;
                            if (throwable != null) {
                                try {
                                    out.close();
                                }
                                catch (Throwable throwable8) {
                                    throwable.addSuppressed(throwable8);
                                }
                                continue;
                            }
                            out.close();
                            continue;
                        }
                    }
                    if (!(shape instanceof HSLFPictureShape)) continue;
                    HSLFPictureShape p = (HSLFPictureShape)shape;
                    data = p.getPictureData();
                    String ext = data.getType().extension;
                    out = new FileOutputStream("pict-" + ++picIdx + ext);
                    throwable = null;
                    try {
                        out.write(data.getData());
                    }
                    catch (Throwable throwable9) {
                        throwable = throwable9;
                        throw throwable9;
                    }
                    finally {
                        if (out == null) continue;
                        if (throwable != null) {
                            try {
                                out.close();
                            }
                            catch (Throwable throwable10) {
                                throwable.addSuppressed(throwable10);
                            }
                            continue;
                        }
                        out.close();
                    }
                }
            }
        }
    }

    private static void usage() {
        System.out.println("Usage: DataExtraction  ppt");
    }
}

