/*
 * Decompiled with CFR 0.152.
 */
package de.statspez.pleditor.ui.structureditor.data;

import de.statspez.pleditor.generator.meta.MetaElement;
import de.statspez.pleditor.generator.meta.generated.MetaThemenbereich;
import de.statspez.pleditor.generator.runtime.FeldDeskriptorExt;
import de.statspez.pleditor.generator.runtime.FeldDeskriptorImpl;
import de.statspez.pleditor.generator.runtime.InvalidValue;
import de.statspez.pleditor.generator.runtime.Value;
import de.statspez.pleditor.generator.runtime.ValueFactory;
import de.statspez.pleditor.generator.runtime.plausi.SatzInterface;
import java.util.ArrayList;
import java.util.List;

public class Node {
    private List children = new ArrayList();
    private final FeldDeskriptorImpl feldDeskriptor;
    private final SatzInterface satz;
    private MetaElement element;
    private final Node parent;
    private final boolean virtual;
    private final boolean localVar;

    public Node(Node parent, MetaElement element, FeldDeskriptorImpl fieldDecriptor, boolean virtual, SatzInterface satz) {
        this(parent, element, fieldDecriptor, virtual, satz, false);
    }

    public Node(Node parent, MetaElement element, FeldDeskriptorImpl fieldDecriptor, boolean virtual, SatzInterface satz, boolean lokal) {
        this.parent = parent;
        this.element = element;
        this.feldDeskriptor = fieldDecriptor;
        this.virtual = virtual;
        this.satz = satz;
        if (this.parent != null) {
            parent.addChild(this);
        }
        this.localVar = lokal;
    }

    public boolean hasChild() {
        return this.children.size() > 0;
    }

    public int indexOfChild(Node paramObject) {
        return this.children.indexOf(paramObject);
    }

    public void setValue(String value) {
        if (this.satz != null && this.getFeldDeskriptor() != null) {
            try {
                if (value != null && value.length() > 0) {
                    this.feldDeskriptor.setValueWith(this.satz, ValueFactory.instance().valueFor(value), true);
                } else {
                    this.feldDeskriptor.setValueWith(this.satz, InvalidValue.instance());
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public String getValue() {
        String result;
        block5: {
            result = null;
            if (this.satz != null && this.feldDeskriptor != null) {
                try {
                    Value value = this.feldDeskriptor.getValueFrom(this.satz, true);
                    if (value != null && value.isValid()) {
                        result = value.asString();
                    }
                }
                catch (RuntimeException e) {
                    String message2;
                    e.printStackTrace();
                    String message = e.getMessage();
                    if (e.getCause() != null && (message2 = e.getCause().getMessage()) != null && message2.length() > 0) {
                        message = message2;
                    }
                    if (message == null) break block5;
                    result = "<" + message + ">";
                }
            }
        }
        return result;
    }

    public void addChild(Node child) {
        this.children.add(child);
    }

    public void removeChild(Node child) {
        this.children.remove(child);
    }

    public Node getChild(int index) {
        return (Node)this.children.get(index);
    }

    public int getChildCount() {
        return this.children.size();
    }

    public MetaElement getElement() {
        return this.element;
    }

    public void setElement(MetaElement element) {
        this.element = element;
    }

    public FeldDeskriptorImpl getFeldDeskriptor() {
        return this.feldDeskriptor;
    }

    public boolean isVirtual() {
        return this.virtual;
    }

    public String toString() {
        String text;
        if (this.element instanceof MetaThemenbereich) {
            text = ((MetaThemenbereich)this.element).getName();
        } else {
            String name = this.feldDeskriptor.getFeldDeskriptor().getFeldNameTB();
            int[] indices = this.feldDeskriptor.getIndizes();
            int[] dimension = this.feldDeskriptor.getFeldDeskriptor() instanceof FeldDeskriptorExt ? ((FeldDeskriptorExt)this.feldDeskriptor.getFeldDeskriptor()).getDimension() : null;
            StringBuffer buffer = new StringBuffer();
            buffer.append(name);
            if (indices != null && indices.length > 0) {
                for (int i = 0; i < indices.length; ++i) {
                    buffer.append('[');
                    buffer.append(indices[i] + 1);
                    buffer.append(']');
                }
            } else if (dimension != null && dimension.length == 1) {
                int i = dimension[0];
                if (i == -1) {
                    buffer.append("[N]");
                } else {
                    buffer.append("[");
                    buffer.append(i);
                    buffer.append("]");
                }
            }
            text = buffer.toString();
        }
        return text;
    }

    public boolean isLocalVar() {
        return this.localVar;
    }

    public boolean equals(Object obj) {
        return obj == this;
    }
}

