/*
 * Decompiled with CFR 0.152.
 */
package de.statspez.pleditor.ui.highligher;

public class ExpandingArray {
    public final int MIN_SIZE = 20;
    private Object[] items;
    private int size = 0;

    public ExpandingArray(int initSize) {
        this.setItems(new Object[Math.max(initSize, 20)]);
        this.setSize(initSize);
    }

    public void fill(int start, int end, Object item) {
        for (int i = start; i <= end; ++i) {
            this.getItems()[i] = item;
        }
    }

    public void shift(int shiftStart, int shiftLength) {
        int newCount = this.getSize() + shiftLength;
        Object[] newItems = newCount > this.getItems().length ? new Object[newCount << 1] : this.getItems();
        if (newItems != this.getItems()) {
            System.arraycopy(this.getItems(), 0, newItems, 0, shiftStart);
        }
        System.arraycopy(this.getItems(), shiftStart, newItems, shiftStart + shiftLength, this.getSize() - shiftStart);
        if (newItems == this.getItems() && this.getSize() > shiftStart) {
            this.fill(shiftStart, shiftStart + shiftLength - 1, null);
        }
        this.setItems(newItems);
        this.setSize(newCount);
    }

    public void unshift(int shiftStart, int shiftLength) {
        int newCount = this.getSize() - shiftLength;
        Object[] newItems = this.getItems();
        newItems = newCount < this.getItems().length >> 2 && this.getItems().length >> 1 > 20 ? new Object[this.getItems().length >> 1] : this.getItems();
        if (newItems != this.getItems()) {
            System.arraycopy(this.getItems(), 0, newItems, 0, shiftStart);
        }
        System.arraycopy(this.getItems(), shiftStart + shiftLength, newItems, shiftStart, newCount - shiftStart);
        this.setItems(newItems);
        this.setSize(newCount);
    }

    public void setItems(Object[] items) {
        this.items = items;
    }

    public Object[] getItems() {
        return this.items;
    }

    public void setSize(int size) {
        this.size = size;
    }

    public int getSize() {
        return this.size;
    }
}

