/*
 * Decompiled with CFR 0.152.
 */
package de.statspez.pleditor.ui.editor;

import de.statspez.pleditor.ui.settings.SettingsProvider;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;

public class EditableDocument
extends PlainDocument {
    private static final long serialVersionUID = -7710169639685736146L;
    private boolean writeProtected = false;
    private boolean insertSpacesForTabs = true;
    private String spacesStr = null;

    public void setWriteProtected(boolean writeProtected) {
        this.writeProtected = writeProtected;
    }

    public boolean isWriteProtected() {
        return this.writeProtected;
    }

    public void setInsertSpacesForTabs(boolean insertSpacesForTabs) {
        this.insertSpacesForTabs = insertSpacesForTabs;
    }

    public boolean isInsertSpacesForTabs() {
        return this.insertSpacesForTabs;
    }

    @Override
    public void insertString(int offset, String str, AttributeSet a) throws BadLocationException {
        if (!this.writeProtected) {
            if (this.insertSpacesForTabs) {
                str = this.replaceTabsForSpaces(str);
            }
            super.insertString(offset, str, a);
        }
    }

    @Override
    public void remove(int offset, int length) throws BadLocationException {
        if (!this.writeProtected) {
            super.remove(offset, length);
        }
    }

    private String replaceTabsForSpaces(String string) {
        String result = string;
        if (string != null) {
            StringBuffer buffer = null;
            String replacement = this.getSpaceStr();
            int len = string.length();
            for (int i = 0; i < len; ++i) {
                char check = string.charAt(i);
                if (check == '\t') {
                    if (buffer == null) {
                        buffer = new StringBuffer(string.length() + 12);
                        if (i > 0) {
                            for (int j = 0; j < i; ++j) {
                                buffer.append(string.charAt(j));
                            }
                        }
                    }
                    buffer.append(replacement);
                    continue;
                }
                if (buffer == null) continue;
                buffer.append(check);
            }
            if (buffer != null) {
                result = buffer.toString();
            }
        }
        return result;
    }

    private String getSpaceStr() {
        int indentSpaces = SettingsProvider.getInstance().getIndentSpaces();
        if (indentSpaces < 1) {
            indentSpaces = 3;
        }
        if (this.spacesStr == null || this.spacesStr.length() != indentSpaces) {
            StringBuffer buf = new StringBuffer(indentSpaces);
            for (int i = 0; i < indentSpaces; ++i) {
                buf.append(" ");
            }
            this.spacesStr = buf.toString();
        }
        return this.spacesStr;
    }
}

