/*
 * Decompiled with CFR 0.152.
 */
package de.statspez.pleditor.generator.xml;

import de.statspez.pleditor.generator.meta.MetaCustomMapping;
import de.statspez.pleditor.generator.meta.MetaCustomMappingElement;
import de.statspez.pleditor.generator.parser.Tags;
import de.statspez.pleditor.generator.xml.AbstractXmlGenerator;
import de.statspez.pleditor.generator.xml.MetaToXmlConverter;
import java.io.PrintStream;
import java.util.Iterator;

public class RawMappingXmlGenerator
extends AbstractXmlGenerator {
    public void printMapping(PrintStream out, MetaCustomMapping rawMap, String indentation) throws Exception {
        if (rawMap == null) {
            throw new Exception("Das Mapping muss angegeben werden.");
        }
        if (out == null) {
            throw new Exception("Der Ausgabe-Stream muss angegeben werden.");
        }
        if (indentation == null) {
            throw new Exception("Der Abstand muss angegeben werden.");
        }
        out.print(indentation + "<" + Tags.printTag("mapping"));
        this.printNameIdStateAttribute(out, rawMap);
        this.printAttribut(out, "type", "virtual");
        this.printAttribut(out, "source", rawMap.getThemenbereich() != null ? rawMap.getThemenbereich().getName() : "");
        this.printAttribut(out, "source-id", rawMap.getThemenbereich() != null ? rawMap.getThemenbereich().getId() : "");
        this.printAttribut(out, "target", rawMap.getRawDataSet().getName());
        this.printAttribut(out, "target-id", rawMap.getRawDataSet().getId());
        out.println(">");
        String ab1 = this.indentation(indentation, 1);
        String ab2 = this.indentation(indentation, 2);
        String ab3 = this.indentation(indentation, 3);
        this.printProperties(out, rawMap, ab1);
        this.printObjectContext(out, rawMap, ab1);
        Iterator it = rawMap.getMappingliste();
        while (it != null && it.hasNext()) {
            String code;
            MetaCustomMappingElement me = (MetaCustomMappingElement)it.next();
            out.print(ab1 + "<" + Tags.printTag("binding"));
            this.printAttribut(out, "id", me.getId());
            this.printAttribut(out, "type", MetaToXmlConverter.getMapingTyp(me.getMappingTyp()));
            out.println(">");
            String id = "";
            String name = "";
            if (me.getFeldTBListe() != null) {
                id = this.generateIds(me.getFeldTBListe());
                name = this.generateNamen(me.getFeldTBListe());
            }
            out.print(ab2 + "<" + Tags.printTag("sourceField"));
            this.printAttribut(out, "id", id);
            out.print(">");
            out.print(name);
            out.println("</" + Tags.printTag("sourceField") + ">");
            id = "";
            name = "";
            if (me.getFeldRaw() != null) {
                id = me.getFeldRaw().getId();
                name = me.getFeldRaw().getName();
            }
            out.print(ab2 + "<" + Tags.printTag("targetField"));
            this.printAttribut(out, "id", id);
            out.print(">");
            out.print(name);
            out.println("</" + Tags.printTag("targetField") + ">");
            if (me.getRawSet() != null) {
                id = me.getRawSet().getId();
                name = me.getRawSet().getName();
                out.print(ab2 + "<" + Tags.printTag("recordField"));
                this.printAttribut(out, "id", id);
                out.print(">");
                out.print(name);
                out.println("</" + Tags.printTag("recordField") + ">");
            }
            if ((code = me.getQuellRegel()) != null && code.trim().length() > 0) {
                out.println(ab2 + "<" + Tags.printTag("sourceRule") + ">");
                if (code != null && code.trim().length() > 0) {
                    this.printCDATA(out, Tags.printTag("code"), code, ab3);
                }
                out.println(ab2 + "</" + Tags.printTag("sourceRule") + ">");
            }
            if ((code = me.getZielRegel()) != null && code.trim().length() > 0) {
                out.println(ab2 + "<" + Tags.printTag("targetRule") + ">");
                if (code != null && code.trim().length() > 0) {
                    this.printCDATA(out, Tags.printTag("code"), code, ab1);
                }
                out.println(ab2 + "</" + Tags.printTag("targetRule") + ">");
            }
            out.println(ab1 + "</" + Tags.printTag("binding") + ">");
        }
        out.println(indentation + "</" + Tags.printTag("mapping") + ">");
    }
}

