/*
 * Decompiled with CFR 0.152.
 */
package de.statspez.pleditor.generator.test;

import de.statspez.pleditor.generator.runtime.PlausiDescriptor;
import de.statspez.pleditor.generator.runtime.PlausiDescriptorExt;
import de.statspez.pleditor.generator.runtime.PlausiDescriptorSerializer;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import junit.framework.TestCase;

public class PlausiDescriptorTest
extends TestCase {
    private PlausiDescriptorSerializer serializer;

    public void testSerialize() throws Exception {
        PlausiDescriptorExt descriptor = new PlausiDescriptorExt();
        descriptor.setName("Test");
        descriptor.addFlow(new PlausiDescriptor.FlowInfo("AlleTests", new Class[]{Double.class, String.class}));
        descriptor.addFlow(new PlausiDescriptor.FlowInfo("Standard", new Class[]{Double.class, String.class}));
        descriptor.setCodeFor("x.y", "WENN WAHR DANN FEHLER ENDE");
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        this.serializer.serialize(descriptor, out);
        out.close();
        ByteArrayInputStream in = new ByteArrayInputStream(out.toByteArray());
        descriptor = this.serializer.deserialize(in);
        in.close();
        PlausiDescriptorTest.assertNotNull((Object)descriptor.flow("AlleTests"));
        PlausiDescriptorTest.assertNotNull((Object)descriptor.flow("Standard"));
        PlausiDescriptorTest.assertEquals((String)"WENN WAHR DANN FEHLER ENDE", (String)descriptor.getCode("x.y").trim());
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.serializer = new PlausiDescriptorSerializer();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        this.serializer = null;
    }
}

