/*
 * Decompiled with CFR 0.152.
 */
package de.statspez.pleditor.generator.runtime.test;

import de.statspez.pleditor.generator.meta.MetaCustomPlausibilisierung;
import de.statspez.pleditor.generator.parser.IntermediateLanguageParser;
import de.statspez.pleditor.generator.runtime.test.PlausiTest;
import de.statspez.pleditor.generator.runtime.test.PlausiTestCase;
import de.statspez.pleditor.generator.runtime.test.PlausiTestResult;
import java.io.FileReader;
import java.util.Iterator;

public class PlausiTestInterpreter {
    public PlausiTestResult execute(MetaCustomPlausibilisierung plausi, PlausiTest test) {
        PlausiTestResult result = new PlausiTestResult(test);
        long currentMillis = System.currentTimeMillis();
        Iterator iter = test.getTestCases();
        while (iter.hasNext()) {
            ((PlausiTestCase)iter.next()).interprete(plausi, result);
        }
        result.setDuration(System.currentTimeMillis() - currentMillis);
        return result;
    }

    public PlausiTestResult execute(MetaCustomPlausibilisierung plausi, PlausiTest test, PlausiTestCase testCase) {
        PlausiTestResult result = new PlausiTestResult(test);
        long currentMillis = System.currentTimeMillis();
        testCase.interprete(plausi, result);
        result.setDuration(System.currentTimeMillis() - currentMillis);
        return result;
    }

    public static void main(String[] args) {
        int exitCode;
        block15: {
            String plausiName = null;
            String testFileName = null;
            String testCaseName = null;
            if (args != null && args.length > 0) {
                for (int i = 0; i < args.length - 1; ++i) {
                    if (args[i].equalsIgnoreCase("-n")) {
                        plausiName = args[++i];
                        continue;
                    }
                    if (args[i].equalsIgnoreCase("-t")) {
                        testFileName = args[++i];
                        continue;
                    }
                    if (!args[i].equalsIgnoreCase("-c")) continue;
                    testCaseName = args[++i];
                }
            }
            if (plausiName != null && plausiName.length() > 0 && testFileName != null && testFileName.length() > 0) {
                MetaCustomPlausibilisierung plausi = null;
                try {
                    plausi = PlausiTestInterpreter.parsePlausi(plausiName);
                }
                catch (Exception e) {
                    System.err.println("Die Plausi <" + plausiName + "> konnte nicht geparst werden.");
                    e.printStackTrace();
                }
                if (plausi != null) {
                    try {
                        PlausiTest test = new PlausiTest(testFileName);
                        if (testCaseName != null && testCaseName.length() > 0) {
                            PlausiTestCase testCase = test.getTestCase(testCaseName);
                            if (testCase != null) {
                                System.out.print(new PlausiTestInterpreter().execute(plausi, test, testCase));
                                exitCode = 0;
                            } else {
                                System.err.println("Der Testfall <" + testCaseName + "> wurde im Plausi-Test <" + testFileName + "> nicht gefunden.");
                                exitCode = -1;
                            }
                            break block15;
                        }
                        System.out.print(new PlausiTestInterpreter().execute(plausi, test));
                        exitCode = 0;
                    }
                    catch (Exception e) {
                        System.err.println("Der Plausi-Test <" + testFileName + "> konnte nicht geladen werden.");
                        e.printStackTrace();
                        exitCode = -1;
                    }
                } else {
                    exitCode = -1;
                }
            } else {
                System.err.println("Falsche oder fehlende Aufrufparameter.");
                System.err.println("Aufruf: PlausiTestExecutor -n <Name der PL> -t <Testdatei> [-c <Testfall>]");
                exitCode = -1;
            }
        }
        System.exit(exitCode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static MetaCustomPlausibilisierung parsePlausi(String file) throws Exception {
        MetaCustomPlausibilisierung plausi = null;
        try (FileReader in = null;){
            in = new FileReader(file);
            IntermediateLanguageParser parser = new IntermediateLanguageParser();
            plausi = (MetaCustomPlausibilisierung)parser.parse(in);
        }
        return plausi;
    }
}

