/*
 * Decompiled with CFR 0.152.
 */
package de.statspez.pleditor.generator.runtime.test;

import de.statspez.pleditor.generator.meta.MetaCustomPlausibilisierung;
import de.statspez.pleditor.generator.parser.IntermediateLanguageParser;
import de.statspez.pleditor.generator.runtime.test.PlausiTest;
import de.statspez.pleditor.generator.runtime.test.PlausiTestCase;
import de.statspez.pleditor.generator.runtime.test.PlausiTestResult;
import java.io.File;
import java.io.FileReader;
import java.util.Iterator;

public class JavaScriptPlausiTestPerformer {
    public PlausiTestResult execute(MetaCustomPlausibilisierung plausi, File javaScriptPlausiFile, PlausiTest test) {
        PlausiTestResult result = new PlausiTestResult(test);
        long currentMillis = System.currentTimeMillis();
        Iterator iter = test.getTestCases();
        while (iter.hasNext()) {
            PlausiTestCase testCase = (PlausiTestCase)iter.next();
            if (!testCase.inContext("JavaScript")) continue;
            testCase.performJavaScript(plausi, javaScriptPlausiFile, result);
        }
        result.setDuration(System.currentTimeMillis() - currentMillis);
        return result;
    }

    public PlausiTestResult execute(MetaCustomPlausibilisierung plausi, File javaScriptPlausiFile, PlausiTest test, PlausiTestCase testCase) {
        PlausiTestResult result = new PlausiTestResult(test);
        long currentMillis = System.currentTimeMillis();
        testCase.performJavaScript(plausi, javaScriptPlausiFile, result);
        result.setDuration(System.currentTimeMillis() - currentMillis);
        return result;
    }

    public static void main(String[] args) {
        int exitCode;
        block18: {
            String plausiName = null;
            String javaScriptPlausiFileName = null;
            String plausiTestFileName = null;
            String plausiTestCaseName = null;
            if (args != null && args.length > 0) {
                for (int i = 0; i < args.length - 1; ++i) {
                    if (args[i].equalsIgnoreCase("-n")) {
                        plausiName = args[++i];
                        continue;
                    }
                    if (args[i].equalsIgnoreCase("-f")) {
                        javaScriptPlausiFileName = args[++i];
                        continue;
                    }
                    if (args[i].equalsIgnoreCase("-t")) {
                        plausiTestFileName = args[++i];
                        continue;
                    }
                    if (!args[i].equalsIgnoreCase("-c")) continue;
                    plausiTestCaseName = args[++i];
                }
            }
            if (plausiName != null && plausiName.length() > 0 && javaScriptPlausiFileName != null && javaScriptPlausiFileName.length() > 0 && plausiTestFileName != null && plausiTestFileName.length() > 0) {
                MetaCustomPlausibilisierung plausi = null;
                try {
                    plausi = JavaScriptPlausiTestPerformer.parsePlausi(plausiName);
                }
                catch (Exception e) {
                    System.err.println("Die Plausi <" + plausiName + "> konnte nicht geparst werden.");
                    e.printStackTrace();
                }
                if (plausi != null) {
                    File javaScriptPlausiFile = new File(javaScriptPlausiFileName);
                    if (javaScriptPlausiFile.isFile()) {
                        try {
                            PlausiTest test = new PlausiTest(plausiTestFileName);
                            if (plausiTestCaseName != null && plausiTestCaseName.length() > 0) {
                                PlausiTestCase testCase = test.getTestCase(plausiTestCaseName);
                                if (testCase != null) {
                                    System.out.print(new JavaScriptPlausiTestPerformer().execute(plausi, javaScriptPlausiFile, test, testCase));
                                    exitCode = 0;
                                } else {
                                    System.err.println("Der Testfall <" + plausiTestCaseName + "> wurde im Plausi-Test <" + plausiTestFileName + "> nicht gefunden.");
                                    exitCode = -1;
                                }
                                break block18;
                            }
                            System.out.print(new JavaScriptPlausiTestPerformer().execute(plausi, javaScriptPlausiFile, test));
                            exitCode = 0;
                        }
                        catch (Exception e) {
                            System.err.println("Der Plausi-Test <" + plausiTestFileName + "> konnte nicht geladen werden.");
                            e.printStackTrace();
                            exitCode = -1;
                        }
                    } else {
                        System.err.println("Die JavaScript-Plausi-Datei <" + javaScriptPlausiFileName + "> existiert nicht oder ist ung\u00fcltig.");
                        exitCode = -1;
                    }
                } else {
                    exitCode = -1;
                }
            } else {
                System.err.println("Falsche oder fehlende Aufrufparameter.");
                System.err.println("Aufruf: PlausiTestExecutor -f <Name der JavaScript-Plausi-Datei> -t <Testdatei> [-c <Testfall>]");
                exitCode = -1;
            }
        }
        System.exit(exitCode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static MetaCustomPlausibilisierung parsePlausi(String file) throws Exception {
        MetaCustomPlausibilisierung plausi = null;
        try (FileReader in = null;){
            in = new FileReader(file);
            IntermediateLanguageParser parser = new IntermediateLanguageParser();
            plausi = (MetaCustomPlausibilisierung)parser.parse(in);
        }
        return plausi;
    }
}

