/*
 * Decompiled with CFR 0.152.
 */
package de.statspez.pleditor.generator.runtime.test;

import de.statspez.pleditor.generator.codegen.java.StringHelper;
import de.statspez.pleditor.generator.interpreter.InterpreterContext;
import de.statspez.pleditor.generator.interpreter.PlausiClassificationFactory;
import de.statspez.pleditor.generator.interpreter.ProgramDescriptor;
import de.statspez.pleditor.generator.interpreter.ProgramInterpreter;
import de.statspez.pleditor.generator.interpreter.SimpleDataset;
import de.statspez.pleditor.generator.interpreter.TBFieldDescriptorFactory;
import de.statspez.pleditor.generator.meta.MetaCustomPlausibilisierung;
import de.statspez.pleditor.generator.meta.generated.MetaMerkmal;
import de.statspez.pleditor.generator.runtime.FeldDeskriptorImpl;
import de.statspez.pleditor.generator.runtime.InvalidValue;
import de.statspez.pleditor.generator.runtime.ValueFactory;
import de.statspez.pleditor.generator.runtime.plausi.PlausiFehler;
import de.statspez.pleditor.generator.runtime.plausi.PlausiInterface;
import de.statspez.pleditor.generator.runtime.plausi.PlausiKontext;
import de.statspez.pleditor.generator.runtime.test.FieldValues;
import de.statspez.pleditor.generator.runtime.test.MaterialValues;
import de.statspez.pleditor.generator.runtime.test.PlausiTestCase;
import de.statspez.pleditor.generator.runtime.test.PlausiTestCaseResult;
import de.statspez.pleditor.generator.runtime.test.PlausiTestResult;
import de.statspez.pleditor.generator.runtime.test.TestFailure;
import de.statspez.pleditor.generator.runtime.test.TestMaterialAccess;
import de.statspez.pleditor.generator.util.PlGeneratorUtil;
import java.io.File;
import java.io.FileReader;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;

public class FieldTestCase
extends PlausiTestCase {
    private String field = null;
    private List inputValues = new ArrayList();
    private Map materialValues = new HashMap();

    public String getField() {
        return this.field;
    }

    public void setField(String field) {
        this.field = field;
    }

    public void addInputValues(FieldValues inputValues) {
        this.inputValues.add(inputValues);
    }

    public Iterator getInputValues() {
        return this.inputValues.iterator();
    }

    public HashMap getInputValuesAsMap() {
        return this.convertListToMap(this.inputValues);
    }

    public void addMaterialValues(MaterialValues materialValues) {
        this.materialValues.put(materialValues.getMaterialName(), materialValues);
    }

    public Map getMaterialValues() {
        return this.materialValues;
    }

    private HashMap convertListToMap(List list) {
        HashMap<String, String> result = new HashMap<String, String>();
        for (FieldValues fieldValues : list) {
            Iterator fieldKeyIterator = fieldValues.getFields();
            while (fieldKeyIterator.hasNext()) {
                String fieldKey = (String)fieldKeyIterator.next();
                result.put(fieldKey, fieldValues.getValue(fieldKey));
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(PlausiInterface plausi, PlausiTestResult result) {
        PlausiTestCaseResult testCaseResult = new PlausiTestCaseResult(this);
        try {
            PlausiKontext context = new PlausiKontext();
            HashMap<String, String> values = new HashMap<String, String>();
            context.setReferenzDateien(new TestMaterialAccess(this.getMaterialValues()));
            Iterator iter = this.getInputValues();
            while (iter.hasNext()) {
                FieldValues fieldValues = (FieldValues)iter.next();
                Iterator fields = fieldValues.getFields();
                while (fields.hasNext()) {
                    String field = (String)fields.next();
                    String fieldValue = fieldValues.getValue(field);
                    if (fieldValue == null || fieldValue.length() <= 0) continue;
                    values.put(field, fieldValue);
                }
            }
            String field = this.getField();
            if (field.indexOf("[") > 0) {
                StringBuffer correctedField = new StringBuffer();
                String[] fieldHierarchy = field.split("\\.");
                for (int i = 0; i < fieldHierarchy.length; ++i) {
                    int indexOfBrace;
                    if (correctedField.length() > 0) {
                        correctedField.append('.');
                    }
                    if ((indexOfBrace = fieldHierarchy[i].indexOf(91)) > 0) {
                        correctedField.append(fieldHierarchy[i].substring(0, indexOfBrace));
                        String indexStr = fieldHierarchy[i].substring(fieldHierarchy[i].indexOf(91), fieldHierarchy[i].length());
                        int[] index = PlGeneratorUtil.parseIndex(indexStr, 1);
                        for (int j = 0; j < index.length; ++j) {
                            correctedField.append('[').append(index[j]).append(']');
                        }
                        continue;
                    }
                    correctedField.append(fieldHierarchy[i]);
                }
                field = correctedField.toString();
            }
            SimpleDataset dataset = new SimpleDataset(values);
            dataset.setIndicesPrefix("[");
            dataset.setIndicesSuffix("]");
            plausi.feldPlausi(field, dataset, context);
            PlausiFehler[] errors = new PlausiFehler[context.getAnzahlFehler()];
            for (int i = 0; i < context.getAnzahlFehler(); ++i) {
                errors[i] = context.getFehler(i);
            }
            testCaseResult.handlePlausiResult(errors, "Java");
        }
        catch (Exception ex) {
            testCaseResult.addFailure(new TestFailure(this.getName(), "Java", 5, ex));
        }
        finally {
            result.addTestCaseResult(testCaseResult);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void interprete(MetaCustomPlausibilisierung plausi, PlausiTestResult result) {
        PlausiTestCaseResult testCaseResult = new PlausiTestCaseResult(this);
        try {
            InterpreterContext context = new InterpreterContext();
            context.setClassificationFactory(new PlausiClassificationFactory(plausi));
            HashMap<String, String> values = new HashMap<String, String>();
            Iterator fieldValuesIterator = this.getInputValues();
            while (fieldValuesIterator.hasNext()) {
                FieldValues fieldValues = (FieldValues)fieldValuesIterator.next();
                Iterator fieldIterator = fieldValues.getFields();
                while (fieldIterator.hasNext()) {
                    String field = (String)fieldIterator.next();
                    String fieldValue = fieldValues.getValue(field);
                    if (fieldValue == null || fieldValue.length() <= 0) continue;
                    values.put(field, fieldValue);
                }
            }
            SimpleDataset dataset = new SimpleDataset(values);
            dataset.setIndicesPrefix("[");
            dataset.setIndicesSuffix("]");
            context.setSatz(dataset);
            FeldDeskriptorImpl refField = null;
            context.declareVariable("feld");
            String fieldValue = (String)values.get(this.getField());
            if (fieldValue != null && fieldValue.length() > 0) {
                context.setVariableValue("feld", ValueFactory.instance().valueFor(fieldValue));
            } else {
                context.setVariableValue("feld", InvalidValue.instance());
            }
            TBFieldDescriptorFactory fieldDescriptorFactory = new TBFieldDescriptorFactory(plausi);
            fieldDescriptorFactory.setIndexPrefix("[");
            fieldDescriptorFactory.setIndexSuffix("]");
            refField = fieldDescriptorFactory.getFieldDescriptor(this.getField());
            ProgramDescriptor programDescriptor = this.getProgramDescriptor(plausi);
            programDescriptor.setRefField(refField);
            ProgramInterpreter programInterpreter = new ProgramInterpreter();
            programInterpreter.execute(programDescriptor, null, context);
            testCaseResult.handlePlausiResult(context.getPlausiErrors(), "Interpreter");
        }
        catch (Exception ex) {
            testCaseResult.addFailure(new TestFailure(this.getName(), "Interpreter", 5, ex));
        }
        finally {
            result.addTestCaseResult(testCaseResult);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void performJavaScript(MetaCustomPlausibilisierung plausi, File javaScriptPlausiFile, PlausiTestResult result) {
        PlausiTestCaseResult testCaseResult = new PlausiTestCaseResult(this);
        try {
            ScriptEngineManager scriptEngineManager = new ScriptEngineManager();
            ScriptEngine scriptEngine = scriptEngineManager.getEngineByName("JavaScript");
            try (InputStreamReader reader = new InputStreamReader(this.getClass().getResourceAsStream("/de/statspez/pleditor/generator/codegen/js/runtime/plausilib.js"));){
                scriptEngine.eval(reader);
            }
            reader = new FileReader(javaScriptPlausiFile);
            try {
                scriptEngine.eval(reader);
            }
            finally {
                ((Reader)reader).close();
            }
            scriptEngine.eval("var values = new Array();");
            Iterator fieldValuesIterator = this.getInputValues();
            while (fieldValuesIterator.hasNext()) {
                FieldValues fieldValues = (FieldValues)fieldValuesIterator.next();
                Iterator fieldIterator = fieldValues.getFields();
                while (fieldIterator.hasNext()) {
                    String field = (String)fieldIterator.next();
                    String fieldValue = fieldValues.getValue(field);
                    if (fieldValue == null || fieldValue.length() <= 0) continue;
                    scriptEngine.eval("values['" + field + "'] = '" + fieldValue + "';");
                }
            }
            scriptEngine.eval("function getValue(field) {return values[field];}");
            scriptEngine.eval("function setValue(field, value) {values[field] = value;}");
            scriptEngine.eval("function getSizeOf(structure) {var size = getValue(structure + '#anzahl'); return size != null ? size : 0;}");
            scriptEngine.eval("function getIndicesAsString(indices) {return '[' + indices + ']';}");
            scriptEngine.eval("function getFieldWithoutIndices(field) {return field.replace(/\\[[0-9]*\\]/g, '');}");
            scriptEngine.eval("function getIndexOf(structure) {if (structure.charAt(structure.length - 1) == ']') { var field; if (structure.indexOf('.') > 0) { field = structure.substring(structure.lastIndexOf('.') + 1); } else { field = structure; } var index = field.substring(field.indexOf('[') + 1, field.indexOf(']')); return parseInt(index); } else { return 0; } }");
            scriptEngine.eval("function trace(text) {println(text);}");
            ProgramDescriptor programDescriptor = this.getProgramDescriptor(plausi);
            MetaMerkmal merkmal = (MetaMerkmal)programDescriptor.getPlausiElement();
            String statement = "prg_Merkmal_" + StringHelper.getEscapedName(merkmal.getName()) + "('" + this.getField() + "')";
            testCaseResult.handlePlausiResult(this.performJavaScriptPlausi(scriptEngine, statement), "JavaScript");
        }
        catch (Exception ex) {
            testCaseResult.addFailure(new TestFailure(this.getName(), "JavaScript", 5, ex));
        }
        finally {
            result.addTestCaseResult(testCaseResult);
        }
    }
}

