/*
 * Decompiled with CFR 0.152.
 */
package de.statspez.pleditor.generator.runtime.mapping;

public class StructureDescriptor {
    public static final int TYPE_STRUCTURE = 0;
    public static final int TYPE_FIELD = 1;
    public static final int TYPE_FIELD_GROUP = 2;
    public static final int TYPE_RECORD = 3;
    private final int type;
    private final String name;
    private final int[] dimensions;
    private final StructureDescriptor[] fields;

    public static StructureDescriptor create(StructureDescriptor[] fields) {
        return new StructureDescriptor(0, null, null, fields);
    }

    public static StructureDescriptor record(String name, StructureDescriptor[] fields) {
        return new StructureDescriptor(3, name, null, fields);
    }

    public static StructureDescriptor fieldGroup(String name, StructureDescriptor[] fields) {
        return new StructureDescriptor(2, name, null, fields);
    }

    public static StructureDescriptor fieldGroup(String name, int[] dimensions, StructureDescriptor[] fields) {
        return new StructureDescriptor(2, name, dimensions, fields);
    }

    public static StructureDescriptor field(String name) {
        return new StructureDescriptor(1, name, null, null);
    }

    private StructureDescriptor(int type, String name, int[] dimensions, StructureDescriptor[] fields) {
        this.type = type;
        this.name = name;
        this.dimensions = dimensions;
        this.fields = fields;
    }

    public String getName() {
        return this.name;
    }

    public boolean isField() {
        return this.type == 1;
    }

    public boolean isFieldGroup() {
        return this.type == 2;
    }

    public boolean isRecord() {
        return this.type == 3;
    }

    public int[] getDimensions() {
        return this.dimensions;
    }

    public StructureDescriptor[] getFields() {
        return this.fields;
    }
}

