/*
 * Decompiled with CFR 0.152.
 */
package de.statspez.pleditor.generator.runtime;

import de.statspez.pleditor.generator.runtime.Array;
import de.statspez.pleditor.generator.runtime.Variable;
import de.statspez.pleditor.generator.runtime.plausi.FeldDeskriptorInterface;
import java.util.HashMap;
import java.util.Stack;
import java.util.Vector;

public class ProgramSectionContext {
    private ProgramSectionContext parentContext;
    private String section;
    private boolean inPLPruefung;
    private Stack fields = new Stack();
    private HashMap variables = new HashMap();

    public ProgramSectionContext(String section, ProgramSectionContext parentContext) {
        this(section, parentContext, parentContext != null ? parentContext.isInPLPruefung() : false);
    }

    public ProgramSectionContext(String section, ProgramSectionContext parentContext, boolean inPLPruefung) {
        this.section = section;
        this.parentContext = parentContext;
        this.inPLPruefung = inPLPruefung;
    }

    public ProgramSectionContext parentContext() {
        return this.parentContext;
    }

    public String section() {
        return this.section;
    }

    public void setSection(String section) {
        this.section = section;
    }

    public void markFieldAccess(FeldDeskriptorInterface field) {
        assert (field != null) : "Feld ist null";
        this.fields.push(field);
        if (this.parentContext != null) {
            this.parentContext.markFieldAccessParent(field);
        }
    }

    public FeldDeskriptorInterface lastAccessedField() {
        if (this.fields.empty()) {
            return null;
        }
        return (FeldDeskriptorInterface)this.fields.peek();
    }

    public FeldDeskriptorInterface[] felderSortiertNachZugriff() {
        Vector<FeldDeskriptorInterface> result = new Vector<FeldDeskriptorInterface>();
        for (int i = 0; i < this.fields.size(); ++i) {
            FeldDeskriptorInterface aField = (FeldDeskriptorInterface)this.fields.get(i);
            if (result.contains(aField)) continue;
            result.add(aField);
        }
        this.fields.clear();
        return result.toArray(new FeldDeskriptorInterface[result.size()]);
    }

    public boolean isInPLPruefung() {
        return this.inPLPruefung;
    }

    public void defineVariable(String name, Variable variable) {
        this.variables.put(name, variable);
    }

    public Variable getVariable(String name) {
        Variable var = (Variable)this.variables.get(name);
        assert (var != null) : "Variable " + name + " ist in diesem Kontext nicht definiert.";
        return var;
    }

    public void defineArray(String name, Array array) {
        this.variables.put(name, array);
    }

    public Array getArray(String name) {
        Array array = (Array)this.variables.get(name);
        assert (array != null) : "Array " + name + " ist in diesem Kontext nicht definiert.";
        return array;
    }

    protected void markFieldAccessParent(FeldDeskriptorInterface field) {
        assert (field != null) : "Feld ist null";
        if (this.isInPLPruefung() && this.parentContext.isInPLPruefung()) {
            this.parentContext.markFieldAccessParent(field);
        } else if (this.isInPLPruefung()) {
            this.fields.push(field);
        }
    }
}

