/*
 * Decompiled with CFR 0.152.
 */
package de.statspez.pleditor.generator.runtime;

import de.statspez.pleditor.generator.runtime.FeatureVariable;
import de.statspez.pleditor.generator.runtime.FeldDeskriptorImpl;
import de.statspez.pleditor.generator.util.PlGeneratorUtil;
import java.io.Serializable;
import java.util.Hashtable;
import java.util.Iterator;

public class PlausiDescriptor
implements Serializable {
    static final long serialVersionUID = -7374619113408026848L;
    private String name = "unbenannt";
    private int version = 0;
    private Hashtable flows = new Hashtable();
    private FlowInfo standardFlow = null;
    private Hashtable specificationcode = new Hashtable();
    private Hashtable fieldDescriptors = new Hashtable();

    public String name() {
        return this.name;
    }

    public int version() {
        return this.version;
    }

    public void addFlow(FlowInfo aFlow) {
        this.flows.put(aFlow.name, aFlow);
    }

    public Iterator flows() {
        return this.flows.values().iterator();
    }

    public FlowInfo flow(String name) {
        return (FlowInfo)this.flows.get(name);
    }

    public FlowInfo standardFlow() {
        return this.standardFlow;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setStandardFlow(FlowInfo aFlow) {
        this.standardFlow = aFlow;
    }

    public void setVersion(int version) {
        assert (version > 0);
        this.version = version;
    }

    public String getCode(String pruefschluessel) {
        return (String)this.specificationcode.get(pruefschluessel);
    }

    public void setCodeFor(String pruefschluessel, String code) {
        this.specificationcode.put(pruefschluessel, code);
    }

    public Iterator specifications() {
        return this.specificationcode.keySet().iterator();
    }

    public void setFeldDeskriptor(String feldId, FeldDeskriptorImpl deskriptor) {
        this.fieldDescriptors.put(feldId, deskriptor);
    }

    public FeatureVariable getFeldDeskriptor(String feldId) {
        FeatureVariable variable = (FeatureVariable)this.fieldDescriptors.get(feldId.replaceAll("\\[[^\\]]*\\]", ""));
        if (variable != null) {
            FeatureVariable current = variable = (FeatureVariable)variable.copy(null);
            FeatureVariable parent = (FeatureVariable)current.getVorgaenger();
            while (parent != null) {
                parent = (FeatureVariable)parent.copy(null);
                current.setVorgaenger(parent);
                current = parent;
                parent = (FeatureVariable)current.getVorgaenger();
            }
            current = variable;
            String[] fieldHierarchy = feldId.split("\\.");
            for (int i = fieldHierarchy.length - 1; i >= 0; --i) {
                if (fieldHierarchy[i].indexOf(91) > 0) {
                    String index = fieldHierarchy[i].substring(fieldHierarchy[i].indexOf(91), fieldHierarchy[i].length());
                    int[] indices = PlGeneratorUtil.parseExternalIndex(index);
                    current.setIndizes(indices);
                } else {
                    current.setIndizes(new int[0]);
                }
                current = (FeatureVariable)current.getVorgaenger();
            }
        }
        return variable;
    }

    public Iterator fields() {
        return this.fieldDescriptors.values().iterator();
    }

    public static class FlowInfo
    implements Serializable {
        public String name;
        public Class[] paramTypes;

        public FlowInfo(String name, Class[] paramTypes) {
            this.name = name;
            this.paramTypes = paramTypes;
        }
    }
}

