/*
 * Decompiled with CFR 0.152.
 */
package de.statspez.pleditor.generator.runtime;

import de.statspez.pleditor.generator.runtime.Value;
import de.statspez.pleditor.generator.runtime.ValueConversionException;

public class InvalidValue
extends Value {
    private static final double INVALID_NUMBER_VALUE = 0.0;
    private static final boolean INVALID_BOOLEAN_VALUE = false;
    private static final String INVALID_STRING_VALUE = "";
    private static InvalidValue theInstance;

    public static InvalidValue instance() {
        if (theInstance == null) {
            theInstance = new InvalidValue();
        }
        return theInstance;
    }

    @Override
    public boolean isValid() {
        return false;
    }

    @Override
    public double asDouble() throws ValueConversionException {
        return 0.0;
    }

    @Override
    public long asLong() throws ValueConversionException {
        return 0L;
    }

    @Override
    public boolean asBoolean() throws ValueConversionException {
        return false;
    }

    @Override
    public String asString() throws ValueConversionException {
        return INVALID_STRING_VALUE;
    }

    @Override
    protected int operatorLevel() {
        return 100;
    }

    @Override
    protected boolean eqImpl(Value aValue) {
        return !aValue.isValid();
    }

    @Override
    protected boolean ltImpl(Value aValue) {
        return false;
    }

    @Override
    protected boolean leImpl(Value aValue) {
        return false;
    }

    @Override
    protected boolean gtImpl(Value aValue) {
        return false;
    }

    @Override
    protected boolean geImpl(Value aValue) {
        return false;
    }

    @Override
    protected boolean neImpl(Value aValue) {
        return aValue.isValid();
    }

    @Override
    protected boolean containsImpl(Value aValue) {
        return !aValue.isValid();
    }

    private InvalidValue() {
    }
}

