/*
 * Decompiled with CFR 0.152.
 */
package de.statspez.pleditor.generator.runtime;

import de.statspez.pleditor.generator.runtime.ClassificationGroup;
import de.statspez.pleditor.generator.runtime.NilValue;
import de.statspez.pleditor.generator.runtime.Value;
import de.statspez.pleditor.generator.runtime.ValueConversionException;

public class Classification
extends Value {
    private Value code = NilValue.instance();
    private Value value = NilValue.instance();
    private ClassificationGroup group = null;

    public Classification(Value code, Value value) {
        this.code = code;
        this.value = value;
    }

    public Value code() {
        return this.code;
    }

    public Value value() {
        return this.value;
    }

    @Override
    public double asDouble() throws ValueConversionException {
        return this.code().asDouble();
    }

    @Override
    public long asLong() throws ValueConversionException {
        return this.code().asLong();
    }

    @Override
    public boolean asBoolean() throws ValueConversionException {
        return this.code().asBoolean();
    }

    @Override
    public String asString() throws ValueConversionException {
        return this.code().asString();
    }

    public String fullCode() {
        StringBuffer buffer = new StringBuffer("");
        if (this.group != null) {
            buffer.append(this.group.fullCode());
            buffer.append(".");
        }
        buffer.append(this.code());
        return buffer.toString();
    }

    @Override
    protected int operatorLevel() {
        return 4;
    }

    @Override
    protected boolean eqImpl(Value aValue) {
        return this.code().eq(aValue);
    }

    @Override
    protected boolean ltImpl(Value aValue) {
        return this.code().lt(aValue);
    }

    @Override
    protected boolean leImpl(Value aValue) {
        return this.code().le(aValue);
    }

    @Override
    protected boolean gtImpl(Value aValue) {
        return this.code().gt(aValue);
    }

    @Override
    protected boolean geImpl(Value aValue) {
        return this.code().ge(aValue);
    }

    @Override
    protected boolean neImpl(Value aValue) {
        return this.code().ne(aValue);
    }

    @Override
    protected boolean containsImpl(Value aValue) {
        return this.code().contains(aValue);
    }

    protected void setGroup(ClassificationGroup group) {
        assert (this.group == null) : "Auspraegung gehoert bereits zu einer Gruppe";
        this.group = group;
    }
}

