/*
 * Decompiled with CFR 0.152.
 */
package de.statspez.pleditor.generator.runtime;

import de.statspez.pleditor.generator.runtime.PlausiRuntimeContext;
import de.statspez.pleditor.generator.runtime.SubArray;
import java.util.HashMap;

public abstract class Array {
    private final int[] dimension;
    private final HashMap daten;

    public Array(int[] dimension) {
        this.dimension = (int[])(dimension == null || dimension.length == 0 ? null : dimension);
        this.daten = new HashMap();
    }

    public int[] getDimension() {
        return this.dimension;
    }

    public HashMap getDaten() {
        return this.daten;
    }

    public int getLengthOfDimension(PlausiRuntimeContext context, int[] indizes) {
        if (this.dimension == null) {
            if (indizes == null || indizes.length == 0) {
                return 1;
            }
            throw new IllegalArgumentException("Die angegebene Anzahl der Dimensionen " + indizes.length + " \u00fcbersteigt die des Arrays (0).");
        }
        if (indizes == null || indizes.length <= this.dimension.length) {
            if (indizes == null) {
                if (this.dimension[0] == -1 || context.isReadConstArrayLength()) {
                    return this.getLengthOfDimensionImpl(context, null);
                }
                return this.dimension[0];
            }
            if (indizes.length == this.dimension.length) {
                return 1;
            }
            if (this.dimension[indizes.length] == -1 || context.isReadConstArrayLength()) {
                return this.getLengthOfDimensionImpl(context, indizes);
            }
            return this.dimension[indizes.length];
        }
        throw new IllegalArgumentException("Die angegebene Anzahl der Dimensionen " + indizes.length + " \u00fcbersteigt die des Arrays (" + this.dimension.length + ").");
    }

    public void setElement(PlausiRuntimeContext context, int[] indizes, Object object) {
        String key = this.getIndizesAsString(indizes);
        if (this.dimension == null) {
            if (indizes != null && indizes.length > 0) {
                throw new IndexOutOfBoundsException("Die angegebenen Indizes " + key + " \u00fcbersteigt die Anzahl der Dimensionen (0).");
            }
        } else if (!this.isIndexValidElementAccess(indizes)) {
            throw new IndexOutOfBoundsException("Die angegebenen Indizes " + key + " passen nicht zur definierten Dimension (" + this.getIndizesAsString(this.dimension) + ").");
        }
        this.ensureIndicesInRange(context, indizes);
        this.daten.put(key, object);
    }

    public Object getElement(PlausiRuntimeContext context, int[] indizes) {
        Object object;
        String key = this.getIndizesAsString(indizes);
        if (this.dimension == null) {
            if (indizes != null && indizes.length > 0) {
                throw new IndexOutOfBoundsException("Die angegebenen Indizes " + key + " \u00fcbersteigt die Anzahl der Dimensionen (0).");
            }
        } else {
            if (this.isIndexValidArrayAccess(indizes)) {
                this.ensureIndicesInRange(context, indizes);
                return new SubArray(this, indizes);
            }
            if (!this.isIndexValidElementAccess(indizes)) {
                throw new IndexOutOfBoundsException("Die angegebenen Indizes " + key + " passen nicht zur definierten Dimension (" + this.getIndizesAsString(this.dimension) + ").");
            }
        }
        this.ensureIndicesInRange(context, indizes);
        if (this.daten.containsKey(key)) {
            object = this.daten.get(key);
        } else {
            object = this.getElementImpl(context, indizes);
            this.daten.put(key, object);
        }
        return object;
    }

    protected abstract int getLengthOfDimensionImpl(PlausiRuntimeContext var1, int[] var2);

    protected abstract Object getElementImpl(PlausiRuntimeContext var1, int[] var2);

    private String getIndizesAsString(int[] indizes) {
        StringBuffer indizesAsString = new StringBuffer();
        if (indizes != null) {
            for (int i = 0; i < indizes.length; ++i) {
                indizesAsString.append(indizes[i]);
                if (i >= indizes.length - 1) continue;
                indizesAsString.append(",");
            }
        }
        return indizesAsString.toString();
    }

    private boolean isIndexValidArrayAccess(int[] indices) {
        boolean indexValidArrayAccess = false;
        if (this.dimension != null && indices.length < this.dimension.length) {
            indexValidArrayAccess = true;
        }
        return indexValidArrayAccess;
    }

    private boolean isIndexValidElementAccess(int[] indices) {
        boolean indexValidElementAccess = false;
        if (this.dimension == null) {
            if (indices == null || indices.length == 0) {
                indexValidElementAccess = true;
            }
        } else if (indices.length == this.dimension.length) {
            indexValidElementAccess = true;
        }
        return indexValidElementAccess;
    }

    private void ensureIndicesInRange(PlausiRuntimeContext context, int[] indices) {
        if (indices != null && indices.length > 0) {
            for (int i = 0; i < indices.length; ++i) {
                if (indices[i] < 0) {
                    throw new ArrayIndexOutOfBoundsException("Die angegebenen Indizes " + this.getIndizesAsString(indices) + " sind ung\u00fcltig.");
                }
                if (!context.isCheckArrayIndices()) continue;
                int[] sizeOfIndices = new int[i];
                for (int j = 0; j < i; ++j) {
                    sizeOfIndices[j] = indices[j];
                }
                int sizeOf = this.getLengthOfDimension(context, sizeOfIndices);
                if (sizeOf > indices[i]) continue;
                throw new ArrayIndexOutOfBoundsException("Der angegebene Index " + (indices[i] + 1) + " \u00fcbersteigt die Anzahl der S\u00e4tze (" + sizeOf + ").");
            }
        }
    }
}

