/*
 * Decompiled with CFR 0.152.
 */
package de.statspez.pleditor.generator.parser;

import de.statspez.pleditor.generator.meta.MetaElement;
import de.statspez.pleditor.generator.meta.generated.MetaStatspezObjekt;
import de.statspez.pleditor.generator.parser.ILParseException;
import de.statspez.pleditor.generator.parser.Resolver;
import de.statspez.pleditor.generator.parser.SubParser;
import de.statspez.pleditor.generator.parser.SuperParser;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class AboutParser
extends SubParser {
    private MetaStatspezObjekt currentElement = null;

    public AboutParser(SuperParser sParser, Resolver resolver) {
        super(sParser, resolver);
    }

    @Override
    public boolean canHandleOpenTag(String namespaceURI, String tag) {
        if ("http://www.destatis.de/schema/datml-ssp/1.0".equalsIgnoreCase(namespaceURI) && "about".equalsIgnoreCase(tag)) {
            return true;
        }
        return this.isEnabled();
    }

    @Override
    public boolean canHandleClosedTag(String namespaceURI, String tag) {
        return this.isEnabled();
    }

    @Override
    public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
        if ("about".equalsIgnoreCase(localName)) {
            this.enable();
        }
        this.handleAttributes(namespaceURI, localName, qName, atts);
    }

    @Override
    public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
        if ("about".equalsIgnoreCase(localName)) {
            this.disableAndNotify();
        } else if (!this.handleTag(namespaceURI, localName, qName)) {
            throw ILParseException.unkownClosingTagException(localName);
        }
    }

    @Override
    public MetaElement object() {
        return this.currentElement;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void handleAttributes(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
        String str;
        if ("about".equalsIgnoreCase(localName)) {
            String str2 = atts.getValue("id");
            if (str2 == null) return;
        }
        if ("abstract".equalsIgnoreCase(localName)) {
            String str3 = atts.getValue("id");
            if (str3 == null) return;
        }
        if ("description".equalsIgnoreCase(localName) && (str = atts.getValue("id")) == null) return;
    }

    private boolean handleTag(String namespaceURI, String localName, String qName) throws SAXException {
        boolean handled = true;
        if ("description".equalsIgnoreCase(localName)) {
            String chars = this.superParser().charData().toString();
            this.currentElement.setBeschreibung(chars);
        } else if (!"abstract".equalsIgnoreCase(localName)) {
            handled = false;
        }
        return handled;
    }

    public StringBuffer charData() {
        return this.superParser().charData();
    }

    public void setCurrentElement(MetaStatspezObjekt objekt) {
        this.currentElement = objekt;
    }
}

