/*
 * Decompiled with CFR 0.152.
 */
package de.statspez.pleditor.generator.meta;

import de.statspez.pleditor.generator.meta.MetaDualOperator;
import de.statspez.pleditor.generator.meta.MetaElementVisitor;
import de.statspez.pleditor.generator.meta.MetaFactor;

public class MetaMathOperator
extends MetaDualOperator {
    public static final int OPERATOR_UNDEFINED = 0;
    public static final int OPERATOR_PLUS = 1;
    public static final int OPERATOR_MINUS = 2;
    public static final int OPERATOR_DIV = 3;
    public static final int OPERATOR_MULT = 4;
    private static final String[] operatorsAsText = new String[]{"<undefined>", "+", "-", "/", "*"};
    private int type = 0;

    public MetaMathOperator(int type, MetaFactor firstOperand, MetaFactor secondOperand) {
        super(firstOperand, secondOperand);
        this.type = type;
    }

    public int type() {
        return this.type;
    }

    @Override
    public void accept(MetaElementVisitor aVisitor) {
        aVisitor.visitMathOperator(this);
    }

    @Override
    public String toString() {
        return "op" + operatorsAsText[this.type()];
    }

    public static int typeOf(String operator) {
        for (int i = 1; i < operatorsAsText.length; ++i) {
            if (!operatorsAsText[i].equals(operator)) continue;
            return i;
        }
        return 0;
    }
}

