/*
 * Decompiled with CFR 0.152.
 */
package de.statspez.pleditor.generator.masken;

import de.statspez.pleditor.generator.masken.DatumMaskenParser;
import de.statspez.pleditor.generator.masken.GanzZahlMaskenParser;
import de.statspez.pleditor.generator.masken.KommaZahlMaskenParser;
import de.statspez.pleditor.generator.masken.MaskeException;
import de.statspez.pleditor.generator.masken.MaskenParserInterface;
import de.statspez.pleditor.generator.masken.NichtNegGanzZahlParser;
import de.statspez.pleditor.generator.masken.PosGanzZahlMaskenParser;
import de.statspez.pleditor.generator.masken.ZeichenketteMaskenParser;

public class MaskenParserFaktory {
    public static final int GANZ_ZAHL = 1;
    public static final int DATE = 2;
    public static final int TIME = 3;
    public static final int KOMMA_ZAHL = 4;
    public static final int POS_ZAHL = 5;
    public static final int ZEICHENKETTE = 6;
    public static final int NICHT_NEG_ZAHL = 7;
    private static MaskenParserFaktory faktory;

    private MaskenParserFaktory() {
    }

    public static synchronized MaskenParserFaktory getInstance() {
        if (faktory == null) {
            faktory = new MaskenParserFaktory();
        }
        return faktory;
    }

    public MaskenParserInterface getMaskenParserFuerTyp(int typ) throws MaskeException {
        switch (typ) {
            case 2: 
            case 3: {
                return new DatumMaskenParser();
            }
            case 1: {
                return new GanzZahlMaskenParser();
            }
            case 5: {
                return new PosGanzZahlMaskenParser();
            }
            case 4: {
                return new KommaZahlMaskenParser();
            }
            case 6: {
                return new ZeichenketteMaskenParser();
            }
            case 7: {
                return new NichtNegGanzZahlParser();
            }
        }
        throw new MaskeException("MaskenParserInterface f\u00fcr Typ " + typ + " konnte nicht erzeugt werden");
    }
}

