/*
 * Decompiled with CFR 0.152.
 */
package de.statspez.pleditor.generator.format;

import de.statspez.pleditor.generator.format.Segment;
import de.statspez.pleditor.generator.format.SegmentVisitor;

public class FormatSegment
implements Segment {
    public static final String BOLD = "f";
    public static final String ITALIC = "k";
    public static final String UNDERLINED = "u";
    public static final String SUPER = "h";
    public static final String SUB = "t";
    public static final String ORDERED_LIST = "nl";
    public static final String UNORDERED_LIST = "ul";
    public static final String LIST_ELEMENT = "le";
    public static final String HEADING_1 = "t1";
    public static final String HEADING_2 = "t2";
    public static final String HEADING_3 = "t3";
    public static final String HEADING_4 = "t4";
    public static final String[] FORMATS = new String[]{"f", "k", "u", "h", "t", "nl", "ul", "le", "t1", "t2", "t3", "t4"};
    private final String type;
    private final Segment formatedSegment;

    public FormatSegment(String type, Segment formatedSegment) {
        boolean typeCorrect = false;
        for (int i = 0; i < FORMATS.length; ++i) {
            if (!FORMATS[i].equals(type)) continue;
            typeCorrect = true;
            break;
        }
        if (!typeCorrect) {
            throw new IllegalArgumentException("Unbekannter Formattyp: " + type);
        }
        this.type = type;
        this.formatedSegment = formatedSegment;
    }

    public String getType() {
        return this.type;
    }

    public Segment getFormatedSegment() {
        return this.formatedSegment;
    }

    public String toString() {
        return "{" + this.type + "}" + this.formatedSegment + "{" + this.type + "}";
    }

    @Override
    public boolean isComplex() {
        return true;
    }

    @Override
    public boolean containsCode() {
        return this.formatedSegment.containsCode();
    }

    @Override
    public void accept(SegmentVisitor visitor) {
        visitor.visitFormatSegment(this);
    }
}

