/*
 * Decompiled with CFR 0.152.
 */
package de.statspez.pleditor.generator.compare2.pdf;

import com.lowagie.text.Document;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfDestination;
import com.lowagie.text.pdf.PdfOutline;
import com.lowagie.text.pdf.PdfPTable;
import com.lowagie.text.pdf.PdfPageEventHelper;
import com.lowagie.text.pdf.PdfWriter;
import de.statspez.pleditor.generator.compare2.pdf.ITextUtil;
import de.statspez.pleditor.generator.compare2.pdf.PdfConfig;
import de.statspez.pleditor.generator.compare2.pdf.PdfContext;

public class PdfEventHelper
extends PdfPageEventHelper {
    private PdfDestination destination;
    private PdfWriter writer;
    private PdfContext kontext;
    private PdfConfig pdfConfig;

    public PdfEventHelper(PdfContext kontext, PdfConfig pdfConfig) {
        this.kontext = kontext;
        this.pdfConfig = pdfConfig;
    }

    public void onOpenDocument(PdfWriter writer, Document document) {
        this.writer = writer;
    }

    public void onCloseDocument(PdfWriter writer, Document document) {
        this.writer = null;
        int nr = writer.getPageNumber();
        this.kontext.setCurrentPageNr(nr);
    }

    public void onParagraph(PdfWriter writer, Document document, float position) {
        this.destination = new PdfDestination(0, document.left(), position, 0.0f);
    }

    public void onStartPage(PdfWriter writer, Document document) {
        int nr = writer.getCurrentPageNumber();
        this.kontext.setCurrentPageNr(nr);
    }

    public void onEndPage(PdfWriter writer, Document dokument) {
        this.kontext.setPagecount(writer.getCurrentPageNumber());
        this.addFooter(writer, dokument);
    }

    public PdfOutline writeOutlineElement(String text, PdfOutline outline) {
        PdfContentByte cb = this.writer.getDirectContent();
        if (outline == null) {
            outline = cb.getRootOutline();
        }
        return new PdfOutline(outline, this.destination, text);
    }

    private void addFooter(PdfWriter writer, Document document) {
        PdfPTable table = ITextUtil.createFooter(this.pdfConfig, this.kontext);
        table.setTotalWidth(document.right() - document.leftMargin());
        float x = document.leftMargin();
        float y = document.bottomMargin() - 10.0f;
        table.writeSelectedRows(0, -1, x, y, writer.getDirectContent());
    }
}

