/*
 * Decompiled with CFR 0.152.
 */
package de.statspez.pleditor.generator.compare2;

import de.statspez.pleditor.generator.codegen.support.Traverser;
import de.statspez.pleditor.generator.compare2.Comparator;
import de.statspez.pleditor.generator.compare2.ComparedCell;
import de.statspez.pleditor.generator.compare2.DefaultComparedNode;
import de.statspez.pleditor.generator.meta.MetaCustomAuspraegung;
import de.statspez.pleditor.generator.meta.MetaCustomMerkmal;
import de.statspez.pleditor.generator.meta.MetaCustomTBFeld;
import de.statspez.pleditor.generator.meta.MetaElement;
import de.statspez.pleditor.generator.meta.generated.MetaAuspraegungsgruppe;
import de.statspez.pleditor.generator.meta.generated.MetaMerkmal;
import de.statspez.pleditor.generator.meta.generated.MetaPLAuspraegung;
import de.statspez.pleditor.generator.meta.generated.MetaTBFeld;
import de.statspez.pleditor.generator.meta.generated.MetaThemenbereich;
import de.statspez.pleditor.generator.runtime.FeldDeskriptor;
import de.statspez.pleditor.generator.runtime.FeldDeskriptorExt;
import de.statspez.pleditor.generator.runtime.FeldDeskriptorImpl;
import de.statspez.pleditor.generator.runtime.InvalidValue;
import de.statspez.pleditor.generator.runtime.Value;
import de.statspez.pleditor.generator.runtime.plausi.FeldDeskriptorInterface;
import de.statspez.pleditor.generator.runtime.plausi.SatzInterface;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Stack;

public abstract class ComparedNode {
    private Comparator comparator;
    protected SatzInterface hauptsatz;
    private List<SatzInterface> vergleichssaetze;
    private List<ComparedCell> vergleichswerte;
    protected String hauptsatzAnzeigewert;
    private boolean changed;
    private ComparedNode parent;
    private List<ComparedNode> children;
    private MetaElement element;
    private FeldDeskriptorImpl feldDeskriptor;
    private boolean virtual;

    public ComparedNode(ComparedNode parent, MetaElement element, FeldDeskriptorImpl feldDeskriptor, boolean virtual, SatzInterface hauptsatz, List<SatzInterface> vergleichssaetze, Comparator comparator) {
        this.parent = parent;
        this.children = new ArrayList<ComparedNode>();
        this.element = element;
        this.feldDeskriptor = feldDeskriptor;
        this.virtual = virtual;
        this.hauptsatz = hauptsatz;
        this.comparator = comparator;
        this.hauptsatzAnzeigewert = null;
        this.changed = false;
        if (this.parent != null) {
            this.parent.addChild(this);
        }
        this.vergleichssaetze = Collections.unmodifiableList(new ArrayList<SatzInterface>(vergleichssaetze));
        this.vergleichswerte = new ArrayList<ComparedCell>();
        if (this.vergleichssaetze != null) {
            Iterator<SatzInterface> iterator = this.vergleichssaetze.iterator();
            while (iterator.hasNext()) {
                this.vergleichswerte.add(this.createComparedCell(iterator.next()));
            }
        }
    }

    public ComparedNode getParent() {
        return this.parent;
    }

    public List<ComparedNode> getChildren() {
        return this.children;
    }

    public void setChildren(List<ComparedNode> children) {
        this.children = children;
    }

    public int getChildCount() {
        int childCount = 0;
        childCount = this.children.size();
        return childCount;
    }

    public ComparedNode getChild(int index) {
        return this.children.get(index);
    }

    public void addChild(ComparedNode child) {
        this.children.add(child);
    }

    public void removeChild(ComparedNode child) {
        this.children.remove(child);
    }

    public boolean hasChild(ComparedNode child) {
        return this.children.contains(child);
    }

    public MetaElement getElement() {
        return this.element;
    }

    public FeldDeskriptorImpl getFeldDeskriptor() {
        return this.feldDeskriptor;
    }

    public void setFeldDeskriptor(FeldDeskriptorImpl descriptor) {
        this.feldDeskriptor = descriptor;
    }

    public MetaCustomMerkmal getFeature() {
        MetaCustomMerkmal feature = this.element instanceof MetaTBFeld && ((MetaTBFeld)this.element).getKlasse() instanceof MetaCustomMerkmal ? (MetaCustomMerkmal)((MetaTBFeld)this.element).getKlasse() : null;
        return feature;
    }

    public MetaAuspraegungsgruppe getClassifications() {
        MetaCustomMerkmal feature = this.getFeature();
        MetaAuspraegungsgruppe classifications = feature != null ? feature.getKlasseWertebereich() : null;
        return classifications;
    }

    public void readValues() {
        this.readValueOfHauptsatz();
        this.readValuesOfVergleichssaetze();
    }

    public String getDisplayvalueOfHauptsatz() {
        return this.hauptsatzAnzeigewert;
    }

    public String getDisplayvalueOfVergleichssatz(int vergleichssatz) {
        return this.getComparedCell(vergleichssatz - 1).getDisplayValue();
    }

    public boolean hasDifferentValues() {
        for (int indexOfVergleichssatz = 0; indexOfVergleichssatz < this.vergleichssaetze.size(); ++indexOfVergleichssatz) {
            if (!this.hasDifferentValues(indexOfVergleichssatz)) continue;
            return true;
        }
        return false;
    }

    private boolean hasDifferentValues(int indexOfVergleichssatz) {
        boolean result;
        if (this.element instanceof MetaThemenbereich) {
            result = false;
        } else if (this.getParent().hasHauptsatz() != this.getParent().hasSatzByVergleichssatzIndex(indexOfVergleichssatz)) {
            result = false;
        } else {
            boolean hasSatz1 = this.hasHauptsatz();
            boolean hasSatz2 = this.hasSatzByVergleichssatzIndex(indexOfVergleichssatz);
            MetaTBFeld field = (MetaTBFeld)this.element;
            if (field.getKlasse() instanceof MetaThemenbereich) {
                result = hasSatz1 != hasSatz2;
            } else if (hasSatz1 && hasSatz2) {
                boolean hasValue1 = this.hasHauptsatzValue();
                boolean hasValue2 = this.hasValue(indexOfVergleichssatz);
                result = hasValue1 && hasValue2 ? this.isDifferentValue(indexOfVergleichssatz) : hasValue1 != hasValue2;
            } else {
                result = false;
            }
        }
        return result;
    }

    public abstract boolean hasHauptsatzValue();

    public boolean hasValueSomeVergleichssatz() {
        for (int i = 0; i < this.vergleichssaetze.size(); ++i) {
            if (!this.hasValue(i)) continue;
            return true;
        }
        return false;
    }

    private boolean hasValue(int indexOfVergleichssatz) {
        return this.getComparedCell(indexOfVergleichssatz).hasValue();
    }

    public void setChanged(boolean changed) {
        this.changed = changed;
    }

    public boolean isChanged() {
        return this.changed;
    }

    public boolean isRemoved() {
        return this.getParent() != null && !this.getParent().hasChild(this);
    }

    public boolean isVirtual() {
        return this.virtual;
    }

    public boolean isLeaf() {
        return this.getChildCount() == 0;
    }

    public boolean isStrukturknoten() {
        return this.getElement() instanceof MetaTBFeld && ((MetaTBFeld)this.getElement()).getKlasse() instanceof MetaThemenbereich;
    }

    public boolean isRootKnoten() {
        return this.getElement() instanceof MetaThemenbereich;
    }

    public boolean hasHauptsatz() {
        boolean result;
        if (this.element instanceof MetaThemenbereich) {
            result = true;
        } else {
            MetaTBFeld field = (MetaTBFeld)this.element;
            if (field.getKlasse() instanceof MetaThemenbereich) {
                if (this.getFeldDeskriptor().getIndizes() != null) {
                    int[] basisIndizes = this.getBasisIndizes(this.getFeldDeskriptor().getIndizes());
                    result = this.getParent().hasHauptsatz() && this.getFeldDeskriptor().getLaenge(this.hauptsatz, basisIndizes) > this.getFeldDeskriptor().getIndizes()[0];
                } else {
                    result = this.getParent().hasHauptsatz();
                }
            } else {
                result = this.getParent().hasHauptsatz();
            }
        }
        return result;
    }

    public boolean hasSatzByVergleichssatzNr(int vergleichssatz) {
        return this.hasSatzByVergleichssatzIndex(vergleichssatz - 1);
    }

    public boolean hasSatzSomeVergleichssatz() {
        for (int i = 0; i < this.vergleichssaetze.size(); ++i) {
            if (!this.hasSatzByVergleichssatzIndex(i)) continue;
            return true;
        }
        return false;
    }

    protected boolean hasSatzByVergleichssatzIndex(int indexOfVergleichssatz) {
        boolean result;
        if (this.element instanceof MetaThemenbereich) {
            result = true;
        } else {
            MetaTBFeld field = (MetaTBFeld)this.element;
            if (field.getKlasse() instanceof MetaThemenbereich) {
                if (this.getFeldDeskriptor().getIndizes() != null && this.getFeldDeskriptor().getIndizes().length != 0) {
                    int[] basisIndizes = this.getBasisIndizes(this.getFeldDeskriptor().getIndizes());
                    return this.getParent().hasSatzByVergleichssatzIndex(indexOfVergleichssatz) && this.getFeldDeskriptor().getLaenge(this.vergleichssaetze.get(indexOfVergleichssatz), basisIndizes) > this.getFeldDeskriptor().getIndizes()[this.getFeldDeskriptor().getIndizes().length - 1];
                }
                result = this.getParent().hasSatzByVergleichssatzIndex(indexOfVergleichssatz);
            } else {
                result = this.getParent().hasSatzByVergleichssatzIndex(indexOfVergleichssatz);
            }
        }
        return result;
    }

    public int getMaxLengthOfSet(int[] indizies) {
        Iterator<SatzInterface> iterator = this.vergleichssaetze.iterator();
        int maxLength = 0;
        int index = 0;
        while (iterator.hasNext()) {
            int length;
            SatzInterface satz = iterator.next();
            if (this.hasSatzByVergleichssatzIndex(index) && (length = this.getFeldDeskriptor().getLaenge(satz, indizies)) > maxLength) {
                maxLength = length;
            }
            ++index;
        }
        return maxLength;
    }

    public String toString() {
        String text;
        if (this.element instanceof MetaThemenbereich) {
            text = ((MetaThemenbereich)this.element).getName();
        } else {
            StringBuffer buffer = new StringBuffer();
            MetaTBFeld field = (MetaTBFeld)this.element;
            if (field.getBezeichnung() != null && field.getBezeichnung().length() > 0) {
                buffer.append(field.getBezeichnung());
            } else {
                buffer.append(field.getName());
            }
            if (this.feldDeskriptor.getIndizes() != null && this.feldDeskriptor.getIndizes().length > 0) {
                buffer.append(' ');
                for (int i = 0; i < this.feldDeskriptor.getIndizes().length; ++i) {
                    buffer.append('[');
                    buffer.append(this.feldDeskriptor.getIndizes()[i] + 1);
                    buffer.append(']');
                }
            }
            text = buffer.toString();
        }
        return text;
    }

    public ComparedNode[] getPath() {
        return this.getPathToRoot(this, 0);
    }

    protected ComparedNode[] getPathToRoot(ComparedNode aNode, int depth) {
        ComparedNode[] retNodes;
        if (aNode == null) {
            if (depth == 0) {
                return null;
            }
            retNodes = new ComparedNode[depth];
        } else {
            retNodes = this.getPathToRoot(aNode.getParent(), ++depth);
            retNodes[retNodes.length - depth] = aNode;
        }
        return retNodes;
    }

    public static String getClassificationText(MetaAuspraegungsgruppe classifications, final String code) {
        final StringBuffer result = new StringBuffer();
        Traverser traverser = new Traverser(){

            @Override
            public void visitPLAuspraegung(MetaPLAuspraegung classification) {
                if (classification.sizeOfAuspraegungen() > 0) {
                    this.visitElements(classification.getAuspraegungen());
                } else if (classification instanceof MetaCustomAuspraegung) {
                    if (((MetaCustomAuspraegung)classification).getPlainClassificationKode().equals(code)) {
                        result.append(classification.getName());
                        throw new BreakException();
                    }
                } else {
                    throw new IllegalArgumentException("Auspr\u00e4gung muss MetaCustomAuspraegung sein!");
                }
            }
        };
        try {
            classifications.accept(traverser);
        }
        catch (BreakException breakException) {
            // empty catch block
        }
        return result.toString();
    }

    public void transferValue(int vergleichssatz) {
        if (!this.hasHauptsatz()) {
            ComparedNode zielNode = this.getPassendenFreienCompareNode(this);
            if (zielNode != null && !zielNode.hasHauptsatz()) {
                zielNode.doTransferValueToHauptsatz(this, vergleichssatz - 1, true);
            }
        } else {
            this.doTransferValueToHauptsatz(this, vergleichssatz - 1, true);
        }
    }

    public void deleteThisStrukturknoten() {
        if (this.isStrukturknoten()) {
            ComparedNode parentNode = this.parent;
            this.getFeldDeskriptor().setValueWith(this.hauptsatz, InvalidValue.instance());
            if (!this.hasSatzSomeVergleichssatz()) {
                this.removeFromParent();
            }
            this.setChanged(true);
            int numberOfChild = this.getChildCount();
            for (int i = 0; i < numberOfChild; ++i) {
                this.getChild(i).setChanged(false);
            }
            parentNode.readValuesOfTree();
        }
    }

    public boolean isErsterFreierCompareNode() {
        if (this.hasHauptsatz()) {
            return false;
        }
        return this.parent == this.getPassendenFreienCompareNode(this);
    }

    private ComparedNode getPassendenFreienCompareNode(ComparedNode similarNode) {
        int gradDerVerwandschaft = 1;
        ArrayList<MetaElement> elementeDerVerwandschaft = new ArrayList<MetaElement>();
        ComparedNode existsParent = similarNode.getParent();
        elementeDerVerwandschaft.add(existsParent.getElement());
        while (!existsParent.hasHauptsatz()) {
            if ((existsParent = existsParent.getParent()).isVirtual()) continue;
            elementeDerVerwandschaft.add(existsParent.getElement());
            ++gradDerVerwandschaft;
        }
        return this.getPassendenFreienCompareNode(existsParent, gradDerVerwandschaft, elementeDerVerwandschaft);
    }

    private ComparedNode getPassendenFreienCompareNode(ComparedNode parent, int gradDerVerwandschaft, List<MetaElement> elementeDerVerwandschaft) {
        ComparedNode zielNode = null;
        MetaElement element = elementeDerVerwandschaft.get(gradDerVerwandschaft - 1);
        for (int i = 0; i < parent.getChildCount(); ++i) {
            zielNode = parent.getChild(i);
            if (zielNode.hasHauptsatz() || zielNode.getElement() != element) continue;
            if (zielNode.isVirtual()) {
                return this.getPassendenFreienCompareNode(zielNode, gradDerVerwandschaft, elementeDerVerwandschaft);
            }
            if (gradDerVerwandschaft == 1) break;
            return this.getPassendenFreienCompareNode(zielNode, gradDerVerwandschaft - 1, elementeDerVerwandschaft);
        }
        if (zielNode.hasHauptsatz()) {
            return null;
        }
        return zielNode;
    }

    public ComparedNode copyValue(int vergleichssatz) throws NoSuchFieldException {
        return this.copyValueByIndex(vergleichssatz - 1);
    }

    public ComparedNode appendSatz() throws NoSuchFieldException {
        ComparedNode nodeForAppendedSatz;
        int size = this.getLaenge(this.hauptsatz);
        int[] indezesForNewNode = new int[]{size};
        FeldDeskriptorImpl currentFeldDeskriptor = this.comparator.createFeldDeskriptor(this.getFeldDeskriptor().getFeldNameTB(), indezesForNewNode, (FeldDeskriptorImpl)this.getFeldDeskriptor().getVorgaenger());
        this.getSubSatz(this.hauptsatz, currentFeldDeskriptor);
        if (size == this.children.size()) {
            nodeForAppendedSatz = new DefaultComparedNode(this, this.element, currentFeldDeskriptor, this.isVirtual(), this.hauptsatz, this.vergleichssaetze, this.comparator);
            this.comparator.buildSubNodes((MetaTBFeld)this.element, nodeForAppendedSatz);
        } else {
            nodeForAppendedSatz = this.getChild(size);
        }
        nodeForAppendedSatz.setChanged(true);
        return nodeForAppendedSatz;
    }

    protected SatzInterface getSubSatz(SatzInterface satzInterface, FeldDeskriptorInterface feldDeskriptor) throws ArrayIndexOutOfBoundsException, NoSuchFieldException {
        FeldDeskriptorInterface current;
        Stack<FeldDeskriptorInterface> hierachy = new Stack<FeldDeskriptorInterface>();
        for (current = feldDeskriptor; current != null; current = current.getVorgaenger()) {
            hierachy.push(current);
        }
        SatzInterface subSatz = satzInterface;
        while (!hierachy.empty()) {
            current = (FeldDeskriptorInterface)hierachy.pop();
            subSatz = subSatz.getSubSatz(current);
        }
        return subSatz;
    }

    private void copyNode(int indexOfVergleichssatz, ComparedNode quelle, ComparedNode parentNode) throws NoSuchFieldException {
        boolean hasSatz = quelle.hasSatzByVergleichssatzIndex(indexOfVergleichssatz);
        if (hasSatz) {
            int[] indizes_orig = quelle.getFeldDeskriptor().getIndizes();
            int[] indizes_copy = null;
            if (indizes_orig != null && indizes_orig.length > 0) {
                indizes_copy = new int[indizes_orig.length];
                System.arraycopy(indizes_orig, 0, indizes_copy, 0, indizes_orig.length);
            }
            FeldDeskriptorImpl parentFeldDeskriptor = parentNode.isVirtual() ? parentNode.getRealParent().getFeldDeskriptor() : parentNode.getFeldDeskriptor();
            FeldDeskriptorImpl feldDeskriptorNeu = this.comparator.createFeldDeskriptor(quelle.getFeldDeskriptor().getFeldNameTB(), indizes_copy, parentFeldDeskriptor);
            DefaultComparedNode copy = new DefaultComparedNode(parentNode, quelle.getElement(), feldDeskriptorNeu, quelle.isVirtual(), this.hauptsatz, this.vergleichssaetze, this.comparator);
            if (quelle.getElement() instanceof MetaTBFeld) {
                if (((MetaTBFeld)quelle.getElement()).getKlasse() instanceof MetaCustomMerkmal && quelle.getChildCount() == 0) {
                    Value value = quelle.getFeldDeskriptor().getValueFrom(this.vergleichssaetze.get(indexOfVergleichssatz));
                    copy.getFeldDeskriptor().setValueWith(this.hauptsatz, value);
                    ((ComparedNode)copy).readValueOfHauptsatz();
                } else if (quelle.getChildCount() > 0) {
                    int numberOfChild = quelle.getChildCount();
                    for (int i = 0; i < numberOfChild; ++i) {
                        ComparedNode quelleChild = quelle.getChild(i);
                        this.copyNode(indexOfVergleichssatz, quelleChild, copy);
                    }
                }
            }
        }
    }

    public ComparedNode getRealParent() {
        ComparedNode realParent = this.getParent() != null && this.getParent().isVirtual() ? this.getParent().getRealParent() : this.getParent();
        return realParent;
    }

    public void removeFromParent() {
        if (this.getParent() != null) {
            ComparedNode parent = this.getParent();
            int[] indices = new int[parent.getChildCount()];
            if (this.getFeldDeskriptor().getIndizes() != null) {
                for (int i = 0; i < parent.getChildCount(); ++i) {
                    int[] in = parent.getChild(i).getFeldDeskriptor().getIndizes();
                    if (in == null) continue;
                    int l = parent.getChild(i).getFeldDeskriptor().getIndizes().length;
                    for (int j = 0; j < l; ++j) {
                        indices[i] = parent.getChild(i).getFeldDeskriptor().getIndizes()[j] + 1;
                    }
                }
            }
            parent.removeChild(this);
            if (this.getFeldDeskriptor().getIndizes() != null) {
                int[] newIndices = new int[1];
                for (int i = 0; i < parent.getChildCount(); ++i) {
                    newIndices[0] = indices[i] - 1;
                    if (newIndices == null) continue;
                    parent.getChild(i).getFeldDeskriptor().setIndizes(newIndices);
                }
            }
        }
    }

    public SatzInterface getHauptsatz() {
        return this.hauptsatz;
    }

    public List<SatzInterface> getVergleichssaetze() {
        return this.vergleichssaetze;
    }

    public boolean isNDimensional() {
        boolean result = false;
        if (this.getFeldDeskriptor() != null) {
            int[] indizes = null;
            FeldDeskriptor feldDeskriptor = this.getFeldDeskriptor().getFeldDeskriptor();
            if (feldDeskriptor != null && feldDeskriptor instanceof FeldDeskriptorExt) {
                indizes = ((FeldDeskriptorExt)feldDeskriptor).getDimension();
            }
            if (indizes != null && indizes.length > 0 && indizes[indizes.length - 1] < 0) {
                result = true;
            }
        }
        return result;
    }

    private int[] getBasisIndizes(int[] indizes) {
        int[] basisIndizes = null;
        if (indizes != null && indizes.length > 1) {
            basisIndizes = new int[indizes.length - 1];
            System.arraycopy(indizes, 0, basisIndizes, 0, indizes.length - 1);
        }
        return basisIndizes;
    }

    private int getLaenge(SatzInterface satz) {
        int laenge = 0;
        if (this.getParent().hasHauptsatz()) {
            int[] basisIndizes = this.getBasisIndizes(this.getFeldDeskriptor().getIndizes());
            laenge = this.getFeldDeskriptor().getLaenge(satz, basisIndizes);
        }
        return laenge;
    }

    protected abstract void readValueOfHauptsatz();

    public void readValuesOfTree() {
        if (this.getElement() instanceof MetaTBFeld && ((MetaTBFeld)this.getElement()).getKlasse() instanceof MetaMerkmal) {
            this.readValueOfHauptsatz();
        } else if (this.getElement() instanceof MetaTBFeld && ((MetaTBFeld)this.getElement()).getKlasse() instanceof MetaThemenbereich && !this.hasHauptsatz() && !this.hasSatzSomeVergleichssatz()) {
            this.removeFromParent();
        }
        int anzahlKinder = this.getChildCount();
        for (int i = 0; i < anzahlKinder; ++i) {
            ComparedNode node = this.getChild(i);
            node.readValuesOfTree();
        }
    }

    private void readValuesOfVergleichssaetze() {
        for (int index = 0; index < this.vergleichssaetze.size(); ++index) {
            this.readValue(index);
        }
    }

    protected void readValue(int indexOfVergleichssatz) {
        if (this.hasSatzByVergleichssatzIndex(indexOfVergleichssatz)) {
            MetaAuspraegungsgruppe classifications = this.getClassifications();
            this.getComparedCell(indexOfVergleichssatz).readValue(this.getFeldDeskriptor(), classifications);
        }
    }

    protected ComparedCell getComparedCell(int indexOfVergleichssatz) {
        if (this.vergleichswerte.size() > indexOfVergleichssatz) {
            return this.vergleichswerte.get(indexOfVergleichssatz);
        }
        return ComparedCell.EMPTY_CELL;
    }

    private ComparedNode copyValueByIndex(int indexOfVergleichssatz) throws NoSuchFieldException {
        int[] indezes_orig = this.getFeldDeskriptor().getIndizes();
        int[] indezes_copy = new int[indezes_orig.length];
        System.arraycopy(indezes_orig, 0, indezes_copy, 0, indezes_orig.length - 1);
        int size1 = this.getLaenge(this.hauptsatz);
        int size2 = this.getLaenge(this.getVergleichssaetze().get(indexOfVergleichssatz));
        indezes_copy[indezes_orig.length - 1] = size1 > size2 ? size1 : size2;
        FeldDeskriptorImpl currentFeldDeskriptor = this.comparator.createFeldDeskriptor(this.getFeldDeskriptor().getFeldNameTB(), indezes_copy, (FeldDeskriptorImpl)this.getFeldDeskriptor().getVorgaenger());
        ComparedNode copy = this.getPassendenFreienCompareNode(this);
        if (copy != null) {
            copy.doTransferValueToHauptsatz(this, indexOfVergleichssatz, true);
            return copy;
        }
        copy = new DefaultComparedNode(this.getParent(), this.element, currentFeldDeskriptor, this.isVirtual(), this.hauptsatz, this.vergleichssaetze, this.comparator);
        copy.setChanged(true);
        if (this.getChildCount() > 0) {
            int numberOfChild = this.getChildCount();
            for (int i = 0; i < numberOfChild; ++i) {
                ComparedNode child = this.getChild(i);
                this.copyNode(indexOfVergleichssatz, child, copy);
            }
        }
        return copy;
    }

    private void doTransferValueToHauptsatz(ComparedNode quellNode, int indexOfVergleichssatz, boolean markAsChanged) {
        int numberOfChild = this.getChildCount();
        if (this.getElement() instanceof MetaThemenbereich) {
            for (int i = 0; i < numberOfChild; ++i) {
                this.getChild(i).doTransferValueToHauptsatz(quellNode.getChild(i), indexOfVergleichssatz, markAsChanged);
            }
        } else if (this.isVirtual()) {
            for (int i = 0; i < numberOfChild; ++i) {
                this.getChild(i).doTransferValueToHauptsatz(quellNode.getChild(i), indexOfVergleichssatz, markAsChanged);
            }
            if (this.getChildCount() == 0) {
                this.removeFromParent();
            }
        } else if (((MetaTBFeld)this.getElement()).getKlasse() instanceof MetaThemenbereich) {
            if (quellNode.hasSatzByVergleichssatzIndex(indexOfVergleichssatz)) {
                boolean hasHauptsatz = this.hasHauptsatz();
                for (int i = 0; i < numberOfChild; ++i) {
                    this.getChild(i).doTransferValueToHauptsatz(quellNode.getChild(i), indexOfVergleichssatz, markAsChanged && hasHauptsatz);
                }
                if (markAsChanged && !hasHauptsatz) {
                    this.setChanged(true);
                }
            } else if (this.hasHauptsatz()) {
                this.getFeldDeskriptor().setValueWith(this.hauptsatz, InvalidValue.instance());
                if (!this.hasSatzSomeVergleichssatz()) {
                    this.removeFromParent();
                }
                if (markAsChanged) {
                    this.setChanged(true);
                    for (int i = 0; i < numberOfChild; ++i) {
                        this.getChild(i).setChanged(false);
                    }
                }
            }
        } else {
            if (quellNode.hasSatzByVergleichssatzIndex(indexOfVergleichssatz)) {
                if (this != quellNode || !this.hasHauptsatz() || quellNode.hasDifferentValues(indexOfVergleichssatz)) {
                    this.setVergleichssatzValueInHauptsatz(quellNode, indexOfVergleichssatz);
                    if (markAsChanged) {
                        this.setChanged(true);
                    }
                }
            } else if (this.hasHauptsatz()) {
                this.getFeldDeskriptor().setValueWith(this.hauptsatz, InvalidValue.instance());
                this.readValueOfHauptsatz();
                if (markAsChanged) {
                    this.setChanged(true);
                }
            }
            this.readValueOfHauptsatz();
        }
    }

    public abstract boolean setHauptsatzValue(Object var1, boolean var2);

    public MetaCustomTBFeld getMetaTBFeld() {
        MetaCustomTBFeld result = null;
        if (this.element instanceof MetaCustomTBFeld) {
            result = (MetaCustomTBFeld)this.element;
        }
        return result;
    }

    protected abstract ComparedCell createComparedCell(SatzInterface var1);

    protected abstract boolean isDifferentValue(int var1);

    protected abstract void setVergleichssatzValueInHauptsatz(ComparedNode var1, int var2);

    private static class BreakException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        private BreakException() {
        }
    }
}

