/*
 * Decompiled with CFR 0.152.
 */
package de.statspez.pleditor.generator.compare;

import de.statspez.pleditor.generator.compare.ComparedNode;
import java.util.ArrayList;
import java.util.List;

public class CompareResult {
    private ComparedNode rootNode;

    public CompareResult(ComparedNode rootNode) {
        this.rootNode = rootNode;
    }

    public ComparedNode getRootNode() {
        return this.rootNode;
    }

    public int getDifferingCount(ComparedNode node) {
        ArrayList list = new ArrayList();
        this.searchDifferingChild(node, list);
        return list.size();
    }

    private void searchDifferingChild(ComparedNode parent, List list) {
        ComparedNode child = null;
        if (parent.getChildCount() > 0) {
            int childcount = parent.getChildCount();
            for (int i = 0; i < childcount; ++i) {
                child = parent.getChild(i);
                if (child.hasDifferentValues()) {
                    list.add(child);
                }
                this.searchDifferingChild(child, list);
            }
        }
    }

    private void searchNextDifferingNode(ComparedNode parent, ComparedNode currentNode, SearchResult searchResult) {
        if (parent.equals(this.rootNode) && currentNode.equals(this.rootNode)) {
            searchResult.currentNodeReached = true;
        }
        if (parent.getChildCount() > 0) {
            int childcount = parent.getChildCount();
            for (int i = 0; i < childcount && searchResult.differingNode == null; ++i) {
                ComparedNode tmp = parent.getChild(i);
                if (tmp.equals(currentNode)) {
                    searchResult.currentNodeReached = true;
                } else if (searchResult.currentNodeReached && tmp.hasDifferentValues()) {
                    searchResult.differingNode = tmp;
                }
                if (searchResult.differingNode != null) continue;
                this.searchNextDifferingNode(tmp, currentNode, searchResult);
            }
        }
    }

    public ComparedNode getNextDifferingNode(ComparedNode node) {
        SearchResult searchResult = new SearchResult();
        this.searchNextDifferingNode(this.rootNode, node, searchResult);
        ComparedNode nextDifferingNode = searchResult.differingNode;
        if (nextDifferingNode == null) {
            nextDifferingNode = this.rootNode;
        }
        return nextDifferingNode;
    }

    private void searchPrevDifferingNode(ComparedNode parent, ComparedNode currentNode, SearchResult searchResult) {
        if (parent.getChildCount() > 0) {
            int childcount = parent.getChildCount();
            for (int i = 0; i < childcount && !searchResult.currentNodeReached; ++i) {
                ComparedNode tmp = parent.getChild(i);
                if (tmp.equals(currentNode)) {
                    searchResult.currentNodeReached = true;
                } else if (tmp.hasDifferentValues()) {
                    searchResult.differingNode = tmp;
                }
                if (searchResult.currentNodeReached) continue;
                this.searchPrevDifferingNode(tmp, currentNode, searchResult);
            }
        }
    }

    public ComparedNode getPrevDifferingNode(ComparedNode node) {
        SearchResult searchResult = new SearchResult();
        this.searchPrevDifferingNode(this.rootNode, node, searchResult);
        ComparedNode prev = searchResult.differingNode;
        if (prev == null) {
            prev = this.rootNode;
        }
        return prev;
    }

    private class SearchResult {
        ComparedNode differingNode = null;
        boolean currentNodeReached = false;

        private SearchResult() {
        }
    }
}

