/*
 * Decompiled with CFR 0.152.
 */
package de.statspez.pleditor.generator.codegen.js;

import de.statspez.pleditor.generator.codegen.java.StringHelper;
import de.statspez.pleditor.generator.codegen.js.CodegenContext;
import de.statspez.pleditor.generator.codegen.js.JavaScriptCodeGenerator;
import de.statspez.pleditor.generator.meta.MetaCustomFunktion;
import de.statspez.pleditor.generator.meta.generated.MetaPLFunktion;
import de.statspez.pleditor.generator.meta.generated.MetaPLParameter;
import java.util.Iterator;

public class ReferenceFunctionProgramCodeGenerator
extends JavaScriptCodeGenerator {
    public ReferenceFunctionProgramCodeGenerator(CodegenContext context) {
        this.setCodegenContext(context);
    }

    @Override
    public void visitPLFunktion(MetaPLFunktion funktion) {
        if (!"ref".equals(funktion.getArt())) {
            throw new IllegalStateException("Referenzfunktion erwartet.");
        }
        MetaCustomFunktion referenceFunction = (MetaCustomFunktion)funktion;
        String escapedFunctionName = StringHelper.getEscapedName(referenceFunction.getName());
        this.indentNewLine();
        this.print("function ");
        this.print("prg_");
        this.printContextAsPrefix();
        this.print(escapedFunctionName);
        this.print("(");
        this.print("ns");
        this.visitElements(referenceFunction.getParameter());
        this.print(")");
        this.openBlock();
        this.indentNewLine();
        this.print("var p = ns.substring(0, ns.lastIndexOf(\".\"));");
        this.indentNewLine();
        this.print("var t = getTopicName(p);");
        this.indentNewLine();
        this.print("if (t != null)");
        this.openBlock();
        this.indentNewLine();
        this.print("return topicFunctions[t + \"_");
        this.print(escapedFunctionName);
        this.print("\"](p");
        this.visitElements(referenceFunction.getParameter());
        this.print(");");
        this.closeBlock();
        this.indentNewLine();
        this.print("else");
        this.openBlock();
        this.indentNewLine();
        this.print("return topicFunctions[\"");
        this.print(escapedFunctionName);
        this.print("\"](");
        Iterator parameter = referenceFunction.getParameter();
        while (parameter.hasNext()) {
            MetaPLParameter aParam = (MetaPLParameter)parameter.next();
            this.print(StringHelper.getEscapedName(aParam.getName()));
            if (!parameter.hasNext()) continue;
            this.print(", ");
        }
        this.print(");");
        this.closeBlock();
        this.closeBlock();
    }

    @Override
    public void visitPLParameter(MetaPLParameter aParam) {
        this.print(", ");
        this.print(StringHelper.getEscapedName(aParam.getName()));
    }
}

