/*
 * Decompiled with CFR 0.152.
 */
package de.statspez.pleditor.generator.codegen.js;

import de.statspez.pleditor.generator.codegen.java.StringHelper;
import de.statspez.pleditor.generator.codegen.js.ClassificationCodeGenerator;
import de.statspez.pleditor.generator.codegen.js.CodegenContext;
import de.statspez.pleditor.generator.codegen.js.ErrorTextProgramCodeGenerator;
import de.statspez.pleditor.generator.codegen.js.FieldErrorTextFunctionGenerator;
import de.statspez.pleditor.generator.codegen.js.JavaScriptCodeGenerator;
import de.statspez.pleditor.generator.codegen.js.MehrfachantwortProgramCodeGenerator;
import de.statspez.pleditor.generator.codegen.js.ProgramCodeGenerator;
import de.statspez.pleditor.generator.codegen.js.ThemenbereichCodeGenerator;
import de.statspez.pleditor.generator.codegen.js.TopicNameFunctionGenerator;
import de.statspez.pleditor.generator.codegen.support.CodegenUtil;
import de.statspez.pleditor.generator.codegen.support.Scope;
import de.statspez.pleditor.generator.common.ElementMessageContext;
import de.statspez.pleditor.generator.meta.MetaCustomFunktion;
import de.statspez.pleditor.generator.meta.MetaCustomMerkmal;
import de.statspez.pleditor.generator.meta.MetaCustomPlausibilisierung;
import de.statspez.pleditor.generator.meta.MetaProgram;
import de.statspez.pleditor.generator.meta.generated.MetaAuspraegungsgruppe;
import de.statspez.pleditor.generator.meta.generated.MetaMerkmal;
import de.statspez.pleditor.generator.meta.generated.MetaPLAblauf;
import de.statspez.pleditor.generator.meta.generated.MetaPLFunktion;
import de.statspez.pleditor.generator.meta.generated.MetaPlausibilisierung;
import de.statspez.pleditor.generator.meta.generated.MetaThemenbereich;
import java.util.Iterator;

public class PlausiCodeGenerator
extends JavaScriptCodeGenerator {
    public synchronized void generate(CodegenContext context) {
        this.setCodegenContext(context);
        this.setOutput(context.getWriter());
        context.getPlausi().accept(this);
        this.flush();
        this.checkForErrors();
    }

    @Override
    public void visitPlausibilisierung(MetaPlausibilisierung plausi) {
        this.visitElements(plausi.getAuspraegungsgruppen());
        this.visitElements(plausi.getMerkmale());
        this.visitElements(plausi.getFunktionen());
        this.visitElements(plausi.getThemenbereiche());
        MetaCustomPlausibilisierung customPlausi = (MetaCustomPlausibilisierung)plausi;
        this.indentNewLine();
        this.print("function plausi(flow)");
        this.openBlock();
        this.indentNewLine();
        this.print("var ");
        this.print("e");
        this.print(" = new Array();");
        this.indentNewLine();
        Iterator iter = customPlausi.rootThemenbereich().getAblaeufe();
        while (iter.hasNext()) {
            MetaPLAblauf flow = (MetaPLAblauf)iter.next();
            this.print("if (flow == \"");
            this.print(StringHelper.getEscapedName(flow.getName()));
            this.print("\")");
            this.openBlock();
            flow.accept(this);
            this.closeBlock();
            if (!iter.hasNext()) continue;
            this.indentNewLine();
            this.print("else ");
        }
        if (customPlausi.standardAblauf() != null) {
            this.indentNewLine();
            this.print("else");
            this.openBlock();
            customPlausi.standardAblauf().accept(this);
            this.closeBlock();
        }
        this.indentNewLine();
        this.print("return ");
        this.print("e");
        this.print(";");
        this.closeBlock();
        FieldErrorTextFunctionGenerator fieldErrorTextFunctionGenerator = new FieldErrorTextFunctionGenerator();
        fieldErrorTextFunctionGenerator.setOutput(this.out);
        fieldErrorTextFunctionGenerator.setIndentLevel(this.indentLevel());
        fieldErrorTextFunctionGenerator.generate(this.context, FieldErrorTextFunctionGenerator.ErrorTextType.MESSAGE);
        fieldErrorTextFunctionGenerator.generate(this.context, FieldErrorTextFunctionGenerator.ErrorTextType.DESCRIPTION);
        fieldErrorTextFunctionGenerator.generate(this.context, FieldErrorTextFunctionGenerator.ErrorTextType.CORRECTION_ADVICE);
        TopicNameFunctionGenerator topicNameFunctionGenerator = new TopicNameFunctionGenerator();
        topicNameFunctionGenerator.setOutput(this.out);
        topicNameFunctionGenerator.setIndentLevel(this.indentLevel());
        topicNameFunctionGenerator.generate(this.context);
    }

    @Override
    public void visitThemenbereich(MetaThemenbereich themenbereich) {
        ThemenbereichCodeGenerator codeGen = new ThemenbereichCodeGenerator();
        codeGen.setOutput(this.out);
        codeGen.setIndentLevel(this.indentLevel());
        this.context.putContextInfo("contextKey", this.context.getContextNameFor(themenbereich));
        codeGen.generate(this.context, themenbereich, (Scope)this.context.getTopicScopes().get(themenbereich.getName()));
        this.context.putContextInfo("contextKey", null);
    }

    @Override
    public void visitMerkmal(MetaMerkmal anObject) {
        MetaCustomMerkmal merkmal = (MetaCustomMerkmal)anObject;
        ProgramCodeGenerator codeGen = new ProgramCodeGenerator();
        codeGen.setOutput(this.out);
        codeGen.setIndentLevel(this.indentLevel());
        codeGen.setErrorContext(new ElementMessageContext(5, merkmal.getId(), merkmal.getName()));
        this.context.putContextInfo("programPerformsPlausiKey", new Boolean(true));
        this.context.putContextInfo("programChecksFieldKey", new Boolean(true));
        codeGen.generate(this.context, merkmal.getMetaSpezifikation(), this.context.getPlausiScope());
        this.context.putContextInfo("programPerformsPlausiKey", null);
        this.context.putContextInfo("programChecksFieldKey", null);
        if (CodegenUtil.containsMehrfachantwortTbFieldForMerkmal(this.context.getPlausi(), merkmal)) {
            MehrfachantwortProgramCodeGenerator maCodeGen = new MehrfachantwortProgramCodeGenerator();
            maCodeGen.setOutput(this.out);
            maCodeGen.setIndentLevel(this.indentLevel());
            maCodeGen.generate(merkmal);
        }
        this.indentNewLine();
        this.print("function ");
        this.print("err_");
        this.print("Merkmal_");
        this.print(StringHelper.getEscapedName(merkmal.getName()));
        this.print("(");
        this.print("f");
        this.print(", ");
        this.print("n");
        this.print(")");
        this.openBlock();
        this.indentNewLine();
        this.print("var ");
        this.print("e");
        this.print(" = new PlausiError();");
        this.indentNewLine();
        this.print("e");
        this.print(".type = 1;");
        this.indentNewLine();
        this.print("e");
        this.print(".infoType = ");
        this.print("n");
        this.print(";");
        this.indentNewLine();
        this.print("e");
        this.print(".id = ");
        this.print("f");
        this.print(" + \"#");
        this.print(merkmal.getName());
        this.print("\";");
        String errorTextShort = this.context.getTextResource().getFehlertextKurz(merkmal);
        String errorTextLong = this.context.getTextResource().getFehlertextLang(merkmal);
        String correctionAdvice = this.context.getTextResource().getKorrekturhinweis(merkmal);
        MetaProgram errorTextShortProgram = this.context.getTextResource().getFehlertextKurzProgram(merkmal);
        MetaProgram errorTextLongProgram = this.context.getTextResource().getFehlertextLangProgram(merkmal);
        MetaProgram correctionAdviceProgram = this.context.getTextResource().getKorrekturhinweisProgram(merkmal);
        boolean fieldErrorTextesExists = CodegenUtil.containsFieldErrorTextesForMerkmal((MetaCustomPlausibilisierung)this.context.getPlausi(), merkmal);
        this.printErrorTextes("message", errorTextShort, errorTextShortProgram, fieldErrorTextesExists, "getFieldErrorMessage");
        this.printErrorTextes("description", errorTextLong, errorTextLongProgram, fieldErrorTextesExists, "getFieldErrorDescription");
        this.printErrorTextes("correctionAdvice", correctionAdvice, correctionAdviceProgram, fieldErrorTextesExists, "getFieldErrorCorrectionAdvice");
        this.indentNewLine();
        this.print("e");
        this.print(".field = ");
        this.print("f");
        this.print(";");
        this.indentNewLine();
        this.print("e");
        this.print(".fieldType = ");
        this.print(merkmal.getTyp());
        this.print(";");
        if (merkmal.getMaske() != null && merkmal.getMaske().length() > 0) {
            this.indentNewLine();
            this.print("e");
            this.print(".fieldMask = \"");
            this.print(StringHelper.getEscapedStringValue(merkmal.getMaske()));
            this.print("\";");
        }
        this.indentNewLine();
        this.print("e");
        this.print(".fieldLength = ");
        this.print(String.valueOf(merkmal.getLaenge()));
        this.print(";");
        String valueSpace = CodegenUtil.getValueSpaceAsString(merkmal);
        if (valueSpace != null && valueSpace.length() > 0) {
            this.indentNewLine();
            this.print("e");
            this.print(".fieldValueSpace = \"");
            this.print(StringHelper.getEscapedStringValue(valueSpace));
            this.print("\";");
        }
        this.indentNewLine();
        this.print("e");
        this.print(".referencedFields = referencedFields;");
        this.indentNewLine();
        this.print("referencedFields = null;");
        this.indentNewLine();
        this.print("return ");
        this.print("e");
        this.print(";");
        this.closeBlock();
    }

    private void printErrorTextes(String attribute, String text, MetaProgram program, boolean fieldErrorTextesExists, String fieldErrorTextFunction) {
        ErrorTextProgramCodeGenerator errorTextCodeGen = new ErrorTextProgramCodeGenerator();
        errorTextCodeGen.setOutput(this.out);
        errorTextCodeGen.setIndentLevel(this.indentLevel());
        if (fieldErrorTextesExists) {
            this.indentNewLine();
            this.print("var ");
            this.print(attribute);
            this.print(" = ");
            this.print(fieldErrorTextFunction);
            this.print("(");
            this.print("f");
            this.print(");");
        }
        this.indentNewLine();
        this.print("e");
        this.print(".");
        this.print(attribute);
        this.print(" = ");
        if (fieldErrorTextesExists) {
            this.print("(");
            this.print(attribute);
            this.print(" != null) ? ");
            this.print(attribute);
            this.print(" : ");
        }
        if (program != null) {
            errorTextCodeGen.generate(this.context, program, this.context.getPlausiScope());
        } else if (text != null) {
            this.print("\"");
            this.print(StringHelper.getEscapedStringValue(text));
            this.print("\"");
        } else {
            this.print("null");
        }
        this.print(";");
    }

    @Override
    public void visitAuspraegungsgruppe(MetaAuspraegungsgruppe anObject) {
        ClassificationCodeGenerator codeGen = new ClassificationCodeGenerator();
        codeGen.setOutput(this.out);
        codeGen.setIndentLevel(this.indentLevel());
        codeGen.generate(this.context, anObject);
    }

    @Override
    public void visitPLFunktion(MetaPLFunktion funktion) {
        MetaCustomFunktion f = (MetaCustomFunktion)funktion;
        this.indentNewLine();
        ProgramCodeGenerator prgGen = new ProgramCodeGenerator();
        prgGen.setOutput(this.out);
        prgGen.setIndentLevel(this.indentLevel());
        prgGen.setErrorContext(new ElementMessageContext(4, f.getId(), f.getName()));
        prgGen.generate(this.context, f.getMetaSpezifikation(), this.context.getPlausiScope());
    }

    @Override
    public void visitPLAblauf(MetaPLAblauf anObject) {
        this.indentNewLine();
        this.print("e");
        this.print(" = ");
        this.print("e");
        this.print(".concat(");
        this.print("prg_");
        this.print(StringHelper.getEscapedName(anObject.getName()));
        this.print("());");
    }
}

