/*
 * Decompiled with CFR 0.152.
 */
package de.statspez.pleditor.generator.codegen.js;

import de.statspez.pleditor.generator.codegen.java.StringHelper;
import de.statspez.pleditor.generator.codegen.js.CodegenContext;
import de.statspez.pleditor.generator.codegen.js.JavaScriptCodeGenerator;
import de.statspez.pleditor.generator.codegen.support.CodegenUtil;
import de.statspez.pleditor.generator.meta.MetaCustomPlausibilisierung;
import de.statspez.pleditor.generator.meta.MetaCustomThemenbereich;
import de.statspez.pleditor.generator.meta.generated.MetaMerkmal;
import de.statspez.pleditor.generator.meta.generated.MetaTBFeld;
import de.statspez.pleditor.generator.meta.generated.MetaThemenbereich;

public class FieldErrorTextFunctionGenerator
extends JavaScriptCodeGenerator {
    private static final boolean INCLUDE_SUBTOPICS = true;
    private static final boolean IGNORE_SUBTOPICS = false;
    private ErrorTextType errorTextType;
    private MetaThemenbereich currentTopic;
    private boolean firstTopicIfBlock;
    private boolean firstFieldIfBlock;

    public synchronized void generate(CodegenContext context, ErrorTextType errorTextType) {
        this.errorTextType = errorTextType;
        this.firstTopicIfBlock = true;
        this.setCodegenContext(context);
        this.indentNewLine();
        this.print("function getFieldError");
        switch (errorTextType) {
            case MESSAGE: {
                this.print("Message");
                break;
            }
            case DESCRIPTION: {
                this.print("Description");
                break;
            }
            case CORRECTION_ADVICE: {
                this.print("CorrectionAdvice");
            }
        }
        this.print("(f)");
        this.openBlock();
        MetaThemenbereich rootTopic = ((MetaCustomPlausibilisierung)context.getPlausi()).rootThemenbereich();
        if (this.containsFieldErrorText(rootTopic, true)) {
            this.indentNewLine();
            this.print("var t = getTopicName(f.substring(0, f.lastIndexOf(\".\")));");
            this.indentNewLine();
            this.print("var n = getFieldWithoutIndices(f.substring(f.lastIndexOf(\".\") + 1));");
            this.visitElements(context.getPlausi().getThemenbereiche());
        }
        this.indentNewLine();
        this.print("return null;");
        this.closeBlock();
        this.out.flush();
        this.checkForErrors();
    }

    @Override
    public void visitThemenbereich(MetaThemenbereich aTopic) {
        if (((MetaCustomThemenbereich)aTopic).referencedByErhebung() && this.containsFieldErrorText(aTopic, false)) {
            this.currentTopic = aTopic;
            this.indentNewLine();
            if (this.firstTopicIfBlock) {
                this.firstTopicIfBlock = false;
            } else {
                this.print("else ");
            }
            this.print("if (t == ");
            if (this.isRootTopic()) {
                this.print("null");
            } else {
                this.print("\"");
                this.print(StringHelper.getEscapedName(aTopic.getName()));
                this.print("\"");
            }
            this.print(")");
            this.openBlock();
            this.firstFieldIfBlock = true;
            this.visitElements(aTopic.getFelder());
            this.closeBlock();
        }
    }

    @Override
    public void visitTBFeld(MetaTBFeld aField) {
        if (aField.getKlasse() instanceof MetaMerkmal) {
            switch (this.errorTextType) {
                case MESSAGE: {
                    if (aField.getFehlertextKurz() == null || aField.getFehlertextKurz().length() <= 0) break;
                    this.printFieldErrorText(aField.getName(), "msg_");
                    break;
                }
                case DESCRIPTION: {
                    if (aField.getFehlertextLang() == null || aField.getFehlertextLang().length() <= 0) break;
                    this.printFieldErrorText(aField.getName(), "dsc_");
                    break;
                }
                case CORRECTION_ADVICE: {
                    if (aField.getKorrekturhinweis() == null || aField.getKorrekturhinweis().length() <= 0) break;
                    this.printFieldErrorText(aField.getName(), "adv_");
                }
            }
        }
    }

    private boolean isRootTopic() {
        return ((MetaCustomPlausibilisierung)this.context.getPlausi()).rootThemenbereich() == this.currentTopic;
    }

    private boolean containsFieldErrorText(MetaThemenbereich topic, boolean deepSearch) {
        switch (this.errorTextType) {
            case MESSAGE: {
                if (!CodegenUtil.containsFieldErrorTextShort(topic, deepSearch)) break;
                return true;
            }
            case DESCRIPTION: {
                if (!CodegenUtil.containsFieldErrorTextLong(topic, deepSearch)) break;
                return true;
            }
            case CORRECTION_ADVICE: {
                if (!CodegenUtil.containsFieldErrorCorrectionAdvice(topic, deepSearch)) break;
                return true;
            }
        }
        return false;
    }

    private void printFieldErrorText(String fieldName, String errorFunctionPrefix) {
        this.indentNewLine();
        if (this.firstFieldIfBlock) {
            this.firstFieldIfBlock = false;
        } else {
            this.print("else ");
        }
        this.print("if (n == \"");
        this.print(StringHelper.getEscapedStringValue(fieldName));
        this.print("\")");
        this.openBlock();
        this.indentNewLine();
        this.print("return ");
        this.print(errorFunctionPrefix);
        if (!this.isRootTopic()) {
            this.print(StringHelper.getEscapedName(this.currentTopic.getName()));
            this.print("_");
        }
        this.print(StringHelper.getEscapedName(fieldName));
        this.print("(f);");
        this.closeBlock();
    }

    public static enum ErrorTextType {
        MESSAGE,
        DESCRIPTION,
        CORRECTION_ADVICE;

    }
}

