/*
 * Decompiled with CFR 0.152.
 */
package de.statspez.pleditor.generator.codegen.java.mapping;

import de.statspez.pleditor.generator.codegen.java.CodegenContext;
import de.statspez.pleditor.generator.codegen.java.StringHelper;
import de.statspez.pleditor.generator.codegen.java.mapping.util.AttributesGenerator;
import de.statspez.pleditor.generator.codegen.java.mapping.util.ConstructorGenerator;
import de.statspez.pleditor.generator.codegen.java.mapping.util.MappingDataGenerator;
import de.statspez.pleditor.generator.codegen.java.mapping.util.RAWAttributesGenererator;
import de.statspez.pleditor.generator.codegen.java.mapping.util.RAWConstructorGenerator;
import de.statspez.pleditor.generator.meta.AbstractElementVisitor;
import de.statspez.pleditor.generator.meta.MetaCustomRawFieldGroup;
import de.statspez.pleditor.generator.meta.generated.MetaRawDataSet;
import de.statspez.pleditor.generator.meta.generated.MetaRawField;
import de.statspez.pleditor.generator.meta.generated.MetaRawFieldGroup;
import de.statspez.pleditor.generator.meta.generated.MetaRawSet;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.HashSet;
import java.util.Set;

public class MappingRAWDataGenerator
extends MappingDataGenerator {
    public static final String PREFIX = "RAW_";
    private CodegenContext contex;
    private Set generatedClasses = new HashSet();
    private String className;

    public MappingRAWDataGenerator(CodegenContext contex) {
        this.className = PREFIX + StringHelper.getEscapedName(contex.getPlausiClassName());
        this.contex = contex;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void generate(MetaRawDataSet anObject) {
        String filename = this.className + ".java";
        Writer writer = this.contex.createWriter(filename);
        try {
            this.setOutput(writer);
            this.createImports(this.contex.getPlausiPackage());
            this.createClassNotOpen(this.className, "TopicField", anObject, false);
            this.visitElements(anObject.getListOfRawSet());
            this.visitElements(anObject.getListOfRawField());
            this.closeBlock();
            this.flush();
        }
        finally {
            this.contex.destroyWriter(filename, writer);
        }
    }

    @Override
    public void visitRawFieldGroup(MetaRawFieldGroup anObject) {
        if (!this.generatedClasses.contains(this.structurePrefix + anObject.getName())) {
            this.generatedClasses.add(this.structurePrefix + anObject.getName());
            this.visitElements(anObject.getListOfRawField());
            String name = this.structurePrefix + StringHelper.getEscapedName(anObject.getName());
            this.createClass(anObject, name, "TopicField");
        }
    }

    @Override
    public void visitRawSet(MetaRawSet anObject) {
        if (!this.generatedClasses.contains(anObject.getName())) {
            this.generatedClasses.add(anObject.getName());
            String name = StringHelper.getEscapedName(anObject.getName());
            this.structurePrefix = name + "_";
            this.visitElements(anObject.getListOfRawField());
            this.createClass(anObject, name, "TopicField");
            this.structurePrefix = "";
        }
    }

    @Override
    protected AttributesGenerator attributesGenerator(PrintWriter out) {
        return new RAWAttributesGenererator(out);
    }

    @Override
    protected ConstructorGenerator constructorGenerator(PrintWriter out) {
        return new RAWConstructorGenerator(out);
    }

    @Override
    protected String getPrefix() {
        return PREFIX;
    }

    @Override
    protected void generateSpecialMethods(Object rawObject) {
        if (rawObject instanceof MetaRawDataSet) {
            MetaRawDataSet raw = (MetaRawDataSet)rawObject;
            this.defineMethod("public", "StructureDescriptor", "getStructure", "");
            this.indentNewLine();
            this.out.print("return StructureDescriptor.create(new StructureDescriptor[]");
            this.openBlock();
            raw.accept(new AbstractElementVisitor(){

                @Override
                public void visitRawDataSet(MetaRawDataSet raw) {
                    this.visitElements(raw.getListOfRawField());
                    this.visitElements(raw.getListOfRawSet());
                }

                @Override
                public void visitRawFieldGroup(MetaRawFieldGroup rawFieldGroup) {
                    MappingRAWDataGenerator.this.indentNewLine();
                    MappingRAWDataGenerator.this.out.print("StructureDescriptor.fieldGroup(\"" + rawFieldGroup.getName() + "\", ");
                    int[] dimensions = ((MetaCustomRawFieldGroup)rawFieldGroup).dimensions();
                    if (dimensions != null && dimensions.length > 0) {
                        MappingRAWDataGenerator.this.out.print("new int[] {");
                        for (int i = 0; i < dimensions.length; ++i) {
                            if (i > 0) {
                                MappingRAWDataGenerator.this.out.print(", ");
                            }
                            MappingRAWDataGenerator.this.out.print(dimensions[i]);
                        }
                        MappingRAWDataGenerator.this.out.print("}, ");
                    }
                    MappingRAWDataGenerator.this.out.print("new StructureDescriptor[]");
                    MappingRAWDataGenerator.this.openBlock();
                    this.visitElements(rawFieldGroup.getListOfRawField());
                    MappingRAWDataGenerator.this.closeBlock();
                    MappingRAWDataGenerator.this.out.print("),");
                }

                @Override
                public void visitRawField(MetaRawField rawField) {
                    MappingRAWDataGenerator.this.indentNewLine();
                    MappingRAWDataGenerator.this.out.print("StructureDescriptor.field(\"" + rawField.getName() + "\"),");
                }

                @Override
                public void visitRawSet(MetaRawSet rawSet) {
                    MappingRAWDataGenerator.this.indentNewLine();
                    MappingRAWDataGenerator.this.out.print("StructureDescriptor.record(\"" + rawSet.getName() + "\", new StructureDescriptor[]");
                    MappingRAWDataGenerator.this.openBlock();
                    this.visitElements(rawSet.getListOfRawField());
                    MappingRAWDataGenerator.this.closeBlock();
                    MappingRAWDataGenerator.this.out.print("),");
                }
            });
            this.closeBlock();
            this.out.print(");");
            this.closeBlock();
        }
    }
}

