/*
 * Decompiled with CFR 0.152.
 */
package de.statspez.pleditor.generator.codegen.java;

import de.statspez.pleditor.generator.codegen.java.StringHelper;
import de.statspez.pleditor.generator.codegen.support.AbstractCodeGenerator;
import de.statspez.pleditor.generator.common.ElementMessageContext;
import de.statspez.pleditor.generator.common.MessageContextInterface;
import java.util.List;

public class JavaCodeGenerator
extends AbstractCodeGenerator {
    protected void startNewSection(MessageContextInterface context) {
        String section = null;
        if (context != null) {
            section = context.toString();
        }
        this.startNewSection(section, this.isPruefContext(context));
    }

    protected void startNewSection(String section) {
        this.startNewSection(section, false);
    }

    protected void startNewSection(String section, boolean isPruefContext) {
        if (section == null) {
            section = "??";
        }
        this.indentNewLine();
        if (isPruefContext) {
            this.out.print("context.startNewPruefSection(\"" + section + "\");");
        } else {
            this.out.print("context.startNewSection(\"" + section + "\");");
        }
    }

    protected boolean isPruefContext(MessageContextInterface context) {
        ElementMessageContext elementContext;
        boolean erg = false;
        if (context != null && context instanceof ElementMessageContext && ((elementContext = (ElementMessageContext)context).getElementType() == 1 || elementContext.getElementType() == 5)) {
            erg = true;
        }
        return erg;
    }

    protected void leaveCurrentSection() {
        this.indentNewLine();
        this.out.print("context.leaveCurrentSection();");
    }

    protected void openBlock() {
        this.indentNewLine();
        this.out.print("{");
        this.increaseIndentLevel();
    }

    protected void closeBlock() {
        this.decreaseIndentLevel();
        this.indentNewLine();
        this.out.print("}");
    }

    protected void defineMethod(String scope, String rtype, String method, String params) {
        this.indentNewLine();
        this.out.print(scope);
        if (rtype != null && rtype.length() > 0) {
            this.out.print(" ");
            this.out.print(rtype);
        }
        this.out.print(" ");
        this.out.print(StringHelper.getEscapedName(method));
        this.out.print("(");
        this.out.print(params);
        this.out.print(")");
        this.openBlock();
    }

    protected void endMethodDefinition() {
        this.closeBlock();
    }

    protected void defineClass(String classname, String scope, String baseclass) {
        this.defineClass(classname, scope, baseclass, null);
    }

    protected void defineClass(String classname, String scope, String baseclass, List<String> interfaces) {
        this.indentNewLine();
        this.out.print(scope);
        this.out.print(" class ");
        this.out.print(classname);
        if (baseclass != null) {
            this.out.print(" extends ");
            this.out.print(baseclass);
        }
        if (interfaces != null && !interfaces.isEmpty()) {
            this.out.print(" implements ");
            boolean first = true;
            for (String ifcName : interfaces) {
                if (first) {
                    first = false;
                } else {
                    this.out.print(", ");
                }
                this.out.print(ifcName);
            }
        }
        this.openBlock();
    }

    protected void endClassDefinition() {
        this.closeBlock();
    }

    protected void defineInterface(String interfaceName) {
        this.indentNewLine();
        this.out.print("public interface ");
        this.out.print(interfaceName);
        this.openBlock();
    }

    protected void endInterfaceDefinition() {
        this.closeBlock();
    }

    protected void createArrayDimensions(int[] dimensions) {
        this.out.print("new int[]{");
        for (int i = 0; i < dimensions.length; ++i) {
            this.out.print(Integer.toString(dimensions[i]));
            if (i >= dimensions.length - 1) continue;
            this.out.print(", ");
        }
        this.out.print("}");
    }

    protected void iterateArray(String template, int[] dimensions) {
        int i;
        StringBuffer elementIndex = new StringBuffer("");
        char loopIndex = '`';
        for (int i2 = 0; i2 < dimensions.length; ++i2) {
            this.indentNewLine();
            loopIndex = (char)(loopIndex + 1);
            this.out.print("for (int ");
            this.out.print(loopIndex);
            this.out.print(" = 0; ");
            this.out.print(loopIndex);
            this.out.print(" < ");
            this.out.print(Integer.toString(dimensions[i2]));
            this.out.print("; ");
            this.out.print(loopIndex);
            this.out.print("++)");
            this.openBlock();
            elementIndex.append("[");
            elementIndex.append(loopIndex);
            elementIndex.append("]");
        }
        String processedTemplate = template;
        if (template.indexOf("@@indexarray") != -1) {
            this.indentNewLine();
            this.out.print("int indexArray[] = {");
            for (i = 0; i < dimensions.length; ++i) {
                if (i > 0) {
                    this.out.print(",");
                }
                this.out.print((char)(97 + i));
            }
            this.out.print("};");
            processedTemplate = processedTemplate.replaceAll("@@indexarray", "indexArray");
        }
        processedTemplate = processedTemplate.replaceAll("@@index", elementIndex.toString());
        this.indentNewLine();
        this.out.print(processedTemplate);
        for (i = 0; i < dimensions.length; ++i) {
            this.closeBlock();
        }
    }
}

