/*
 * Decompiled with CFR 0.152.
 */
package de.statspez.pleditor.generator.codegen.java;

import de.statspez.pleditor.generator.codegen.java.AbstractCodegenContext;
import de.statspez.pleditor.generator.meta.generated.MetaPlausibilisierung;
import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;

public class DefaultCodegenContext
extends AbstractCodegenContext {
    private final String outputDir;
    private final boolean createPackageDirectories;
    private final Charset charset;
    private final List generatedJavaFiles;

    public DefaultCodegenContext(MetaPlausibilisierung plausi, String outputDir) {
        this(plausi, outputDir, true, null);
    }

    public DefaultCodegenContext(MetaPlausibilisierung plausi, String outputDir, Charset charset) {
        this(plausi, outputDir, true, charset);
    }

    public DefaultCodegenContext(MetaPlausibilisierung plausi, String outputDir, boolean createPackageDirectories) {
        this(plausi, outputDir, createPackageDirectories, null);
    }

    public DefaultCodegenContext(MetaPlausibilisierung plausi, String outputDir, boolean createPackageDirectories, Charset charset) {
        super(plausi);
        this.outputDir = outputDir;
        this.createPackageDirectories = createPackageDirectories;
        this.charset = charset;
        this.generatedJavaFiles = new ArrayList();
    }

    public File[] getGeneratedJavaFiles() {
        return this.generatedJavaFiles.toArray(new File[this.generatedJavaFiles.size()]);
    }

    private File getCreatableFile(String filename) {
        String plausiPackage;
        StringBuffer absoluteFilename = new StringBuffer();
        if (this.outputDir != null && this.outputDir.length() > 0) {
            absoluteFilename.append(this.outputDir);
            if (!this.outputDir.endsWith("\\") && !this.outputDir.endsWith("/")) {
                absoluteFilename.append(System.getProperty("file.separator"));
            }
        }
        if (this.createPackageDirectories && (plausiPackage = this.getPlausiPackage()) != null && plausiPackage.length() > 0) {
            String[] packages = plausiPackage.split("\\.");
            for (int i = 0; i < packages.length; ++i) {
                absoluteFilename.append(packages[i]);
                absoluteFilename.append(System.getProperty("file.separator"));
            }
        }
        absoluteFilename.append(filename);
        File file = new File(absoluteFilename.toString());
        if (!file.getParentFile().exists()) {
            file.getParentFile().mkdirs();
        }
        if (file.getName().toLowerCase().endsWith(".java")) {
            this.generatedJavaFiles.add(file);
        }
        return file;
    }

    @Override
    public Writer createWriter(String filename) {
        try {
            FileOutputStream out = new FileOutputStream(this.getCreatableFile(filename));
            if (this.charset != null) {
                return new BufferedWriter(new OutputStreamWriter((OutputStream)out, this.charset));
            }
            return new BufferedWriter(new OutputStreamWriter(out));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void destroyWriter(String filename, Writer writer) {
        try {
            writer.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public OutputStream createOutputStream(String filename) {
        try {
            return new BufferedOutputStream(new FileOutputStream(this.getCreatableFile(filename)));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void destroyOutputStream(String filename, OutputStream out) {
        try {
            out.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

