/*
 * Decompiled with CFR 0.152.
 */
package de.statspez.pleditor.generator.codegen.html;

import de.statspez.pleditor.generator.codegen.html.HtmlGeneratorUtil;
import de.statspez.pleditor.generator.codegen.html.HtmlProgramCodeGenerator;
import de.statspez.pleditor.generator.codegen.html.Precondition;
import de.statspez.pleditor.generator.meta.AbstractElementVisitor;
import de.statspez.pleditor.generator.meta.MetaConditionalStatement;
import de.statspez.pleditor.generator.meta.MetaCustomAblauf;
import de.statspez.pleditor.generator.meta.MetaFactor;
import de.statspez.pleditor.generator.meta.MetaForEachCheck;
import de.statspez.pleditor.generator.meta.MetaForEachLoop;
import de.statspez.pleditor.generator.meta.MetaForNextLoop;
import de.statspez.pleditor.generator.meta.MetaHierarchicalForEachLoop;
import de.statspez.pleditor.generator.meta.MetaWhileLoop;
import de.werum.prosi.common.xml.XmlWriter;
import java.io.IOException;
import java.util.Collection;

public class PreconditionWriter
extends AbstractElementVisitor {
    private HtmlProgramCodeGenerator htmlProgramCodeGenerator = new HtmlProgramCodeGenerator();
    private XmlWriter out;
    private Precondition currentPrecondition;

    public void writePreconditions(XmlWriter out, Collection<Precondition> preconditions) throws IOException {
        this.out = out;
        this.writeStartPreconditions(out, preconditions);
        this.writeEndPreconditions(out, preconditions);
    }

    public void writeCodeWithPreconditions(XmlWriter out, Collection<Precondition> preconditions, String code) throws IOException {
        this.out = out;
        this.writeStartPreconditions(out, preconditions);
        out.startTag("div").writeAttribute("class", "code");
        this.htmlProgramCodeGenerator.generateHtml(code, out);
        out.endTag();
        this.writeEndPreconditions(out, preconditions);
    }

    public static void writeAblaufAsTitle(XmlWriter out, MetaCustomAblauf ablauf) throws IOException {
        out.startTag("div");
        out.writeAttribute("class", "code-title");
        out.startTag("span").writeAttribute("class", "pl-obj ablauf");
        out.write("Ablauf ");
        out.write(ablauf.getThemenbereich().getName());
        out.write(".").write(ablauf.getName());
        out.endTag();
        out.endTag();
    }

    @Override
    public void visitWhileLoop(MetaWhileLoop aStatement) {
        MetaFactor condition = aStatement.condition();
        this.writeCondition(condition.startColumn(), condition.startLine(), condition.endColumn(), condition.endLine());
    }

    @Override
    public void visitForNextLoop(MetaForNextLoop aStatement) {
        if (aStatement.stepExpression().startColumn() > 0) {
            this.writeCondition(aStatement.startColumn(), aStatement.startLine(), aStatement.stepExpression().endColumn(), aStatement.stepExpression().endLine());
        } else {
            this.writeCondition(aStatement.startColumn(), aStatement.startLine(), aStatement.endCondition().endColumn(), aStatement.endCondition().endLine());
        }
    }

    @Override
    public void visitForEachLoop(MetaForEachLoop aStatement) {
        this.writeCondition(aStatement.startColumn(), aStatement.startLine(), aStatement.value().endColumn(), aStatement.value().endLine());
    }

    @Override
    public void visitForEachCheck(MetaForEachCheck aStatement) {
        this.writeCondition(aStatement.startColumn(), aStatement.startLine(), aStatement.endColumn(), aStatement.endLine());
    }

    @Override
    public void visitHierarchicalForEachLoop(MetaHierarchicalForEachLoop aStatement) {
        this.writeCondition(aStatement.startColumn(), aStatement.startLine(), aStatement.value().endColumn(), aStatement.value().startLine());
    }

    @Override
    public void visitConditionalStatement(MetaConditionalStatement aStatement) {
        this.writeCondition(aStatement.startColumn(), aStatement.startLine(), aStatement.getThenLocation().getEndColumn(), aStatement.getThenLocation().getEndLine());
    }

    private void writeStartPreconditions(XmlWriter out, Collection<Precondition> preconditions) throws IOException {
        MetaCustomAblauf ablauf = null;
        for (Precondition precondition : preconditions) {
            if (ablauf == null || ablauf != precondition.getAblauf()) {
                ablauf = precondition.getAblauf();
                PreconditionWriter.writeAblaufAsTitle(out, ablauf);
            }
            out.startTag("div").writeAttribute("class", "code");
            this.currentPrecondition = precondition;
            precondition.getStatement().accept(this);
        }
    }

    private void writeEndPreconditions(XmlWriter out, Collection<Precondition> preconditions) throws IOException {
        for (int i = 0; i < preconditions.size(); ++i) {
            out.endTag();
        }
    }

    private void writeCondition(int startColumn, int startLine, int endColumn, int endLine) {
        String code = HtmlGeneratorUtil.getCodeSegment(this.currentPrecondition.getAblaufSpezifikation(), startColumn, startLine, endColumn, endLine);
        if (this.currentPrecondition.isElseCase()) {
            code = code + "\n   \"...\"\nSONST";
        }
        try {
            this.htmlProgramCodeGenerator.generateHtml(code.toString(), this.out);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

