/*
 * Decompiled with CFR 0.152.
 */
package de.statspez.pleditor.generator.codegen.doku;

import de.statspez.pleditor.generator.codegen.doku.DokuElement;
import de.statspez.pleditor.generator.codegen.doku.Settings;
import de.statspez.pleditor.generator.codegen.support.AbstractCodeGenerator;
import de.statspez.pleditor.generator.meta.MetaCustomMerkmal;
import de.statspez.pleditor.generator.meta.generated.MetaStatspezObjekt;
import java.util.Hashtable;
import java.util.List;
import java.util.ListIterator;

public class XMLCodeGenerator
extends AbstractCodeGenerator {
    private static final String NAME_ATTR = "name";
    private static final String ID_ATTR = "id";
    private static final String TYPE_ATTR = "type";
    private static final String ADDON_ATTR = "name-add-on";
    private boolean escapeCSV = false;

    protected void appendBlock(String blockName, long blockValue) {
        this.indentNewLine();
        this.out.print("<" + blockName + ">" + blockValue + "</" + blockName + ">");
    }

    protected void appendBlock(String blockName, String blockValue) {
        this.indentNewLine();
        this.out.print("<" + blockName + ">" + this.escapeString(blockValue, this.escapeCSV) + "</" + blockName + ">");
    }

    protected void appendCount(int count) {
        this.indentNewLine();
        this.out.print("<doc:count>" + count + "</" + "doc:count" + ">");
    }

    protected void appendCount(String outerBlockName, int count) {
        this.indentNewLine();
        this.out.print("<" + outerBlockName + ">");
        this.increaseIndentLevel();
        this.indentNewLine();
        this.out.print("<doc:count>" + count + "</" + "doc:count" + ">");
        this.decreaseIndentLevel();
        this.indentNewLine();
        this.out.print("</" + outerBlockName + ">");
    }

    protected void appendElementWithDescriptionList(String outerBlockName, String type, List elements) {
        this.indentNewLine();
        this.out.print("<" + outerBlockName + ">");
        this.increaseIndentLevel();
        ListIterator it = elements.listIterator();
        while (it.hasNext()) {
            DokuElement de = (DokuElement)it.next();
            MetaStatspezObjekt mso = (MetaStatspezObjekt)de.getElement();
            this.beginElementBlock(de.getName(), de.getId(), type, de.getZusatz());
            this.indentNewLine();
            this.out.print("<doc:description>");
            this.out.print(this.escapeString(mso.getBeschreibung(), this.escapeCSV));
            this.out.print("</doc:description>");
            this.endElementBlock();
        }
        this.decreaseIndentLevel();
        this.indentNewLine();
        this.out.print("</" + outerBlockName + ">");
    }

    protected void appendEmptyElement(String elementName, String elementId, String elementType, String zusatz) {
        this.indentNewLine();
        this.out.print("<doc:element ");
        this.out.print("name=\"" + this.escapeString(elementName, this.escapeCSV) + "\" ");
        this.out.print("id=\"" + this.escapeString(elementId, this.escapeCSV) + "\" ");
        this.out.print("type=\"" + this.escapeString(elementType, this.escapeCSV) + "\" ");
        this.out.print("name-add-on=\"" + this.escapeString(zusatz, this.escapeCSV) + "\"");
        this.out.print("/>");
    }

    protected void appendList(String outerBlockName, String typeName, List elementList) {
        this.beginBlock(outerBlockName);
        if (elementList != null) {
            ListIterator it = elementList.listIterator();
            while (it.hasNext()) {
                DokuElement de = (DokuElement)it.next();
                if (de.getElement() instanceof MetaCustomMerkmal) {
                    MetaCustomMerkmal mcm = (MetaCustomMerkmal)de.getElement();
                    this.beginElementBlock(de.getName(), de.getId(), typeName, de.getZusatz());
                    this.appendBlock("doc:statisticVariableType", Settings.FELD_TYP[mcm.getTyp() - 1]);
                    this.appendBlock("doc:length", mcm.getLaenge());
                    this.endElementBlock();
                    continue;
                }
                this.appendEmptyElement(de.getName(), de.getId(), typeName, de.getZusatz());
            }
        }
        this.endBlock(outerBlockName);
    }

    protected void appendValueList(String outerBlockName, String type, String valueName, List elements, Hashtable values) {
        this.indentNewLine();
        this.out.print("<" + outerBlockName + ">");
        this.increaseIndentLevel();
        ListIterator it = elements.listIterator();
        while (it.hasNext()) {
            DokuElement de = (DokuElement)it.next();
            String curVal = (String)values.get(de.getId());
            if (curVal == null || curVal.length() <= 0) continue;
            this.beginElementBlock(de.getName(), de.getId(), type, de.getZusatz());
            this.indentNewLine();
            this.out.print("<" + valueName + ">");
            this.out.print(this.escapeString(curVal, this.escapeCSV));
            this.out.print("</" + valueName + ">");
            this.endElementBlock();
        }
        this.decreaseIndentLevel();
        this.indentNewLine();
        this.out.print("</" + outerBlockName + ">");
    }

    protected void beginBlock(String blockName) {
        this.indentNewLine();
        this.out.print("<" + blockName + ">");
        this.increaseIndentLevel();
    }

    protected void beginDoc() {
        this.out.print("<?xml");
        this.out.print(" version=\"1.0\"");
        this.out.print(" encoding=\"ISO-8859-1\"");
        this.out.print(" ?>");
        this.increaseIndentLevel();
        this.beginBlock("doc:documentation xmlns:doc=\"http://www.werum.de/pl-editor\"");
    }

    protected void beginElementBlock(String elementName, String elementTyp) {
        this.indentNewLine();
        this.out.print("<doc:element");
        this.out.print(" name=\"" + this.escapeString(elementName, this.escapeCSV) + "\"");
        this.out.print(" type=\"" + this.escapeString(elementTyp, this.escapeCSV) + "\"");
        this.out.print(">");
        this.increaseIndentLevel();
    }

    protected void beginElementBlock(String elementName, String elementId, String elementTyp, String zusatz) {
        this.indentNewLine();
        this.out.print("<doc:element");
        this.out.print(" name=\"" + this.escapeString(elementName, this.escapeCSV) + "\"");
        this.out.print(" id=\"" + this.escapeString(elementId, this.escapeCSV) + "\"");
        this.out.print(" type=\"" + this.escapeString(elementTyp, this.escapeCSV) + "\"");
        this.out.print(" name-add-on=\"" + this.escapeString(zusatz, this.escapeCSV));
        this.out.print("\">");
        this.increaseIndentLevel();
    }

    protected void endBlock(String blockName) {
        this.decreaseIndentLevel();
        this.indentNewLine();
        this.out.print("</" + blockName + ">");
    }

    protected void endDoc() {
        this.endBlock("doc:documentation");
    }

    protected void endElementBlock() {
        this.endBlock("doc:element");
    }

    private String nullAus(String str) {
        return str != null ? str : "";
    }

    protected String escapeString(String _inputString, boolean verdoppleAnfZ) {
        String erg = this.nullAus(_inputString).trim();
        if (erg.length() > 0 && (erg.indexOf(38) >= 0 || erg.indexOf(60) >= 0 || erg.indexOf(62) >= 0 || erg.indexOf(35) >= 0 || erg.indexOf(34) >= 0)) {
            StringBuffer buffer = new StringBuffer(erg.length() + 20);
            for (int i = 0; i < erg.length(); ++i) {
                if (erg.charAt(i) == '&') {
                    buffer.append("&amp;");
                    continue;
                }
                if (erg.charAt(i) == '<') {
                    buffer.append("&lt;");
                    continue;
                }
                if (erg.charAt(i) == '>') {
                    buffer.append("&gt;");
                    continue;
                }
                if (erg.charAt(i) == '#') {
                    buffer.append("&#35;");
                    continue;
                }
                if (erg.charAt(i) == '\"') {
                    buffer.append("&#34;");
                    if (!verdoppleAnfZ) continue;
                    buffer.append("&#34;");
                    continue;
                }
                buffer.append(erg.charAt(i));
            }
            erg = buffer.toString();
        }
        return erg;
    }

    public boolean isEscapeCSV() {
        return this.escapeCSV;
    }

    public void setEscapeCSV(boolean escapeCSV) {
        this.escapeCSV = escapeCSV;
    }
}

