/*
 * Decompiled with CFR 0.152.
 */
package de.statspez.pleditor.generator.codegen.cpp;

import de.statspez.pleditor.generator.codegen.cpp.CppErrorTextProgramCodeGenerator;
import de.statspez.pleditor.generator.codegen.cpp.CppExternalProgramCodeGenerator;
import de.statspez.pleditor.generator.codegen.cpp.CppPlausiElementCodeGenerator;
import de.statspez.pleditor.generator.codegen.cpp.CppProgramCodeGenerator;
import de.statspez.pleditor.generator.codegen.cpp.CppReferenceFunctionProgramCodeGenerator;
import de.statspez.pleditor.generator.codegen.cpp.CppSettings;
import de.statspez.pleditor.generator.codegen.cpp.CppThemenbereichParentInterfaceGenerator;
import de.statspez.pleditor.generator.codegen.java.StringHelper;
import de.statspez.pleditor.generator.codegen.support.CodegenUtil;
import de.statspez.pleditor.generator.codegen.support.NamespaceHelper;
import de.statspez.pleditor.generator.codegen.support.Scope;
import de.statspez.pleditor.generator.codegen.support.SymbolDescriptor;
import de.statspez.pleditor.generator.codegen.support.TextResource;
import de.statspez.pleditor.generator.common.ElementMessageContext;
import de.statspez.pleditor.generator.meta.MetaCustomAblauf;
import de.statspez.pleditor.generator.meta.MetaCustomFunktion;
import de.statspez.pleditor.generator.meta.MetaCustomInitwert;
import de.statspez.pleditor.generator.meta.MetaCustomPlausibilisierung;
import de.statspez.pleditor.generator.meta.MetaCustomPruefung;
import de.statspez.pleditor.generator.meta.MetaCustomTBFeld;
import de.statspez.pleditor.generator.meta.MetaCustomThemenbereich;
import de.statspez.pleditor.generator.meta.MetaIdentifier;
import de.statspez.pleditor.generator.meta.MetaProgram;
import de.statspez.pleditor.generator.meta.generated.MetaMerkmal;
import de.statspez.pleditor.generator.meta.generated.MetaPLAblauf;
import de.statspez.pleditor.generator.meta.generated.MetaPLFunktion;
import de.statspez.pleditor.generator.meta.generated.MetaPLInitwert;
import de.statspez.pleditor.generator.meta.generated.MetaPLMaterial;
import de.statspez.pleditor.generator.meta.generated.MetaPLPruefung;
import de.statspez.pleditor.generator.meta.generated.MetaPLVariable;
import de.statspez.pleditor.generator.meta.generated.MetaStatspezObjekt;
import de.statspez.pleditor.generator.meta.generated.MetaTBFeld;
import de.statspez.pleditor.generator.meta.generated.MetaTBMaterialReferenz;
import de.statspez.pleditor.generator.meta.generated.MetaThemenbereich;
import de.statspez.pleditor.generator.parser.Helper;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class CppThemenbereichCodeGenerator
extends CppPlausiElementCodeGenerator {
    private Scope scope = null;
    private TextResource textResource = null;
    private MetaCustomPlausibilisierung plausi = null;

    public synchronized void generate(MetaThemenbereich aTb, Scope tbScope, MetaCustomPlausibilisierung plausi) {
        this.scope = tbScope;
        this.plausi = plausi;
        aTb.accept(this);
        this.checkForErrors();
        this.out.flush();
    }

    public void setTextResource(TextResource textResource) {
        this.textResource = textResource;
    }

    @Override
    public void visitThemenbereich(MetaThemenbereich tb) {
        if (((MetaCustomThemenbereich)tb).hasReferenceFunctions()) {
            CppThemenbereichParentInterfaceGenerator tbParentIfcGenerator = new CppThemenbereichParentInterfaceGenerator();
            tbParentIfcGenerator.setOutput(this.out);
            tbParentIfcGenerator.setIndentLevel(this.indentLevel());
            tb.accept(tbParentIfcGenerator);
            this.newLine();
        }
        List<MetaCustomThemenbereich> subTbsWithReferenceFunctions = CodegenUtil.getSubTbsWithReferenceFunctions((MetaCustomThemenbereich)tb);
        ArrayList<String> tbClassInterfaces = new ArrayList<String>();
        for (MetaCustomThemenbereich subTb : subTbsWithReferenceFunctions) {
            String ifcName = CppThemenbereichCodeGenerator.getParentInterfaceNameFor(subTb);
            tbClassInterfaces.add(ifcName);
        }
        this.defineClass(this.getTbClass(tb), "Topic", tbClassInterfaces);
        this.decreaseIndentLevel();
        this.indentNewLine();
        this.print("public:");
        this.increaseIndentLevel();
        this.visitElements(tb.getFelder());
        this.visitElements(tb.getVariablen());
        this.visitElements(tb.getMaterialreferenzen());
        this.indentNewLine();
        this.createTbConstructor(tb);
        this.createTbDestructor(tb);
        this.createInitMethod(tb);
        this.indentNewLine();
        this.createGetInstanceMethod(tb);
        if (((MetaCustomThemenbereich)tb).referencedByErhebung()) {
            this.visitElements(tb.getAblaeufe());
            this.visitElements(tb.getPruefungen());
            this.visitElements(tb.getFunktionen());
        }
        this.createFieldErrorTextesMethods(tb);
        this.indentNewLine();
        this.decreaseIndentLevel();
        this.indentNewLine();
        this.print("private:");
        this.increaseIndentLevel();
        this.visitElements(tb.getInitialisierungswerte());
        this.indentNewLine();
        this.print("Plausi");
        this.print("* plausi;");
        this.endClassDefinition();
    }

    protected static String getParentInterfaceNameFor(MetaThemenbereich tb) {
        String tbName = tb.getName();
        String parentIfcName = "TB_P_" + StringHelper.getEscapedName(tbName);
        return parentIfcName;
    }

    @Override
    public void visitTBFeld(MetaTBFeld aFeld) {
        MetaCustomTBFeld feld = (MetaCustomTBFeld)aFeld;
        this.indentNewLine();
        String type = null;
        if (feld.getKlasse() instanceof MetaMerkmal) {
            type = aFeld.getListe() ? "FieldArray" : "Field";
        } else if (feld.getKlasse() instanceof MetaThemenbereich) {
            type = aFeld.getListe() ? "TopicArray<" + this.getTbClass((MetaThemenbereich)feld.getKlasse()) + ">" : this.getTbClass((MetaThemenbereich)feld.getKlasse());
        } else {
            this.error(aFeld, "Das Feld " + feld.getName() + " hat eine ungueltige Feld-Klasse (" + aFeld.getKlasse() + ")");
        }
        this.print(type);
        this.print("* ");
        this.print(StringHelper.getEscapedName(aFeld.getName()));
        this.print(";");
    }

    @Override
    public void visitTBMaterialReferenz(MetaTBMaterialReferenz materialReferenz) {
        MetaPLMaterial material = materialReferenz.getMaterialbeschreibung();
        MetaCustomThemenbereich materialTb = (MetaCustomThemenbereich)material.getThemenbereich();
        this.indentNewLine();
        this.print(this.getTbClass(materialTb));
        this.print("* ");
        this.print("__material_");
        this.print(StringHelper.getEscapedName(materialReferenz.getName()));
        this.print(";");
    }

    @Override
    public void visitPLPruefung(MetaPLPruefung aPruefung) {
        MetaCustomPruefung pruefung = (MetaCustomPruefung)aPruefung;
        this.indentNewLine();
        String[] referenzFeldStrings = null;
        String[] referenzFeldTypen = null;
        Object referenzFeldIndizes = null;
        if (pruefung.sizeOfHauptBezugsfeld() > 0) {
            MetaIdentifier referenzFeld = null;
            Iterator it = pruefung.getHauptBezugsfeld();
            int anzahlBezugsfelder = pruefung.sizeOfHauptBezugsfeld();
            referenzFeldTypen = new String[anzahlBezugsfelder];
            referenzFeldIndizes = new int[anzahlBezugsfelder][];
            boolean ok = true;
            NamespaceHelper nsHelper = new NamespaceHelper();
            int strukturTiefe = 0;
            while (ok && it.hasNext()) {
                ++strukturTiefe;
                referenzFeld = new MetaIdentifier(((MetaStatspezObjekt)it.next()).getName());
                if (!this.scope.isDefined(referenzFeld, nsHelper.namespace())) {
                    this.error(pruefung, "Pr\u00fcfung " + pruefung.getPruefschluessel() + ": das spezifizierte Referenz-Feld '" + nsHelper.prettyNamespacePlusSep() + referenzFeld.value() + "' ist nicht definiert");
                    ok = false;
                }
                SymbolDescriptor sd = this.scope.symbolDescriptor(referenzFeld, nsHelper.namespace());
                if (ok && strukturTiefe == anzahlBezugsfelder && sd.isArray() && (pruefung.hauptbezugsfeldIndex() == null || pruefung.hauptbezugsfeldIndex().length == 0)) {
                    this.error(pruefung, "Pr\u00fcfung " + pruefung.getPruefschluessel() + ": das spezifizierte Referenz-Listenfeld '" + nsHelper.prettyNamespacePlusSep() + referenzFeld.value() + "' wurde kein Index angegeben.");
                    ok = false;
                }
                if (ok && strukturTiefe == anzahlBezugsfelder && sd.isArray() && pruefung.hauptbezugsfeldIndex() != null) {
                    if (pruefung.hauptbezugsfeldIndex().length != sd.dimensions()) {
                        this.error(pruefung, "Pr\u00fcfung " + pruefung.getPruefschluessel() + ": das spezifizierte Referenz-Listenfeld '" + nsHelper.prettyNamespacePlusSep() + referenzFeld.value() + "' hat nicht die richtige Dimension " + sd.dimensions() + ".");
                        ok = false;
                    } else {
                        for (int j = 0; j < sd.dimensions() && ok; ++j) {
                            if ((sd.dimension(j) < 0 || sd.dimension(j) >= pruefung.hauptbezugsfeldIndex()[j]) && pruefung.hauptbezugsfeldIndex()[j] > 0) continue;
                            String def = sd.dimension(j) >= 0 ? "" + sd.dimension(j) : "N";
                            String ind = pruefung.hauptbezugsfeldIndex()[j] >= 0 ? "" + pruefung.hauptbezugsfeldIndex()[j] : "N";
                            this.error(pruefung, "Pr\u00fcfung " + pruefung.getPruefschluessel() + ": das spezifizierte Referenz-Listenfeld '" + nsHelper.prettyNamespacePlusSep() + referenzFeld.value() + "' hat einen inkonsistenten Index " + ind + " au\u00dferhalb des Bereichs bis " + def + ".");
                            ok = false;
                        }
                    }
                }
                if (ok && !sd.isTbField()) {
                    this.error(pruefung, "Pr\u00fcfung " + pruefung.getPruefschluessel() + ": das spezifizierte Referenz-Feld '" + nsHelper.prettyNamespacePlusSep() + referenzFeld.value() + "' ist kein Themenbereichs-Feld");
                    ok = false;
                }
                if (ok && it.hasNext() && !sd.fieldReferencesTb()) {
                    this.error(pruefung, "Pr\u00fcfung " + pruefung.getPruefschluessel() + ": das spezifizierte Referenz-Feld '" + nsHelper.prettyNamespacePlusSep() + referenzFeld.value() + "' referenziert keinen Themenbereich");
                    ok = false;
                }
                if (ok && !it.hasNext() && sd.fieldReferencesTb()) {
                    this.error(pruefung, "Pr\u00fcfung " + pruefung.getPruefschluessel() + ": das spezifizierte Referenz-Feld '" + nsHelper.prettyNamespacePlusSep() + referenzFeld.value() + "' referenziert einen Themenbereich");
                    ok = false;
                }
                if (ok && sd.isArray()) {
                    if (strukturTiefe == anzahlBezugsfelder) {
                        referenzFeldIndizes[strukturTiefe - 1] = pruefung.hauptbezugsfeldIndex();
                    } else {
                        int[] dims = new int[sd.dimensions()];
                        for (int i = 0; i < dims.length; ++i) {
                            dims[i] = 1;
                        }
                        referenzFeldIndizes[strukturTiefe - 1] = dims;
                    }
                    referenzFeldTypen[strukturTiefe - 1] = sd.fieldReferencesTb() ? "TB_" + StringHelper.getEscapedName(sd.getMerkmal()) : "FeatureVariable";
                }
                if (!ok) continue;
                nsHelper.enterSubNamespace(referenzFeld.value());
            }
            referenzFeldStrings = ok ? nsHelper.namespaceAsArray() : null;
        }
        this.createPruefungFehlerMethod(pruefung, referenzFeldStrings, referenzFeldTypen, (int[][])referenzFeldIndizes);
        this.indentNewLine();
        CppProgramCodeGenerator prgGen = new CppProgramCodeGenerator();
        prgGen.setOutput(this.out);
        prgGen.setIndentLevel(this.indentLevel());
        prgGen.setErrorContext(new ElementMessageContext(1, pruefung.getId(), pruefung.getPruefschluessel(), 6, pruefung.getThemenbereich().getId(), pruefung.getThemenbereich().getName()));
        prgGen.generate(pruefung.getMetaSpezifikation(), this.scope, true, new Short(pruefung.getFehlergewicht()));
    }

    @Override
    public void visitPLAblauf(MetaPLAblauf ablauf) {
        this.indentNewLine();
        CppProgramCodeGenerator prgGen = new CppProgramCodeGenerator();
        prgGen.setOutput(this.out);
        prgGen.setIndentLevel(this.indentLevel());
        MetaCustomAblauf a = (MetaCustomAblauf)ablauf;
        prgGen.setErrorContext(new ElementMessageContext(2, a.getId(), a.getName(), 6, a.getThemenbereich().getId(), a.getThemenbereich().getName()));
        prgGen.generate(a.getMetaSpezifikation(), this.scope, false);
    }

    @Override
    public void visitPLFunktion(MetaPLFunktion funktion) {
        MetaCustomFunktion f = (MetaCustomFunktion)funktion;
        this.indentNewLine();
        String art = f.getArt();
        if ("extern".equals(art)) {
            CppExternalProgramCodeGenerator externalProgramGenerator = new CppExternalProgramCodeGenerator();
            externalProgramGenerator.setOutput(this.out);
            externalProgramGenerator.setIndentLevel(this.indentLevel());
            f.accept(externalProgramGenerator);
        } else if ("ref".equals(art)) {
            CppReferenceFunctionProgramCodeGenerator refFunctionProgramGenerator = new CppReferenceFunctionProgramCodeGenerator();
            refFunctionProgramGenerator.setOutput(this.out);
            refFunctionProgramGenerator.setIndentLevel(this.indentLevel());
            f.accept(refFunctionProgramGenerator);
        } else {
            CppProgramCodeGenerator prgGen = new CppProgramCodeGenerator();
            prgGen.setOutput(this.out);
            prgGen.setIndentLevel(this.indentLevel());
            int contextType = 4;
            if (f.getFunctionType() == 1) {
                contextType = 3;
            }
            prgGen.setErrorContext(new ElementMessageContext(contextType, f.getId(), f.getName(), 6, f.getThemenbereich().getId(), f.getThemenbereich().getName()));
            prgGen.generate(f.getMetaSpezifikation(), this.scope, false);
        }
    }

    @Override
    public void visitPLVariable(MetaPLVariable variable) {
        this.indentNewLine();
        if (variable.getListe()) {
            this.print("LocalArray*");
        } else {
            this.print("LocalVariable*");
        }
        this.print(" ");
        this.print(StringHelper.getEscapedName(variable.getName()));
        this.print(";");
    }

    @Override
    public void visitPLInitwert(MetaPLInitwert initwert) {
        this.indentNewLine();
        this.print("LocalVariable* ");
        this.print(StringHelper.getEscapedName(initwert.getName()));
        this.print(";");
    }

    private void createTbConstructor(MetaThemenbereich aTb) {
        String referringField;
        String referringType;
        boolean isRootTopic;
        this.defineMethod("", this.getTbClass(aTb), "TypeDescriptor* typeDescriptor, FieldDescriptor* parent, Plausi* plausi");
        this.print(" : ");
        this.print("Topic");
        this.print("(typeDescriptor, parent)");
        this.openBlock();
        this.indentNewLine();
        this.print("this->plausi = plausi;");
        boolean bl = isRootTopic = aTb == this.plausi.rootThemenbereich();
        if (isRootTopic) {
            referringType = "PL_NULL";
            referringField = "this";
        } else {
            referringType = "typeDescriptor";
            referringField = "this";
        }
        Iterator it = aTb.getFelder();
        while (it.hasNext()) {
            MetaCustomTBFeld aFeld = (MetaCustomTBFeld)it.next();
            this.indentNewLine();
            this.print(StringHelper.getEscapedName(aFeld.getName()));
            this.print(" = new ");
            if (aFeld.getKlasse() instanceof MetaMerkmal) {
                MetaMerkmal aMerkmal = (MetaMerkmal)aFeld.getKlasse();
                String rtType = CppSettings.getRuntimeFieldType(aMerkmal.getTyp());
                if (rtType == null) {
                    this.error(aFeld, "Ungueltiger Typ fuer das Merkmal des Felds " + aFeld.getName() + ".");
                }
                if (aFeld.getListe()) {
                    this.print("FieldArray");
                } else if (isRootTopic) {
                    this.print("RootField");
                } else {
                    this.print("Field");
                }
                this.print("(new ");
                this.print("TypeDescriptor");
                this.print("(");
                this.print(referringType);
                this.print(", (typeDescriptor != PL_NULL) ? typeDescriptor->getMapping() : PL_NULL, \"");
                this.print(aFeld.getName());
                this.print("\", \"");
                this.print(StringHelper.getEscapedStringValue(CodegenUtil.getDisplayName(this.textResource, aFeld)));
                this.print("\", ");
                this.print(rtType);
                this.print(", ");
                if (aMerkmal.getMaske() != null && aMerkmal.getMaske().length() > 0) {
                    this.print("\"");
                    this.print(StringHelper.getEscapedStringValue(aMerkmal.getMaske()));
                    this.print("\"");
                } else {
                    this.print("PL_NULL");
                }
                this.print(", ");
                if (aFeld.getListe()) {
                    if (aFeld.getMehrfachantworten()) {
                        this.print(1);
                        this.print(", ");
                        this.print(CodegenUtil.getMehrfachantwortTbFieldDimension(aFeld));
                    } else {
                        this.print(aFeld.dimensions().length);
                        for (int i = 0; i < aFeld.dimensions().length; ++i) {
                            this.print(", ");
                            if (aFeld.dimensions()[i] > 0) {
                                this.print(aFeld.dimensions()[i]);
                                continue;
                            }
                            this.print("0");
                        }
                    }
                } else {
                    this.print("0");
                }
                this.print("), ");
                this.print(referringField);
                this.print(")");
            } else {
                MetaThemenbereich feldKlasse = (MetaThemenbereich)aFeld.getKlasse();
                if (aFeld.getListe()) {
                    this.print("TopicArray<");
                    this.print(this.getTbClass(feldKlasse));
                    this.print(">");
                } else {
                    this.print(this.getTbClass(feldKlasse));
                }
                this.print("(");
                if (aFeld.getListe()) {
                    this.print("new ");
                    this.print(this.getTbClass(feldKlasse));
                    this.print("(");
                }
                this.print("new ");
                this.print("TypeDescriptor");
                this.print("(");
                this.print(referringType);
                this.print(", (typeDescriptor != PL_NULL) ? typeDescriptor->getMapping() : PL_NULL, \"");
                this.print(aFeld.getName());
                this.print("\", \"");
                this.print(StringHelper.getEscapedStringValue(CodegenUtil.getDisplayName(this.textResource, aFeld)));
                this.print("\", fieldTypeStructure, PL_NULL, ");
                if (aFeld.getListe()) {
                    this.print(aFeld.dimensions().length);
                    for (int i = 0; i < aFeld.dimensions().length; ++i) {
                        this.print(", ");
                        if (aFeld.dimensions()[i] > 0) {
                            this.print(aFeld.dimensions()[i]);
                            continue;
                        }
                        this.print("0");
                    }
                } else {
                    this.print("0");
                }
                this.print("), ");
                this.print(referringField);
                this.print(", plausi)");
                if (aFeld.getListe()) {
                    this.print(")");
                }
            }
            this.print(";");
            this.indentNewLine();
            this.print("setField(\"");
            this.print(aFeld.getName());
            this.print("\", ");
            this.print(StringHelper.getEscapedName(aFeld.getName()));
            this.print(");");
        }
        it = aTb.getMaterialreferenzen();
        while (it.hasNext()) {
            MetaTBMaterialReferenz materialReferenz = (MetaTBMaterialReferenz)it.next();
            MetaPLMaterial material = materialReferenz.getMaterialbeschreibung();
            MetaCustomThemenbereich materialTb = (MetaCustomThemenbereich)material.getThemenbereich();
            this.indentNewLine();
            this.print("__material_");
            this.print(StringHelper.getEscapedName(materialReferenz.getName()));
            this.print(" = (");
            this.print(this.getTbClass(materialTb));
            this.print("*)plausi->getMaterial(\"");
            this.print(materialReferenz.getName());
            this.print("\");");
        }
        it = aTb.getVariablen();
        while (it.hasNext()) {
            MetaPLVariable variable = (MetaPLVariable)it.next();
            this.indentNewLine();
            this.print(StringHelper.getEscapedName(variable.getName()));
            this.print(" = new ");
            if (variable.getListe()) {
                this.print("LocalArray");
            } else {
                this.print("LocalVariable");
            }
            this.print("(");
            if (variable.getListe()) {
                int[] dimension = Helper.parseDimensionSpec(variable.getDimension().trim());
                this.print(dimension.length);
                for (int i = 0; i < dimension.length; ++i) {
                    this.print(", ");
                    if (dimension[i] > 0) {
                        this.print(dimension[i]);
                        continue;
                    }
                    this.print("0");
                }
            }
            this.print(");");
        }
        it = aTb.getInitialisierungswerte();
        while (it.hasNext()) {
            MetaPLInitwert initwert = (MetaPLInitwert)it.next();
            this.indentNewLine();
            this.print(StringHelper.getEscapedName(initwert.getName()));
            this.print(" = new LocalVariable();");
        }
        this.closeBlock();
    }

    private void createTbDestructor(MetaThemenbereich aTb) {
        this.indentNewLine();
        this.defineMethod("", "~" + this.getTbClass(aTb), "");
        this.openBlock();
        Iterator it = aTb.getVariablen();
        while (it.hasNext()) {
            MetaPLVariable variable = (MetaPLVariable)it.next();
            this.indentNewLine();
            this.print("delete ");
            this.print(StringHelper.getEscapedName(variable.getName()));
            this.print(";");
        }
        it = aTb.getInitialisierungswerte();
        while (it.hasNext()) {
            MetaPLInitwert initwert = (MetaPLInitwert)it.next();
            this.indentNewLine();
            this.print("delete ");
            this.print(StringHelper.getEscapedName(initwert.getName()));
            this.print(";");
        }
        this.closeBlock();
    }

    private void createInitMethod(MetaThemenbereich aTb) {
        if (aTb.sizeOfInitialisierungswerte() > 0) {
            MetaCustomInitwert anInitwert;
            this.indentNewLine();
            this.indentNewLine();
            this.print("PL_VOID ");
            this.print("init");
            this.print("(");
            this.print("RuntimeContext*");
            this.print(" context");
            Iterator it = aTb.getInitialisierungswerte();
            while (it.hasNext()) {
                anInitwert = (MetaCustomInitwert)it.next();
                this.print(", Value* ");
                this.print(StringHelper.getEscapedName(anInitwert.getName()));
            }
            this.print(")");
            this.openBlock();
            it = aTb.getInitialisierungswerte();
            while (it.hasNext()) {
                anInitwert = (MetaCustomInitwert)it.next();
                this.indentNewLine();
                this.print("this->");
                this.print(StringHelper.getEscapedName(anInitwert.getName()));
                this.print("->set(context, ");
                this.print(StringHelper.getEscapedName(anInitwert.getName()));
                this.print(");");
            }
            this.closeBlock();
        }
    }

    private void createGetInstanceMethod(MetaThemenbereich aTb) {
        this.indentNewLine();
        this.print("Topic");
        this.print("* ");
        this.print("createNewInstance");
        this.print("()");
        this.openBlock();
        this.indentNewLine();
        this.print("return new ");
        this.print(this.getTbClass(aTb));
        this.print("(");
        this.print("getTypeDescriptor");
        this.print("(), ");
        this.print("getParent");
        this.print("(), this->plausi);");
        this.closeBlock();
    }

    private void createPruefungFehlerMethod(MetaCustomPruefung pruefung, String[] referenzFeldStruktur, String[] referenzFeldTypen, int[][] referenzFeldIndizes) {
        String programName = pruefung.getMetaSpezifikation().name();
        String checkKey = pruefung.getPruefschluessel();
        MetaProgram errorTextShortProgram = this.textResource.getFehlertextKurzProgram(pruefung);
        MetaProgram errorTextLongProgram = this.textResource.getFehlertextLangProgram(pruefung);
        MetaProgram correctionAdviceProgram = this.textResource.getKorrekturhinweisProgram(pruefung);
        this.defineMethod("PL_VOID", "prb_" + programName, "RuntimeContext* context, ProblemInfoType infoType, const PL_STRING exception = PL_NULL");
        this.openBlock();
        this.indentNewLine();
        this.print("PlausiProblem");
        this.print("* problem = createPlausiProblem(context, \"");
        this.print(checkKey);
        this.print("\");");
        this.indentNewLine();
        this.print("problem->setInfoType(infoType);");
        this.indentNewLine();
        this.print("context->setSectionInfosToProblem(problem);");
        if (errorTextShortProgram != null || errorTextLongProgram != null || correctionAdviceProgram != null) {
            this.indentNewLine();
            this.print("try");
            this.openBlock();
            CppErrorTextProgramCodeGenerator prgGen = new CppErrorTextProgramCodeGenerator();
            prgGen.setOutput(this.out);
            prgGen.setIndentLevel(this.indentLevel());
            if (errorTextShortProgram != null) {
                this.indentNewLine();
                this.print("PL_CHAR __shortDescription[MAX_PROBLEM_TEXT_LENGTH];");
                this.indentNewLine();
                this.print("std::ostrstream __shortDescriptionOut(__shortDescription, MAX_PROBLEM_TEXT_LENGTH);");
                this.indentNewLine();
                this.print("__shortDescriptionOut << ");
                prgGen.generate(errorTextShortProgram, this.scope, false);
                this.print(" << std::ends;");
                this.indentNewLine();
                this.print("problem->setShortDescription(__shortDescription);");
            }
            if (errorTextLongProgram != null) {
                this.indentNewLine();
                this.print("PL_CHAR __longDescription[MAX_PROBLEM_TEXT_LENGTH];");
                this.indentNewLine();
                this.print("std::ostrstream __longDescriptionOut(__longDescription, MAX_PROBLEM_TEXT_LENGTH);");
                this.indentNewLine();
                this.print("__longDescriptionOut << ");
                prgGen.generate(errorTextLongProgram, this.scope, false);
                this.print(" << std::ends;");
                this.indentNewLine();
                this.print("problem->setLongDescription(__longDescription);");
            }
            if (correctionAdviceProgram != null) {
                this.indentNewLine();
                this.print("PL_CHAR __correctionInfo[MAX_PROBLEM_TEXT_LENGTH];");
                this.indentNewLine();
                this.print("std::ostrstream __correctionInfoOut(__correctionInfo, MAX_PROBLEM_TEXT_LENGTH);");
                this.indentNewLine();
                this.print("__correctionInfoOut << ");
                prgGen.generate(correctionAdviceProgram, this.scope, false);
                this.print(" << std::ends;");
                this.indentNewLine();
                this.print("problem->setCorrectionInfo(__correctionInfo);");
            }
            this.closeBlock();
            this.indentNewLine();
            this.print("catch (...)");
            this.openBlock();
            this.closeBlock();
        }
        boolean referenzFeldHatListen = false;
        if (referenzFeldStruktur != null && referenzFeldStruktur.length > 0) {
            int i;
            for (i = 0; i < referenzFeldIndizes.length; ++i) {
                if (referenzFeldIndizes[i] == null || referenzFeldIndizes[i].length <= 0) continue;
                referenzFeldHatListen = true;
                break;
            }
            if (referenzFeldHatListen) {
                this.indentNewLine();
                this.print("try");
                this.openBlock();
            }
            this.indentNewLine();
            this.print("Field* __refField = ");
            for (i = 0; i < referenzFeldStruktur.length; ++i) {
                if (i > 0) {
                    this.print("->");
                }
                boolean referenzFeldIstListe = referenzFeldIndizes[i] != null && referenzFeldIndizes[i].length > 0;
                this.print(StringHelper.getEscapedName(referenzFeldStruktur[i]));
                if (!referenzFeldIstListe) continue;
                this.print("->getElement(context, ");
                this.print(referenzFeldIndizes[i].length);
                for (int j = 0; j < referenzFeldIndizes[i].length; ++j) {
                    this.print(", ");
                    int index = referenzFeldIndizes[i][j];
                    if (index > 0) {
                        --index;
                    }
                    this.print(index);
                }
                this.print(")");
            }
            this.print(";");
            this.indentNewLine();
            this.print("PL_CHAR problemId[MAX_FIELD_NAME_LENGTH];");
            this.indentNewLine();
            this.print("__refField->getHierarchyAsString(problemId);");
            this.indentNewLine();
            this.print("strcat(problemId, \"#");
            this.print(checkKey);
            this.print("\");");
            this.indentNewLine();
            this.print("problem->setId(problemId);");
            this.indentNewLine();
            this.print("problem->setReferenceField(__refField);");
            if (referenzFeldHatListen) {
                this.closeBlock();
                this.indentNewLine();
                this.print("catch (PlausiException& ex)");
                this.openBlock();
                this.indentNewLine();
                this.print("context->getLogger()->error() << \"Fehler beim Zugriff auf Indizes im Hauptbezugsfeld von " + programName + " (\" << ex.getMessage() << \")\";");
            }
        } else {
            this.indentNewLine();
            this.print("problem->setReferenceField(context->getCurrentField());");
        }
        if (referenzFeldHatListen || referenzFeldStruktur == null || referenzFeldStruktur.length == 0) {
            this.indentNewLine();
            this.print("if (context->getCurrentField() != PL_NULL)");
            this.openBlock();
            this.indentNewLine();
            this.print("PL_CHAR problemId[MAX_FIELD_NAME_LENGTH];");
            this.indentNewLine();
            this.print("context->getCurrentField()->getHierarchyAsString(problemId);");
            this.indentNewLine();
            this.print("strcat(problemId, \"#");
            this.print(checkKey);
            this.print("\");");
            this.indentNewLine();
            this.print("problem->setId(problemId);");
            this.closeBlock();
            this.indentNewLine();
            this.print("else");
            this.openBlock();
            this.indentNewLine();
            this.print("problem->setId(\"#");
            this.print(checkKey);
            this.print("\");");
            this.closeBlock();
        }
        if (referenzFeldHatListen) {
            this.closeBlock();
        }
        this.indentNewLine();
        this.print("problem->setException(exception);");
        this.indentNewLine();
        this.print("context->getLogger()->trace() << \"FehlerID angeschrieben: \" << problem->getId();");
        this.closeBlock();
    }

    private void createFieldErrorTextesMethods(MetaThemenbereich tb) {
        Iterator iter = tb.getFelder();
        while (iter.hasNext()) {
            CppErrorTextProgramCodeGenerator prgGen;
            MetaCustomTBFeld feld = (MetaCustomTBFeld)iter.next();
            if (!(feld.getKlasse() instanceof MetaMerkmal)) continue;
            if (feld.getFehlerTextKurzProgram() != null) {
                this.defineMethod("PL_VOID", "prbShort_" + StringHelper.getEscapedName(feld.getName()), "RuntimeContext* context, std::ostrstream& out");
                prgGen = new CppErrorTextProgramCodeGenerator();
                prgGen.setOutput(this.out);
                prgGen.setIndentLevel(this.indentLevel());
                this.openBlock();
                this.indentNewLine();
                this.print("out << ");
                prgGen.generate(feld.getFehlerTextKurzProgram(), this.scope, false);
                this.print(" << std::ends;");
                this.closeBlock();
            }
            if (feld.getFehlerTextLangProgram() != null) {
                this.defineMethod("PL_VOID", "prbLong_" + StringHelper.getEscapedName(feld.getName()), "RuntimeContext* context, std::ostrstream& out");
                prgGen = new CppErrorTextProgramCodeGenerator();
                prgGen.setOutput(this.out);
                prgGen.setIndentLevel(this.indentLevel());
                this.openBlock();
                this.print("out << ");
                prgGen.generate(feld.getFehlerTextLangProgram(), this.scope, false);
                this.print(" << std::ends;");
                this.closeBlock();
            }
            if (feld.getKorrekturhinweisProgram() == null) continue;
            this.defineMethod("PL_VOID", "corrInf_" + StringHelper.getEscapedName(feld.getName()), "RuntimeContext* context, std::ostrstream& out");
            prgGen = new CppErrorTextProgramCodeGenerator();
            prgGen.setOutput(this.out);
            prgGen.setIndentLevel(this.indentLevel());
            this.openBlock();
            this.indentNewLine();
            this.print("out << ");
            prgGen.generate(feld.getKorrekturhinweisProgram(), this.scope, false);
            this.print(" << std::ends;");
            this.closeBlock();
        }
    }
}

