/*
 * Decompiled with CFR 0.152.
 */
package de.statspez.pleditor.generator.codegen.cpp;

import de.statspez.pleditor.generator.codegen.support.CodegenUtil;
import de.statspez.pleditor.generator.codegen.support.HelperVisitor;
import de.statspez.pleditor.generator.codegen.support.HelperVisitorAdapter;
import de.statspez.pleditor.generator.meta.MetaCustomMappingElement;
import de.statspez.pleditor.generator.meta.MetaCustomPlausibilisierung;
import de.statspez.pleditor.generator.meta.generated.MetaMapping;
import de.statspez.pleditor.generator.meta.generated.MetaPLMaterial;
import de.statspez.pleditor.generator.meta.generated.MetaPlausibilisierung;
import java.util.Iterator;

public class CppMappingsCodeGenerator
extends HelperVisitor {
    public static final String MAPPING_VAR_NAME = "__mapping";

    public CppMappingsCodeGenerator(HelperVisitorAdapter adapter) {
        super(adapter);
    }

    public void preGeneration() {
        this.indentNewLine();
        this.out().print("Mapping* ");
        this.out().print(MAPPING_VAR_NAME);
        this.out().print(";");
        this.indentNewLine();
    }

    private void declareMapping(String material, MetaMapping aMapping) {
        if (aMapping != null) {
            this.indentNewLine();
            this.out().print(MAPPING_VAR_NAME);
            this.out().print(" = new Mapping();");
            Iterator it = aMapping.getMappingliste();
            while (it.hasNext()) {
                this.indentNewLine();
                MetaCustomMappingElement mappingElement = (MetaCustomMappingElement)it.next();
                this.out().print(MAPPING_VAR_NAME);
                this.out().print("->put(");
                this.out().print("\"" + mappingElement.getTBFeldListeAlsName() + "\", ");
                if (mappingElement.getDsbFeldAlsName() != null && mappingElement.getDsbFeldAlsName().length() > 0) {
                    this.out().print("\"" + mappingElement.getDsbFeldAlsName() + "\"");
                } else if (mappingElement.getMappingTyp() == 1 && mappingElement.getFeldSatzart() != null && mappingElement.getFeldSatzart().getName() != null && mappingElement.getFeldSatzart().getName().length() > 0) {
                    this.out().print("\"" + mappingElement.getFeldSatzart().getName() + "\"");
                } else {
                    this.out().print("\"\"");
                }
                this.out().print(");");
            }
            this.indentNewLine();
            if (material != null) {
                this.out().print("setMappingForMaterial(");
                this.out().print("\"" + material + "\", ");
                this.out().print(MAPPING_VAR_NAME);
                this.out().print(");");
            } else {
                this.out().print("setMapping(");
                this.out().print(MAPPING_VAR_NAME);
                this.out().print(");");
            }
            this.indentNewLine();
        }
    }

    @Override
    public void visitPlausibilisierung(MetaPlausibilisierung aPlausi) {
        this.declareMapping(null, ((MetaCustomPlausibilisierung)aPlausi).usedMappings());
        MetaPLMaterial[] materials = CodegenUtil.getUsedMaterials(aPlausi);
        if (materials != null && materials.length > 0) {
            for (int i = 0; i < materials.length; ++i) {
                materials[i].accept(this);
            }
        }
    }

    @Override
    public void visitPLMaterial(MetaPLMaterial aMaterial) {
        this.declareMapping(aMaterial.getName(), aMaterial.getMapping());
    }
}

