/*
 * Decompiled with CFR 0.152.
 */
package de.statspez.pleditor.generator.codegen.cpp;

import de.statspez.pleditor.generator.codegen.analysis.ErhebungsTBReferenceBuilder;
import de.statspez.pleditor.generator.codegen.analysis.MaterialNamenPruefer;
import de.statspez.pleditor.generator.codegen.cpp.CppPlausiCodeGenerator;
import de.statspez.pleditor.generator.codegen.semantic.SemanticCheck;
import de.statspez.pleditor.generator.codegen.semantic.SemanticCheckResult;
import de.statspez.pleditor.generator.codegen.support.CodegenException;
import de.statspez.pleditor.generator.codegen.support.GenericSymbolDescriptorFactory;
import de.statspez.pleditor.generator.codegen.support.Scope;
import de.statspez.pleditor.generator.codegen.support.ScopeImpl;
import de.statspez.pleditor.generator.codegen.support.TbScopeBuilder;
import de.statspez.pleditor.generator.codegen.support.TextResource;
import de.statspez.pleditor.generator.codegen.support.Traverser;
import de.statspez.pleditor.generator.common.DefaultMessageContext;
import de.statspez.pleditor.generator.meta.MetaCustomPlausibilisierung;
import de.statspez.pleditor.generator.meta.MetaProgram;
import de.statspez.pleditor.generator.meta.generated.MetaMerkmal;
import de.statspez.pleditor.generator.meta.generated.MetaPlausibilisierung;
import de.statspez.pleditor.generator.meta.generated.MetaThemenbereich;
import de.statspez.pleditor.generator.parser.IntermediateLanguageParser;
import de.statspez.pleditor.generator.parser.speclanguage.SpecLangParseException;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Hashtable;

public class CppCodegenFacade {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        if (args == null || args.length < 2) {
            System.err.println("Das Quellverzeichnis und/oder das Zielverzeichnis wurde nicht angegeben.");
            System.err.println("Usage: CppCodegenFacade <Quellverzeichnis|Datei> <Zielverzeichnis>");
            System.exit(-1);
        }
        InputStreamReader reader = null;
        OutputStreamWriter writer = null;
        File src = new File(args[0]);
        File[] files = src.isDirectory() ? src.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name != null && name.startsWith("Plausi_") && name.endsWith(".xml");
            }
        }) : new File[]{src};
        for (int i = 0; i < files.length; ++i) {
            System.out.println(files[i].getName());
            String plausiName = files[i].getName().substring(0, files[i].getName().length() - 4);
            try {
                IntermediateLanguageParser parser = new IntermediateLanguageParser();
                reader = new FileReader(files[i]);
                MetaCustomPlausibilisierung plausi = (MetaCustomPlausibilisierung)parser.parse(reader);
                writer = new FileWriter(new File(args[1], plausiName + ".cpp"));
                CppCodegenFacade codegen = new CppCodegenFacade();
                codegen.generate(plausi, writer);
                continue;
            }
            catch (CodegenException e) {
                if (e.hasErrors()) {
                    System.err.println("FEHLER BEI DER GENERIERUNG:");
                    System.err.println(e.errorsAsText());
                }
                if (!e.hasWarnings()) continue;
                System.err.println("WARNUNGEN BEI DER GENERIERUNG:");
                System.err.println(e.warningsAsText());
                continue;
            }
            catch (SpecLangParseException e) {
                System.err.println("FEHLER BEI DER GENERIERUNG:");
                System.err.println(e.messagesAsText());
                continue;
            }
            catch (Throwable t) {
                t.printStackTrace();
                continue;
            }
            finally {
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (Exception e) {
                        System.out.println("Die EDT-Datei konnte nicht geschlossen werden.");
                        e.printStackTrace();
                    }
                    try {
                        writer.close();
                    }
                    catch (Exception e) {
                        System.out.println("Die C++-Datei konnte nicht geschlossen werden.");
                        e.printStackTrace();
                    }
                }
            }
        }
    }

    public void generate(MetaPlausibilisierung plausi, Writer out) throws CodegenException {
        this.generate(plausi, out, null, null);
    }

    public void generate(MetaPlausibilisierung plausi, Writer out, TextResource textResource, String classNameSuffix) throws CodegenException {
        this.semanticCheck(plausi);
        this.generateCodeOnly(plausi, out, textResource, classNameSuffix);
    }

    public SemanticCheckResult semanticCheck(MetaProgram prg, Scope prgScope) throws CodegenException {
        SemanticCheck scopeChecker = new SemanticCheck();
        scopeChecker.setErrorContext(prg.contextInfos());
        return scopeChecker.checkProgram(prg, prgScope);
    }

    public void semanticCheck(MetaPlausibilisierung plausi) throws CodegenException {
        final Hashtable tbScopes = new Hashtable();
        final Scope plausiScope = this.createPlausiScopes(plausi, tbScopes);
        plausi.accept(new Traverser(){
            private Scope prgScope = null;

            @Override
            public void visitThemenbereich(MetaThemenbereich aTb) {
                this.prgScope = (Scope)tbScopes.get(aTb.getName());
                super.visitThemenbereich(aTb);
                assert (this.prgScope != null) : "kein Scope fuer Tb " + aTb.getName();
            }

            @Override
            public void visitMerkmal(MetaMerkmal aMerkmal) {
                this.prgScope = new ScopeImpl(plausiScope);
                super.visitMerkmal(aMerkmal);
            }

            @Override
            public void visitProgram(MetaProgram aProgram) {
                assert (this.prgScope != null) : "kein Programm-Scope";
                SemanticCheck scopeChecker = new SemanticCheck();
                scopeChecker.setErrorContext(aProgram.contextInfos());
                scopeChecker.checkProgram(aProgram, this.prgScope);
            }
        });
    }

    public void generateCodeOnly(MetaPlausibilisierung plausi, Writer out) throws CodegenException {
        this.generateCodeOnly(plausi, out, null, null);
    }

    public void generateCodeOnly(MetaPlausibilisierung plausi, Writer out, TextResource textResource, String classNameSuffix) throws CodegenException {
        Hashtable tbScopes = new Hashtable();
        Scope plausiScope = this.createPlausiScopes(plausi, tbScopes);
        ErhebungsTBReferenceBuilder erhebungRefBuilder = new ErhebungsTBReferenceBuilder();
        erhebungRefBuilder.buildErhebungsTBReferences(plausi);
        MaterialNamenPruefer materialNamenPruefer = new MaterialNamenPruefer();
        materialNamenPruefer.checkForDuplicates(plausi);
        CppPlausiCodeGenerator codeGen = new CppPlausiCodeGenerator();
        codeGen.setOutput(out);
        codeGen.setTextResource(textResource);
        codeGen.setClassNameSuffix(classNameSuffix);
        codeGen.setErrorContext(new DefaultMessageContext("Plausibilsierung " + plausi.getName()));
        codeGen.generate(plausi, plausiScope, tbScopes);
    }

    protected Scope createPlausiScopes(MetaPlausibilisierung plausi, Hashtable tbScopes) {
        TbScopeBuilder scopeBuilder = new TbScopeBuilder(new GenericSymbolDescriptorFactory());
        return scopeBuilder.createScopes(plausi, tbScopes);
    }
}

