/*
 * Decompiled with CFR 0.152.
 */
package de.statspez.pleditor.generator.codegen.analysis;

import de.statspez.pleditor.generator.codegen.support.NamespaceHelper;
import de.statspez.pleditor.generator.codegen.support.Traverser;
import de.statspez.pleditor.generator.meta.AbstractElementVisitor;
import de.statspez.pleditor.generator.meta.MetaAblaufStatement;
import de.statspez.pleditor.generator.meta.MetaArrayAccess;
import de.statspez.pleditor.generator.meta.MetaCheckFeldStatement;
import de.statspez.pleditor.generator.meta.MetaContextOperator;
import de.statspez.pleditor.generator.meta.MetaCustomAblauf;
import de.statspez.pleditor.generator.meta.MetaCustomPruefung;
import de.statspez.pleditor.generator.meta.MetaCustomTBFeld;
import de.statspez.pleditor.generator.meta.MetaElement;
import de.statspez.pleditor.generator.meta.MetaFieldAccess;
import de.statspez.pleditor.generator.meta.MetaHierarchicalForEachLoop;
import de.statspez.pleditor.generator.meta.MetaIdentifier;
import de.statspez.pleditor.generator.meta.MetaPruefeStatement;
import de.statspez.pleditor.generator.meta.MetaStructureAccess;
import de.statspez.pleditor.generator.meta.generated.MetaMerkmal;
import de.statspez.pleditor.generator.meta.generated.MetaPLAblauf;
import java.util.HashSet;
import java.util.Stack;
import java.util.Vector;

public class PruefschluesselErmittler
extends Traverser {
    private HashSet bekannteSchluessel = null;
    private Vector pruefschluessel = null;
    private NamespaceHelper nsHelper = null;
    private SymbolReferenceSplitter splitter = new SymbolReferenceSplitter();

    public String[] ermittlePruefschluessel(MetaPLAblauf ablauf) {
        this.bekannteSchluessel = new HashSet();
        this.pruefschluessel = new Vector();
        this.nsHelper = new NamespaceHelper();
        ablauf.accept(this);
        return this.pruefschluessel.toArray(new String[0]);
    }

    @Override
    public void visitHierarchicalForEachLoop(MetaHierarchicalForEachLoop aStatement) {
        this.splitter.splitSymbolReference(aStatement.value());
        String subNamespace = this.splitter.structureEntered() ? this.splitter.namespace() + "." + this.splitter.id().value() : this.splitter.id().value();
        this.nsHelper.enterSubNamespace(subNamespace);
        aStatement.loopBody().accept(this);
        this.nsHelper.leaveSubNamespace();
    }

    @Override
    public void visitContextOperator(MetaContextOperator anOperator) {
        this.nsHelper.startNewNamespace();
        super.visitContextOperator(anOperator);
        this.nsHelper.leaveThisNamespace();
    }

    @Override
    public void visitStructureAccess(MetaStructureAccess aStructureAccess) {
        if (aStructureAccess.structureAccess() instanceof MetaFieldAccess) {
            MetaFieldAccess mfa = (MetaFieldAccess)aStructureAccess.structureAccess();
            this.nsHelper.enterSubNamespace(mfa.accessedField().value());
        } else if (aStructureAccess.structureAccess() instanceof MetaArrayAccess) {
            MetaArrayAccess mfa = (MetaArrayAccess)aStructureAccess.structureAccess();
            this.nsHelper.enterSubNamespace(mfa.accessedArray().value());
        }
        super.visitStructureAccess(aStructureAccess);
        if (aStructureAccess.structureAccess() instanceof MetaFieldAccess || aStructureAccess.structureAccess() instanceof MetaArrayAccess) {
            this.nsHelper.leaveSubNamespace();
        }
    }

    @Override
    public void visitAblaufStatement(MetaAblaufStatement statement) {
        MetaCustomAblauf ablauf = (MetaCustomAblauf)statement.referredElement();
        assert (ablauf != null) : "Aufgerufener Ablauf nicht eingetragen";
        this.splitter.splitSymbolReference(statement.function());
        boolean structureEntered = this.splitter.structureEntered();
        if (structureEntered) {
            this.nsHelper.enterSubNamespace(this.splitter.namespace());
        }
        ablauf.getMetaSpezifikation().accept(this);
        if (structureEntered) {
            this.nsHelper.leaveSubNamespace();
        }
    }

    @Override
    public void visitPruefeStatement(MetaPruefeStatement statement) {
        MetaCustomPruefung pruefung = (MetaCustomPruefung)statement.referredElement();
        assert (pruefung != null) : "Aufgerufene Pruefung nicht eingetragen";
        if (pruefung.sizeOfHauptBezugsfeld() > 0) {
            if (pruefung.sizeOfHauptBezugsfeld() > 0 && pruefung.getFromHauptBezugsfeld(0) instanceof MetaCustomTBFeld) {
                MetaCustomTBFeld feld = (MetaCustomTBFeld)pruefung.getFromHauptBezugsfeld(0);
                String[] feldHierarchien = feld.hierachiesAsString();
                StringBuffer ns = new StringBuffer("");
                for (int j = 1; j < pruefung.sizeOfHauptBezugsfeld(); ++j) {
                    ns.append(".");
                    ns.append(pruefung.getFromHauptBezugsfeld(j).getName());
                }
                String postHierarchie = ns.toString();
                for (int i = 0; i < feldHierarchien.length; ++i) {
                    String fehlerid = feldHierarchien[i] + postHierarchie + "#" + pruefung.getPruefschluessel();
                    if (this.bekannteSchluessel.contains(fehlerid)) continue;
                    this.pruefschluessel.add(fehlerid);
                    this.bekannteSchluessel.add(fehlerid);
                }
            }
        } else {
            String schluessel = "#" + pruefung.getPruefschluessel();
            if (!this.bekannteSchluessel.contains(schluessel)) {
                this.pruefschluessel.add(schluessel);
                this.bekannteSchluessel.add(schluessel);
            }
        }
    }

    @Override
    public void visitCheckFeldStatement(MetaCheckFeldStatement statement) {
        MetaCustomTBFeld feld = (MetaCustomTBFeld)statement.referredElement();
        assert (feld != null) : "Geprueftes Feld nicht eingetragen";
        assert (feld.getKlasse() instanceof MetaMerkmal) : "Feld ist kein Merkmal";
        this.splitter.splitSymbolReference(statement.field());
        boolean structureEntered = this.splitter.structureEntered();
        if (structureEntered) {
            this.nsHelper.enterSubNamespace(this.splitter.namespace());
        }
        MetaMerkmal merkmal = (MetaMerkmal)feld.getKlasse();
        this.nsHelper.enterSubNamespace(feld.getName());
        String fehlerid = this.nsHelper.prettyNamespace() + "#" + merkmal.getName();
        this.nsHelper.leaveSubNamespace();
        if (structureEntered) {
            this.nsHelper.leaveSubNamespace();
        }
        if (!this.bekannteSchluessel.contains(fehlerid)) {
            this.pruefschluessel.add(fehlerid);
            this.bekannteSchluessel.add(fehlerid);
        }
    }

    private class SymbolReferenceSplitter
    extends AbstractElementVisitor {
        private NamespaceHelper nsHelper = null;
        private MetaIdentifier id = null;
        private Stack structureStack = null;

        public void splitSymbolReference(MetaElement symbol) {
            this.nsHelper = new NamespaceHelper();
            this.id = null;
            this.structureStack = new Stack();
            symbol.accept(this);
        }

        public MetaIdentifier id() {
            return this.id;
        }

        public boolean structureEntered() {
            return this.nsHelper.prettyNamespace().length() > 0;
        }

        public String namespace() {
            return this.nsHelper.prettyNamespace();
        }

        @Override
        public void visitIdentifier(MetaIdentifier id) {
            this.id = id;
        }

        @Override
        public void visitStructureAccess(MetaStructureAccess access) {
            if (access.structureAccess() instanceof MetaStructureAccess) {
                this.structureStack.push(access.selectedElement());
                access.structureAccess().accept(this);
            } else {
                this.structureStack.push(access.selectedElement());
                this.structureStack.push(access.structureAccess());
                while (this.structureStack.size() > 1) {
                    ((MetaElement)this.structureStack.pop()).accept(this);
                    assert (this.id != null);
                    this.nsHelper.enterSubNamespace(this.id.value());
                }
                ((MetaElement)this.structureStack.pop()).accept(this);
            }
        }

        @Override
        public void visitArrayAccess(MetaArrayAccess arrayAccess) {
            arrayAccess.accessedArray().accept(this);
        }

        @Override
        public void visitFieldAccess(MetaFieldAccess fieldAccess) {
            fieldAccess.accessedField().accept(this);
        }
    }
}

