/*
 * Decompiled with CFR 0.152.
 */
package mondrian.util;

import java.util.AbstractList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import mondrian.olap.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Pair<L, R>
implements Comparable<Pair<L, R>>,
Map.Entry<L, R> {
    public L left;
    public R right;

    public Pair(L left, R right) {
        this.left = left;
        this.right = right;
    }

    public Pair(Map.Entry<? extends L, ? extends R> entry) {
        this.left = entry.getKey();
        this.right = entry.getValue();
    }

    public static <L, R> Pair<L, R> of(L left, R right) {
        return new Pair<L, R>(left, right);
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof Pair) {
            Pair pair = (Pair)obj;
            return Util.equals(this.left, pair.left) && Util.equals(this.right, pair.right);
        }
        return false;
    }

    @Override
    public int hashCode() {
        int k = this.left == null ? 0 : this.left.hashCode();
        int k1 = this.right == null ? 0 : this.right.hashCode();
        return (k << 4 | k) ^ k1;
    }

    @Override
    public int compareTo(Pair<L, R> that) {
        int c = Pair.compare((Comparable)this.left, (Comparable)that.left);
        if (c == 0) {
            c = Pair.compare((Comparable)this.right, (Comparable)that.right);
        }
        return c;
    }

    public String toString() {
        return "<" + this.left + ", " + this.right + ">";
    }

    @Override
    public L getKey() {
        return this.left;
    }

    @Override
    public R getValue() {
        return this.right;
    }

    @Override
    public R setValue(R value) {
        R previous = this.right;
        this.right = value;
        return previous;
    }

    private static <C extends Comparable<C>> int compare(C c1, C c2) {
        if (c1 == null) {
            if (c2 == null) {
                return 0;
            }
            return -1;
        }
        if (c2 == null) {
            return 1;
        }
        return c1.compareTo(c2);
    }

    public static <K, V> List<Pair<K, V>> zip(final List<K> ks, final List<V> vs) {
        return new AbstractList<Pair<K, V>>(){

            @Override
            public Pair<K, V> get(int index) {
                return Pair.of(ks.get(index), vs.get(index));
            }

            @Override
            public int size() {
                return Math.min(ks.size(), vs.size());
            }
        };
    }

    public static <K, V> List<Pair<K, V>> zip(final K[] ks, final V[] vs) {
        return new AbstractList<Pair<K, V>>(){

            @Override
            public Pair<K, V> get(int index) {
                return Pair.of(ks[index], vs[index]);
            }

            @Override
            public int size() {
                return Math.min(ks.length, vs.length);
            }
        };
    }

    public static <L, R> Iterable<L> leftIter(final Iterable<Pair<L, R>> iterable) {
        return new Iterable<L>(){

            @Override
            public Iterator<L> iterator() {
                final Iterator iterator = iterable.iterator();
                return new Iterator<L>(){

                    @Override
                    public boolean hasNext() {
                        return iterator.hasNext();
                    }

                    @Override
                    public L next() {
                        return ((Pair)iterator.next()).left;
                    }

                    @Override
                    public void remove() {
                        iterator.remove();
                    }
                };
            }
        };
    }

    public static <L, R> Iterable<R> rightIter(final Iterable<Pair<L, R>> iterable) {
        return new Iterable<R>(){

            @Override
            public Iterator<R> iterator() {
                final Iterator iterator = iterable.iterator();
                return new Iterator<R>(){

                    @Override
                    public boolean hasNext() {
                        return iterator.hasNext();
                    }

                    @Override
                    public R next() {
                        return ((Pair)iterator.next()).right;
                    }

                    @Override
                    public void remove() {
                        iterator.remove();
                    }
                };
            }
        };
    }

    public static <K, V> Iterable<Pair<K, V>> iterate(final Iterable<K> i0, final Iterable<V> i1) {
        return new Iterable<Pair<K, V>>(){

            @Override
            public Iterator<Pair<K, V>> iterator() {
                assert (!(i0 instanceof Collection) || !(i1 instanceof Collection) || ((Collection)i0).size() == ((Collection)i1).size()) : "size mismatch: i0=" + i0 + ", i1=" + i1;
                final Iterator iterator0 = i0.iterator();
                final Iterator iterator1 = i1.iterator();
                return new Iterator<Pair<K, V>>(){

                    @Override
                    public boolean hasNext() {
                        boolean hasNext0 = iterator0.hasNext();
                        boolean hasNext1 = iterator1.hasNext();
                        assert (hasNext0 == hasNext1);
                        return hasNext0 && hasNext1;
                    }

                    @Override
                    public Pair<K, V> next() {
                        return Pair.of(iterator0.next(), iterator1.next());
                    }

                    @Override
                    public void remove() {
                        iterator0.remove();
                        iterator1.remove();
                    }
                };
            }
        };
    }

    public static <L, R> List<L> left(final List<Pair<L, R>> list) {
        return new AbstractList<L>(){

            @Override
            public L get(int index) {
                return ((Pair)list.get((int)index)).left;
            }

            @Override
            public int size() {
                return list.size();
            }

            @Override
            public L remove(int index) {
                Pair pair = (Pair)list.remove(index);
                return pair == null ? null : (Object)pair.left;
            }
        };
    }

    public static <L, R> List<R> right(final List<Pair<L, R>> list) {
        return new AbstractList<R>(){

            @Override
            public R get(int index) {
                return ((Pair)list.get((int)index)).right;
            }

            @Override
            public int size() {
                return list.size();
            }

            @Override
            public R remove(int index) {
                Pair pair = (Pair)list.remove(index);
                return pair == null ? null : (Object)pair.right;
            }
        };
    }
}

