/*
 * Decompiled with CFR 0.152.
 */
package mondrian.util;

import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import mondrian.util.CompositeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Composite {
    public static <T> List<T> of(List<? extends T> ... lists) {
        return CompositeList.of(lists);
    }

    public static <T> List<T> optimalOf(List<? extends T> ... lists) {
        List[] lists2 = Composite.optimize(lists);
        switch (lists2.length) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return lists2[0];
            }
        }
        return Composite.of(lists2);
    }

    private static List[] optimize(List[] lists) {
        int n = 0;
        for (List list : lists) {
            if (list.isEmpty()) continue;
            ++n;
        }
        if (n == lists.length) {
            return lists;
        }
        List[] result = new List[n];
        int i = 0;
        for (List list : lists) {
            if (list.isEmpty()) continue;
            result[i++] = list;
        }
        return result;
    }

    public static <T> Iterable<T> of(Iterable<? extends T> ... iterables) {
        return new CompositeIterable<T>(iterables);
    }

    public static <T> Iterator<T> of(Iterator<? extends T> ... iterators) {
        Iterator<? extends T>[] iterators1 = iterators;
        return new CompositeIterator<T>(iterators1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class IterableIterator<T>
    implements Iterator<Iterator<T>> {
        private int i;
        private final Iterable<T>[] iterables;

        public IterableIterator(Iterable<T>[] iterables) {
            this.iterables = iterables;
            this.i = 0;
        }

        @Override
        public boolean hasNext() {
            return this.i < this.iterables.length;
        }

        @Override
        public Iterator<T> next() {
            return this.iterables[this.i++].iterator();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CompositeIterator<T>
    implements Iterator<T> {
        private final Iterator<Iterator<T>> iteratorIterator;
        private boolean hasNext;
        private T next;
        private Iterator<T> iterator;

        public CompositeIterator(Iterator<T>[] iterables) {
            this.iteratorIterator = Arrays.asList(iterables).iterator();
            this.iterator = Collections.emptyList().iterator();
            this.hasNext = true;
            this.advance();
        }

        public CompositeIterator(Iterable<T>[] iterables) {
            this.iteratorIterator = new IterableIterator<T>(iterables);
            Arrays.asList(iterables).iterator();
            this.iterator = Collections.emptyList().iterator();
            this.hasNext = true;
            this.advance();
        }

        private void advance() {
            while (true) {
                if (this.iterator.hasNext()) {
                    this.next = this.iterator.next();
                    return;
                }
                if (!this.iteratorIterator.hasNext()) break;
                this.iterator = this.iteratorIterator.next();
            }
            this.hasNext = false;
        }

        @Override
        public boolean hasNext() {
            return this.hasNext;
        }

        @Override
        public T next() {
            T next1 = this.next;
            this.advance();
            return next1;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CompositeIterable<T>
    implements Iterable<T> {
        private final Iterable<? extends T>[] iterables;

        public CompositeIterable(Iterable<? extends T>[] iterables) {
            this.iterables = iterables;
        }

        @Override
        public Iterator<T> iterator() {
            return new CompositeIterator<T>(this.iterables);
        }
    }
}

