/*
 * Decompiled with CFR 0.152.
 */
package mondrian.spi.impl;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Arrays;
import javax.sql.DataSource;
import mondrian.rolap.RolapUtil;
import mondrian.rolap.SqlStatement;
import mondrian.server.Execution;
import mondrian.server.Locus;
import mondrian.spi.Dialect;
import mondrian.spi.StatisticsProvider;

public class SqlStatisticsProvider
implements StatisticsProvider {
    public int getTableCardinality(Dialect dialect, DataSource dataSource, String catalog, String schema, String table, Execution execution) {
        StringBuilder buf = new StringBuilder("select count(*) from ");
        dialect.quoteIdentifier(buf, catalog, schema, table);
        String sql = buf.toString();
        SqlStatement stmt = RolapUtil.executeQuery(dataSource, sql, new Locus(execution, "SqlStatisticsProvider.getTableCardinality", "Reading row count from table " + Arrays.asList(catalog, schema, table)));
        try {
            ResultSet resultSet = stmt.getResultSet();
            if (resultSet.next()) {
                ++stmt.rowCount;
                int n = resultSet.getInt(1);
                return n;
            }
            int n = -1;
            return n;
        }
        catch (SQLException e) {
            throw stmt.handle(e);
        }
        finally {
            stmt.close();
        }
    }

    public int getQueryCardinality(Dialect dialect, DataSource dataSource, String sql, Execution execution) {
        StringBuilder buf = new StringBuilder();
        buf.append("select count(*) from (").append(sql).append(")");
        if (dialect.requiresAliasForFromQuery()) {
            if (dialect.allowsAs()) {
                buf.append(" as ");
            } else {
                buf.append(" ");
            }
            dialect.quoteIdentifier(buf, "init");
        }
        String countSql = buf.toString();
        SqlStatement stmt = RolapUtil.executeQuery(dataSource, countSql, new Locus(execution, "SqlStatisticsProvider.getQueryCardinality", "Reading row count from query [" + sql + "]"));
        try {
            ResultSet resultSet = stmt.getResultSet();
            if (resultSet.next()) {
                ++stmt.rowCount;
                int n = resultSet.getInt(1);
                return n;
            }
            int n = -1;
            return n;
        }
        catch (SQLException e) {
            throw stmt.handle(e);
        }
        finally {
            stmt.close();
        }
    }

    public int getColumnCardinality(Dialect dialect, DataSource dataSource, String catalog, String schema, String table, String column, Execution execution) {
        String sql = SqlStatisticsProvider.generateColumnCardinalitySql(dialect, schema, table, column);
        if (sql == null) {
            return -1;
        }
        SqlStatement stmt = RolapUtil.executeQuery(dataSource, sql, new Locus(execution, "SqlStatisticsProvider.getColumnCardinality", "Reading cardinality for column " + Arrays.asList(catalog, schema, table, column)));
        try {
            ResultSet resultSet = stmt.getResultSet();
            if (resultSet.next()) {
                ++stmt.rowCount;
                int n = resultSet.getInt(1);
                return n;
            }
            int n = -1;
            return n;
        }
        catch (SQLException e) {
            throw stmt.handle(e);
        }
        finally {
            stmt.close();
        }
    }

    private static String generateColumnCardinalitySql(Dialect dialect, String schema, String table, String column) {
        StringBuilder buf = new StringBuilder();
        String exprString = dialect.quoteIdentifier(column);
        if (dialect.allowsCountDistinct()) {
            buf.append("select count(distinct ").append(exprString).append(") from ");
            dialect.quoteIdentifier(buf, schema, table);
            return buf.toString();
        }
        if (dialect.allowsFromQuery()) {
            buf.append("select count(*) from (select distinct ").append(exprString).append(" from ");
            dialect.quoteIdentifier(buf, schema, table);
            buf.append(")");
            if (dialect.requiresAliasForFromQuery()) {
                if (dialect.allowsAs()) {
                    buf.append(" as ");
                } else {
                    buf.append(' ');
                }
                dialect.quoteIdentifier(buf, "init");
            }
            return buf.toString();
        }
        return null;
    }
}

