/*
 * Decompiled with CFR 0.152.
 */
package mondrian.rolap.agg;

import java.util.Collections;
import java.util.List;
import mondrian.olap.Util;
import mondrian.rolap.BitKey;
import mondrian.rolap.RolapCubeLevel;
import mondrian.rolap.RolapLevel;
import mondrian.rolap.RolapMember;
import mondrian.rolap.RolapSchema;
import mondrian.rolap.RolapStar;
import mondrian.rolap.StarColumnPredicate;
import mondrian.rolap.StarPredicate;
import mondrian.rolap.agg.AndPredicate;
import mondrian.rolap.agg.ListColumnPredicate;
import mondrian.rolap.agg.LiteralColumnPredicate;
import mondrian.rolap.agg.LiteralStarPredicate;
import mondrian.rolap.agg.MemberColumnPredicate;
import mondrian.rolap.agg.MemberTuplePredicate;
import mondrian.rolap.agg.OrPredicate;
import mondrian.rolap.agg.PredicateColumn;
import mondrian.rolap.agg.RangeColumnPredicate;
import mondrian.rolap.agg.ValueColumnPredicate;
import mondrian.spi.Dialect;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Predicates {
    public static StarPredicate memberPredicate(RolapSchema.PhysRouter router, RolapMember member) {
        List<RolapSchema.PhysColumn> keyList = member.getLevel().getAttribute().getKeyList();
        int size = keyList.size();
        switch (size) {
            case 1: {
                return new MemberColumnPredicate(new PredicateColumn(router, keyList.get(0)), member);
            }
        }
        RolapSchema.PhysSchema schema = keyList.get((int)0).relation.getSchema();
        return new MemberTuplePredicate(router, schema, keyList, Collections.singletonList(MemberTuplePredicate.createPoint(member)));
    }

    public static RangeColumnPredicate rangePredicate(RolapSchema.PhysRouter router, boolean lowerInclusive, RolapMember lowerBound, boolean upperInclusive, RolapMember upperBound) {
        assert (lowerBound == null || upperBound == null || lowerBound.getLevel() == upperBound.getLevel());
        assert (lowerBound != null || upperBound != null);
        RolapCubeLevel level = Util.first(lowerBound, upperBound).getLevel();
        if (level.getAttribute().getKeyList().size() == 1) {
            return new RangeColumnPredicate(new PredicateColumn(router, level.getAttribute().getKeyList().get(0)), lowerInclusive, lowerBound == null ? null : (ValueColumnPredicate)Predicates.memberPredicate(router, lowerBound), upperInclusive, upperBound == null ? null : (ValueColumnPredicate)Predicates.memberPredicate(router, upperBound));
        }
        throw new UnsupportedOperationException("TODO:");
    }

    public static BitKey getBitKey(StarPredicate predicate, RolapStar star) {
        Util.deprecated("not used", true);
        BitKey bitKey = BitKey.Factory.makeBitKey(star.getColumnCount());
        for (PredicateColumn predicateColumn : predicate.getColumnList()) {
            RolapSchema.PhysPath path = predicateColumn.router.path(predicateColumn.physColumn);
            RolapStar.Table table = star.lookupTable(path);
            RolapStar.Column column = table.lookupColumnByExpression(predicateColumn.physColumn, false, null, null);
            bitKey.set(column.getBitPosition());
        }
        return bitKey;
    }

    public static MemberTuplePredicate range(RolapSchema.PhysSchema physSchema, RolapSchema.PhysRouter router, RolapMember lower, boolean lowerStrict, RolapMember upper, boolean upperStrict) {
        RolapMember member = lower != null ? lower : upper;
        return new MemberTuplePredicate(router, physSchema, member.getLevel().getAttribute().getKeyList(), Collections.singletonList(MemberTuplePredicate.createRange(lower, lowerStrict, upper, upperStrict)));
    }

    public static MemberTuplePredicate list(RolapSchema.PhysSchema physSchema, RolapSchema.PhysRouter router, RolapLevel level, List<RolapMember> members) {
        assert (members.size() > 0);
        return new MemberTuplePredicate(router, physSchema, level.getAttribute().getKeyList(), MemberTuplePredicate.createList(members));
    }

    public static StarColumnPredicate wildcard(PredicateColumn column, boolean value) {
        return new LiteralColumnPredicate(column, value);
    }

    public static String toSql(StarPredicate predicate, Dialect dialect) {
        StringBuilder buf = new StringBuilder(64);
        predicate.toSql(dialect, buf);
        return buf.toString();
    }

    public static StarPredicate and(List<StarPredicate> predicateList) {
        int size = predicateList.size();
        switch (size) {
            case 1: {
                return predicateList.get(0);
            }
            case 0: {
                return null;
            }
        }
        return new AndPredicate(predicateList);
    }

    public static StarPredicate or(List<StarPredicate> predicateList) {
        int size = predicateList.size();
        switch (size) {
            case 1: {
                return predicateList.get(0);
            }
            case 0: {
                return null;
            }
        }
        return new OrPredicate(predicateList);
    }

    public static StarColumnPredicate equal(PredicateColumn column, Comparable value) {
        return new ValueColumnPredicate(column, value);
    }

    public static StarColumnPredicate or(PredicateColumn column, List<StarColumnPredicate> list) {
        return new ListColumnPredicate(column, list);
    }

    public static LiteralStarPredicate bool(boolean b) {
        return b ? LiteralStarPredicate.TRUE : LiteralStarPredicate.FALSE;
    }

    public static StarColumnPredicate equal(ValueColumnPredicate predicate) {
        return Predicates.equal(predicate.getColumn(), predicate.getValue());
    }
}

