/*
 * Decompiled with CFR 0.152.
 */
package mondrian.rolap.agg;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import mondrian.rolap.StarColumnPredicate;
import mondrian.rolap.StarPredicate;
import mondrian.rolap.agg.AbstractColumnPredicate;
import mondrian.rolap.agg.ListColumnPredicate;
import mondrian.rolap.agg.PredicateColumn;
import mondrian.rolap.agg.ValueColumnPredicate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MinusStarPredicate
extends AbstractColumnPredicate {
    private final StarColumnPredicate plus;
    private final StarColumnPredicate minus;

    public MinusStarPredicate(StarColumnPredicate plus, StarColumnPredicate minus) {
        super(plus.getColumn());
        assert (minus != null);
        this.plus = plus;
        this.minus = minus;
    }

    public boolean equals(Object obj) {
        if (obj instanceof MinusStarPredicate) {
            MinusStarPredicate that = (MinusStarPredicate)obj;
            return this.plus.equals(that.plus) && this.minus.equals(that.minus);
        }
        return false;
    }

    public int hashCode() {
        return this.plus.hashCode() * 31 + this.minus.hashCode();
    }

    @Override
    public void values(Collection<Object> collection) {
        HashSet<Object> plusValues = new HashSet<Object>();
        this.plus.values(plusValues);
        ArrayList<Object> minusValues = new ArrayList<Object>();
        this.minus.values(minusValues);
        plusValues.removeAll(minusValues);
        collection.addAll(plusValues);
    }

    @Override
    public boolean evaluate(Object value) {
        return this.plus.evaluate(value) && !this.minus.evaluate(value);
    }

    @Override
    public void describe(StringBuilder buf) {
        buf.append("(").append(this.plus).append(" - ").append(this.minus).append(")");
    }

    @Override
    public StarColumnPredicate.Overlap intersect(StarColumnPredicate predicate) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean mightIntersect(StarPredicate other) {
        return this.plus.mightIntersect(other);
    }

    @Override
    public StarColumnPredicate minus(StarPredicate predicate) {
        ValueColumnPredicate valuePredicate;
        assert (predicate != null);
        if (predicate instanceof ValueColumnPredicate && !this.evaluate((valuePredicate = (ValueColumnPredicate)predicate).getValue())) {
            return this;
        }
        if (this.minus instanceof ListColumnPredicate) {
            ListColumnPredicate minusList = (ListColumnPredicate)this.minus;
            PredicateColumn column = this.plus.getColumn();
            if (predicate instanceof ListColumnPredicate) {
                ListColumnPredicate list = (ListColumnPredicate)predicate;
                ArrayList<StarColumnPredicate> unionList = new ArrayList<StarColumnPredicate>();
                unionList.addAll(minusList.getPredicates());
                unionList.addAll(list.getPredicates());
                return new MinusStarPredicate(this.plus, new ListColumnPredicate(column, unionList));
            }
            if (predicate instanceof ValueColumnPredicate) {
                ValueColumnPredicate valuePredicate2 = (ValueColumnPredicate)predicate;
                if (!this.evaluate(valuePredicate2.getValue())) {
                    return this;
                }
                ArrayList<StarColumnPredicate> unionList = new ArrayList<StarColumnPredicate>();
                unionList.addAll(minusList.getPredicates());
                unionList.add(new ValueColumnPredicate(column, valuePredicate2.getValue()));
                return new MinusStarPredicate(this.plus, new ListColumnPredicate(column, unionList));
            }
        }
        return new MinusStarPredicate(this, (StarColumnPredicate)predicate);
    }
}

