/*
 * Decompiled with CFR 0.152.
 */
package mondrian.rolap;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import mondrian.olap.Util;
import mondrian.spi.Dialect;
import mondrian.util.Format;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class TimeColumnRole
extends Enum<TimeColumnRole> {
    public static final /* enum */ TimeColumnRole JULIAN = new TimeColumnRole("time_id", Dialect.Datatype.Integer);
    public static final /* enum */ TimeColumnRole YYMMDD = new TimeColumnRole("yymmdd", Dialect.Datatype.Integer);
    public static final /* enum */ TimeColumnRole YYYYMMDD = new TimeColumnRole("yyyymmdd", Dialect.Datatype.Integer);
    public static final /* enum */ TimeColumnRole DATE = new TimeColumnRole("the_date", Dialect.Datatype.Date);
    public static final /* enum */ TimeColumnRole DAY_OF_WEEK = new TimeColumnRole("day_of_week", Dialect.Datatype.Integer);
    public static final /* enum */ TimeColumnRole DAY_OF_WEEK_IN_MONTH = new TimeColumnRole("day_of_week_in_month", Dialect.Datatype.Integer);
    public static final /* enum */ TimeColumnRole DAY_OF_WEEK_NAME = new TimeColumnRole("the_day", Dialect.Datatype.String);
    public static final /* enum */ TimeColumnRole MONTH_NAME = new TimeColumnRole("the_month", Dialect.Datatype.String);
    public static final /* enum */ TimeColumnRole YEAR = new TimeColumnRole("the_year", Dialect.Datatype.Integer);
    public static final /* enum */ TimeColumnRole DAY_OF_MONTH = new TimeColumnRole("day_of_month", Dialect.Datatype.Integer);
    public static final /* enum */ TimeColumnRole WEEK_OF_YEAR = new TimeColumnRole("week_of_year", Dialect.Datatype.Integer);
    public static final /* enum */ TimeColumnRole MONTH = new TimeColumnRole("month_of_year", Dialect.Datatype.Integer);
    public static final /* enum */ TimeColumnRole QUARTER = new TimeColumnRole("quarter", Dialect.Datatype.String);
    final String columnName;
    final Dialect.Datatype defaultDatatype;
    public static final Map<String, TimeColumnRole> mapNameToRole;
    private static String[] quarters;
    private static final /* synthetic */ TimeColumnRole[] $VALUES;

    public static TimeColumnRole[] values() {
        return (TimeColumnRole[])$VALUES.clone();
    }

    public static TimeColumnRole valueOf(String name) {
        return Enum.valueOf(TimeColumnRole.class, name);
    }

    private TimeColumnRole(String columnName, Dialect.Datatype datatype) {
        this.columnName = columnName;
        this.defaultDatatype = datatype;
    }

    static {
        $VALUES = new TimeColumnRole[]{JULIAN, YYMMDD, YYYYMMDD, DATE, DAY_OF_WEEK, DAY_OF_WEEK_IN_MONTH, DAY_OF_WEEK_NAME, MONTH_NAME, YEAR, DAY_OF_MONTH, WEEK_OF_YEAR, MONTH, QUARTER};
        quarters = new String[]{"Q1", "Q1", "Q1", "Q2", "Q2", "Q2", "Q3", "Q3", "Q3", "Q4", "Q4", "Q4"};
        HashMap<String, TimeColumnRole> map = new HashMap<String, TimeColumnRole>();
        for (TimeColumnRole value : TimeColumnRole.values()) {
            TimeColumnRole put = map.put(value.columnName.toUpperCase(), value);
            assert (put == null) : "duplicate column";
        }
        mapNameToRole = Collections.unmodifiableMap(map);
    }

    public static class Struct {
        public final TimeColumnRole role;
        public final Date epoch;

        public Struct(TimeColumnRole role, Date epoch) {
            this.role = role;
            this.epoch = epoch;
            assert (role != null);
        }

        Object initialize(Locale locale) {
            switch (this.role) {
                case DAY_OF_WEEK_NAME: {
                    return new Format("dddd", locale);
                }
                case MONTH_NAME: {
                    return new Format("mmmm", locale);
                }
                case JULIAN: {
                    if (this.epoch != null) {
                        return Util.julian(this.epoch.getYear() + 1900, this.epoch.getMonth() + 1, this.epoch.getDate());
                    }
                    return 0L;
                }
            }
            return null;
        }

        void bind(Object[] states, int ordinal, Calendar calendar, PreparedStatement pstmt) throws SQLException {
            switch (this.role) {
                case JULIAN: {
                    long julian = Util.julian(calendar.get(1), calendar.get(2) + 1, calendar.get(5)) - (Long)states[ordinal];
                    pstmt.setLong(ordinal, julian);
                    return;
                }
                case YYMMDD: {
                    pstmt.setLong(ordinal, calendar.get(1) % 100 * 10000 + (calendar.get(2) + 1) * 100 + calendar.get(5));
                    return;
                }
                case YYYYMMDD: {
                    pstmt.setLong(ordinal, calendar.get(1) * 10000 + (calendar.get(2) + 1) * 100 + calendar.get(5));
                    return;
                }
                case DATE: {
                    pstmt.setDate(ordinal, new java.sql.Date(calendar.getTimeInMillis()));
                    return;
                }
                case DAY_OF_MONTH: {
                    pstmt.setInt(ordinal, calendar.get(5));
                    return;
                }
                case DAY_OF_WEEK_NAME: 
                case MONTH_NAME: {
                    pstmt.setString(ordinal, ((Format)states[ordinal]).format(calendar));
                    return;
                }
                case DAY_OF_WEEK: {
                    pstmt.setInt(ordinal, calendar.get(7));
                    return;
                }
                case DAY_OF_WEEK_IN_MONTH: {
                    pstmt.setInt(ordinal, calendar.get(8));
                    return;
                }
                case WEEK_OF_YEAR: {
                    pstmt.setInt(ordinal, calendar.get(3));
                    return;
                }
                case MONTH: {
                    pstmt.setInt(ordinal, calendar.get(2) + 1);
                    return;
                }
                case QUARTER: {
                    pstmt.setString(ordinal, quarters[calendar.get(2)]);
                    return;
                }
                case YEAR: {
                    pstmt.setInt(ordinal, calendar.get(1));
                    return;
                }
            }
            throw Util.unexpected(this.role);
        }
    }
}

